/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.IntStream;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.Research;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.inventory.BackpackInventory;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;

public final class PlayerProfile {
    private UUID uuid;
    private Config cfg;
    private boolean dirty = false;
    private boolean markedForDeletion = false;
    private Set<Research> researches = new HashSet<Research>();
    private Map<Integer, BackpackInventory> backpacks = new HashMap<Integer, BackpackInventory>();

    private PlayerProfile(UUID uuid) {
        this.uuid = uuid;
        this.cfg = new Config(new File("data-storage/Slimefun/Players/" + uuid.toString() + ".yml"));
        for (Research research : Research.list()) {
            if (!this.cfg.contains("researches." + research.getID())) continue;
            this.researches.add(research);
        }
    }

    public Config getConfig() {
        return this.cfg;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void save() {
        for (BackpackInventory backpack : this.backpacks.values()) {
            backpack.save();
        }
        this.cfg.save();
        this.dirty = false;
    }

    public void setResearched(Research research, boolean unlock) {
        this.dirty = true;
        if (unlock) {
            this.cfg.setValue("researches." + research.getID(), (Object)true);
            this.researches.add(research);
        } else {
            this.cfg.setValue("researches." + research.getID(), null);
            this.researches.remove(research);
        }
    }

    public boolean hasUnlocked(Research research) {
        return !research.isEnabled() || this.researches.contains(research);
    }

    public Set<Research> getResearches() {
        return this.researches;
    }

    public void markForDeletion() {
        this.markedForDeletion = true;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public BackpackInventory createBackpack(int size) {
        IntStream stream = IntStream.iterate(0, i -> i + 1).filter(i -> !this.cfg.contains("backpacks." + i + ".size"));
        int id = stream.findFirst().getAsInt();
        BackpackInventory backpack = new BackpackInventory(this, id, size);
        this.backpacks.put(id, backpack);
        return backpack;
    }

    public BackpackInventory getBackpack(int id) {
        BackpackInventory backpack = this.backpacks.get(id);
        if (backpack != null) {
            return backpack;
        }
        backpack = new BackpackInventory(this, id);
        this.backpacks.put(id, backpack);
        return backpack;
    }

    public String getTitle() {
        List<String> titles = SlimefunPlugin.getSettings().researchesTitles;
        int index = Math.round(Float.valueOf(String.valueOf((float)Math.round((float)this.researches.size() * 100.0f / (float)Research.list().size() * 100.0f) / 100.0f)).floatValue() / 100.0f) * titles.size();
        if (index > 0) {
            --index;
        }
        return titles.get(index);
    }

    public static PlayerProfile fromUUID(UUID uuid) {
        PlayerProfile profile = SlimefunPlugin.getUtilities().profiles.get(uuid);
        if (profile == null) {
            profile = new PlayerProfile(uuid);
            SlimefunPlugin.getUtilities().profiles.put(uuid, profile);
        } else {
            profile.markedForDeletion = false;
        }
        return profile;
    }

    public static boolean isLoaded(UUID uuid) {
        return SlimefunPlugin.getUtilities().profiles.containsKey(uuid);
    }

    public static Iterator<PlayerProfile> iterator() {
        return SlimefunPlugin.getUtilities().profiles.values().iterator();
    }

    public static BackpackInventory getBackpack(ItemStack item) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasLore()) {
            return null;
        }
        Optional<Object> id = Optional.empty();
        String uuid = "";
        for (String line : item.getItemMeta().getLore()) {
            if (!line.startsWith(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7ID: ")) || !line.contains("#")) continue;
            try {
                id = Optional.of(Integer.parseInt(line.split("#")[1]));
                uuid = line.split("#")[0].replace(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7ID: "), "");
            }
            catch (NumberFormatException x) {
                return null;
            }
        }
        if (id.isPresent()) {
            return PlayerProfile.fromUUID(UUID.fromString(uuid)).getBackpack((Integer)id.get());
        }
        return null;
    }

    public String toString() {
        return "PlayerProfile {" + this.uuid + "}";
    }
}

