/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems;

import java.util.ArrayList;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public final class MachineHelper {
    private MachineHelper() {
    }

    public static String getTimeLeft(int seconds) {
        String timeleft = "";
        int minutes = (int)((long)seconds / 60L);
        if (minutes > 0) {
            timeleft = String.valueOf(timeleft) + minutes + "m ";
        }
        timeleft = String.valueOf(timeleft) + (seconds -= minutes * 60) + "s";
        return ChatColor.translateAlternateColorCodes((char)'&', (String)("&7" + timeleft + " left"));
    }

    public static String getProgress(int time, int total) {
        int i;
        StringBuilder progress = new StringBuilder();
        float percentage = Math.round((float)(total - time) * 100.0f / (float)total * 100.0f / 100.0f);
        if (percentage < 16.0f) {
            progress.append("&4");
        } else if (percentage < 32.0f) {
            progress.append("&c");
        } else if (percentage < 48.0f) {
            progress.append("&6");
        } else if (percentage < 64.0f) {
            progress.append("&e");
        } else if (percentage < 80.0f) {
            progress.append("&2");
        } else {
            progress = progress.append("&a");
        }
        int rest = 20;
        for (i = (int)percentage; i >= 5; i -= 5) {
            progress.append(":");
            --rest;
        }
        progress.append("&7");
        for (i = 0; i < rest; ++i) {
            progress.append(":");
        }
        progress.append(" - " + percentage + "%");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)progress.toString());
    }

    public static String getCoolant(int time, int total) {
        int i;
        int passed = (total - time) % 25;
        StringBuilder progress = new StringBuilder();
        float percentage = Math.round((float)(25 - passed) * 100.0f / 25.0f * 100.0f / 100.0f);
        if (percentage < 33.0f) {
            progress.append("&9");
        } else if (percentage < 66.0f) {
            progress.append("&1");
        } else {
            progress = progress.append("&b");
        }
        int rest = 20;
        for (i = (int)percentage; i >= 5; i -= 5) {
            progress.append(":");
            --rest;
        }
        progress.append("&7");
        for (i = 0; i < rest; ++i) {
            progress.append(":");
        }
        progress.append(" - " + percentage + "%");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)progress.toString());
    }

    public static float getPercentage(int time, int total) {
        int passed = (total - time) % 25;
        return Math.round((float)(25 - passed) * 100.0f / 25.0f * 100.0f / 100.0f);
    }

    public static short getDurability(ItemStack item, int timeleft, int max) {
        return (short)(item.getType().getMaxDurability() / max * timeleft);
    }

    public static void updateProgressbar(BlockMenu menu, int slot, int timeleft, int time, ItemStack indicator) {
        ItemStack item = indicator.clone();
        ItemMeta im = item.getItemMeta();
        im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        ((Damageable)im).setDamage((int)MachineHelper.getDurability(item, timeleft, time));
        im.setDisplayName(" ");
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(MachineHelper.getProgress(timeleft, time));
        lore.add("");
        lore.add(MachineHelper.getTimeLeft(timeleft / 2));
        im.setLore(lore);
        item.setItemMeta(im);
        menu.replaceExistingItem(slot, item);
    }
}

