/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.listeners;

import java.util.LinkedList;
import me.mrCookieSlime.Slimefun.Events.MultiBlockInteractEvent;
import me.mrCookieSlime.Slimefun.Objects.MultiBlock;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler;
import me.mrCookieSlime.Slimefun.Objects.handlers.MultiBlockInteractionHandler;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BlockListener
implements Listener {
    public BlockListener(SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onBlockFall(EntityChangeBlockEvent event) {
        if (event.getEntity() instanceof FallingBlock && BlockStorage.hasBlockInfo(event.getBlock())) {
            event.setCancelled(true);
            FallingBlock fb = (FallingBlock)event.getEntity();
            if (fb.getDropItem()) {
                fb.getWorld().dropItemNaturally(fb.getLocation(), new ItemStack(fb.getBlockData().getMaterial(), 1));
            }
        }
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent e) {
        for (Block b : e.getBlocks()) {
            if (!BlockStorage.hasBlockInfo(b) && (b.getRelative(e.getDirection()).getType() != Material.AIR || !BlockStorage.hasBlockInfo(b.getRelative(e.getDirection())))) continue;
            e.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent e) {
        if (e.isSticky()) {
            for (Block b : e.getBlocks()) {
                if (!BlockStorage.hasBlockInfo(b) && (b.getRelative(e.getDirection()).getType() != Material.AIR || !BlockStorage.hasBlockInfo(b.getRelative(e.getDirection())))) continue;
                e.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent e) {
        if (e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            if (e.getHand() != EquipmentSlot.HAND) {
                return;
            }
            Player p = e.getPlayer();
            Block b = e.getClickedBlock();
            LinkedList<MultiBlock> multiblocks = new LinkedList<MultiBlock>();
            for (MultiBlock multiBlock : MultiBlock.list()) {
                Block center = b.getRelative(multiBlock.getTriggerBlock());
                if (!this.compareMaterials(center, multiBlock.getBuild(), multiBlock.isSymmetric())) continue;
                multiblocks.add(multiBlock);
            }
            if (!multiblocks.isEmpty()) {
                e.setCancelled(true);
                MultiBlock multiblock = (MultiBlock)multiblocks.getLast();
                for (ItemHandler handler : SlimefunItem.getHandlers("MultiBlockInteractionHandler")) {
                    if (((MultiBlockInteractionHandler)handler).onInteract(p, multiblock, b)) break;
                }
                MultiBlockInteractEvent multiBlockInteractEvent = new MultiBlockInteractEvent(p, multiblock, b);
                Bukkit.getPluginManager().callEvent((Event)multiBlockInteractEvent);
            }
        }
    }

    protected boolean compareMaterials(Block b, Material[] blocks, boolean onlyTwoWay) {
        BlockFace[] directions;
        BlockFace[] blockFaceArray;
        if (!this.compareMaterialsVertical(b, blocks[1], blocks[4], blocks[7])) {
            return false;
        }
        if (onlyTwoWay) {
            BlockFace[] blockFaceArray2 = new BlockFace[2];
            blockFaceArray2[0] = BlockFace.NORTH;
            blockFaceArray = blockFaceArray2;
            blockFaceArray2[1] = BlockFace.EAST;
        } else {
            BlockFace[] blockFaceArray3 = new BlockFace[4];
            blockFaceArray3[0] = BlockFace.NORTH;
            blockFaceArray3[1] = BlockFace.EAST;
            blockFaceArray3[2] = BlockFace.SOUTH;
            blockFaceArray = blockFaceArray3;
            blockFaceArray3[3] = BlockFace.WEST;
        }
        for (BlockFace direction : directions = blockFaceArray) {
            if (!this.compareMaterialsVertical(b.getRelative(direction), blocks[0], blocks[3], blocks[6]) || !this.compareMaterialsVertical(b.getRelative(direction.getOppositeFace()), blocks[2], blocks[5], blocks[8])) continue;
            return true;
        }
        return false;
    }

    protected boolean compareMaterialsVertical(Block b, Material top, Material center, Material bottom) {
        if (center != null && b.getType() != center) {
            return false;
        }
        if (top != null && b.getRelative(BlockFace.UP).getType() != top) {
            return false;
        }
        return bottom == null || b.getRelative(BlockFace.DOWN).getType() == bottom;
    }
}

