/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines.electric;

import me.mrCookieSlime.CSCoreLibPlugin.CSCoreLib;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Variable;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.InvUtils;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.Slimefun.GEO.OreGenSystem;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineHelper;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.Setup.Messages;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class OilPump
extends AContainer {
    public OilPump(Category category, ItemStack item, String name, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, name, recipeType, recipe);
        new BlockMenuPreset(name, this.getInventoryTitle()){

            @Override
            public void init() {
                OilPump.this.constructMenu(this);
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                if (!p.hasPermission("slimefun.inventory.bypass") && !CSCoreLib.getLib().getProtectionManager().canAccessChest(p.getUniqueId(), b, true)) {
                    return false;
                }
                if (!OreGenSystem.wasResourceGenerated(OreGenSystem.getResource("Oil"), b.getChunk())) {
                    Messages.local.sendTranslation((CommandSender)p, "gps.geo.scan-required", true, new Variable[0]);
                    return false;
                }
                return true;
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.INSERT) {
                    return OilPump.this.getInputSlots();
                }
                return OilPump.this.getOutputSlots();
            }
        };
    }

    @Override
    public String getMachineIdentifier() {
        return "OIL_PUMP";
    }

    @Override
    public String getInventoryTitle() {
        return "&4Oil Pump";
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.DIAMOND_SHOVEL);
    }

    @Override
    protected void tick(Block b) {
        if (this.isProcessing(b)) {
            int timeleft = (Integer)progress.get(b);
            if (timeleft > 0) {
                MachineHelper.updateProgressbar(BlockStorage.getInventory(b), 22, timeleft, ((MachineRecipe)processing.get(b)).getTicks(), this.getProgressBar());
                if (ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
                    return;
                }
                ChargableBlock.addCharge(b, -this.getEnergyConsumption());
                progress.put(b, timeleft - 1);
            } else {
                BlockStorage.getInventory(b).replaceExistingItem(22, (ItemStack)new CustomItem(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " "));
                this.pushItems(b, ((MachineRecipe)processing.get(b)).getOutput());
                progress.remove(b);
                processing.remove(b);
            }
        } else if (OreGenSystem.getSupplies(OreGenSystem.getResource("Oil"), b.getChunk(), false) > 0) {
            for (int slot : this.getInputSlots()) {
                if (!SlimefunManager.isItemSimiliar(BlockStorage.getInventory(b).getItemInSlot(slot), new ItemStack(Material.BUCKET), true)) continue;
                MachineRecipe r = new MachineRecipe(26, new ItemStack[0], new ItemStack[]{SlimefunItems.BUCKET_OF_OIL});
                if (!this.fits(b, r.getOutput())) {
                    return;
                }
                BlockStorage.getInventory(b).replaceExistingItem(slot, InvUtils.decreaseItem((ItemStack)BlockStorage.getInventory(b).getItemInSlot(slot), (int)1));
                processing.put(b, r);
                progress.put(b, r.getTicks());
                OreGenSystem.setSupplies(OreGenSystem.getResource("Oil"), b.getChunk(), OreGenSystem.getSupplies(OreGenSystem.getResource("Oil"), b.getChunk(), false) - 1);
                break;
            }
        }
    }
}

