/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.protection;

import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.ASkyBlockProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.BentoBoxProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.BlockLockerProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.FactionsProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.FactionsUUIDProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.GriefPreventionProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.LWCProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.LocketteProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.PlotSquaredProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.PreciousStonesProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.RedProtectProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.TownyProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.WorldGuardProtectionModule;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;

public class ProtectionManager {
    private final Set<ProtectionModule> modules = new HashSet<ProtectionModule>();

    public ProtectionManager(Server server) {
        if (server.getPluginManager().isPluginEnabled("WorldGuard") && server.getPluginManager().isPluginEnabled("WorldEdit")) {
            this.registerModule(new WorldGuardProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("Factions")) {
            if (server.getPluginManager().getPlugin("Factions").getDescription().getDepend().contains("MassiveCore")) {
                this.registerModule(new FactionsProtectionModule());
            } else {
                this.registerModule(new FactionsUUIDProtectionModule());
            }
        }
        if (server.getPluginManager().isPluginEnabled("Towny")) {
            this.registerModule(new TownyProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("GriefPrevention")) {
            this.registerModule(new GriefPreventionProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("ASkyBlock")) {
            this.registerModule(new ASkyBlockProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("LWC")) {
            this.registerModule(new LWCProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("PreciousStones")) {
            this.registerModule(new PreciousStonesProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("Lockette")) {
            this.registerModule(new LocketteProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("PlotSquared")) {
            this.registerModule(new PlotSquaredProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("RedProtect")) {
            this.registerModule(new RedProtectProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("BentoBox")) {
            this.registerModule(new BentoBoxProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("BlockLocker")) {
            this.registerModule(new BlockLockerProtectionModule());
        }
        if (server.getPluginManager().isPluginEnabled("ProtectionStones")) {
            this.loadModuleMSG("ProtectionStones");
        }
        if (server.getPluginManager().isPluginEnabled("uSkyblock")) {
            this.loadModuleMSG("uSkyblock");
        }
    }

    public void registerModule(String name, ProtectionModule module) {
        this.modules.add(module);
        this.loadModuleMSG(name);
    }

    public void registerModule(ProtectionModule module) {
        try {
            this.registerModule(module.getName(), module);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    protected void loadModuleMSG(String module) {
        System.out.println("[CS-CoreLib - Protection] Loaded Protection Module \"" + module + "\"");
    }

    public boolean hasPermission(@NonNull OfflinePlayer p, @NonNull Location l, @NonNull ProtectionModule.Action action) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (l == null) {
            throw new NullPointerException("l is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        try {
            for (ProtectionModule module : this.modules) {
                if (module.hasPermission(p, l, action)) continue;
                return false;
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            return false;
        }
        return true;
    }
}

