/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.updater;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.UpdateCheck;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.Updater;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class GitHubBuildsUpdater
implements Updater {
    private static final String api_url = "https://thebusybiscuit.github.io/builds/";
    private Plugin plugin;
    private URL url;
    private URL download;
    private Thread thread;
    private File file;
    private String repository;
    private String localVersion;
    private String remoteVersion;
    protected int timeout = 5000;
    protected UpdateCheck predicate;

    public GitHubBuildsUpdater(Plugin plugin, File file, String repo) {
        this.plugin = plugin;
        this.file = file;
        this.repository = repo;
        this.localVersion = this.extractBuild(plugin.getDescription().getVersion());
        this.predicate = (local, remote) -> Integer.parseInt(remote) > Integer.parseInt(local);
        this.prepareUpdateFolder();
    }

    private String extractBuild(String version) {
        if (version.startsWith("DEV - ")) {
            return version.substring("DEV - ".length()).split(" ")[0];
        }
        throw new IllegalArgumentException("Not a valid Development-Build Version: " + version);
    }

    @Override
    public void start() {
        try {
            this.url = new URL(api_url + this.getRepository() + "/builds.json");
            this.plugin.getServer().getScheduler().runTask(this.plugin, () -> {
                this.thread = new Thread(new UpdaterTask());
                this.thread.start();
            });
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public String getRepository() {
        return this.repository;
    }

    @Override
    public String getLocalVersion() {
        return this.localVersion;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setPredicate(UpdateCheck predicate) {
        this.predicate = predicate;
    }

    public class UpdaterTask
    implements Runnable {
        @Override
        public void run() {
            if (this.connect()) {
                try {
                    this.check();
                }
                catch (NumberFormatException x) {
                    System.err.println(" ");
                    System.err.println("#################### - ERROR - ####################");
                    System.err.println("Could not auto-update " + GitHubBuildsUpdater.this.plugin.getName());
                    System.err.println("Unrecognized Version: \"" + GitHubBuildsUpdater.this.localVersion + "\"");
                    System.err.println("#################### - ERROR - ####################");
                    System.err.println(" ");
                }
            }
        }

        private boolean connect() {
            try {
                URLConnection connection = GitHubBuildsUpdater.this.url.openConnection();
                connection.setConnectTimeout(GitHubBuildsUpdater.this.timeout);
                connection.addRequestProperty("User-Agent", "Auto Updater (by TheBusyBiscuit)");
                connection.setDoOutput(true);
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                JsonObject obj = (JsonObject)new JsonParser().parse(reader.readLine());
                if (obj == null) {
                    System.err.println("[CS-CoreLib - Updater] Could not connect to github.io for Plugin \"" + GitHubBuildsUpdater.this.plugin.getName() + "\", is it down?");
                    try {
                        GitHubBuildsUpdater.this.thread.join();
                    }
                    catch (InterruptedException x) {
                        x.printStackTrace();
                    }
                    return false;
                }
                GitHubBuildsUpdater.this.remoteVersion = String.valueOf(obj.get("last_successful").getAsInt());
                GitHubBuildsUpdater.this.download = new URL(GitHubBuildsUpdater.api_url + GitHubBuildsUpdater.this.getRepository() + "/" + GitHubBuildsUpdater.this.getRepository().split("/")[1] + "-" + GitHubBuildsUpdater.this.remoteVersion + ".jar");
                return true;
            }
            catch (IOException e) {
                System.err.println("[CS-CoreLib - Updater] Could not connect to github.io for Plugin \"" + GitHubBuildsUpdater.this.plugin.getName() + "\", is it down?");
                try {
                    GitHubBuildsUpdater.this.thread.join();
                }
                catch (InterruptedException x) {
                    x.printStackTrace();
                }
                return false;
            }
        }

        private void check() {
            if (GitHubBuildsUpdater.this.predicate.hasUpdate(GitHubBuildsUpdater.this.localVersion, GitHubBuildsUpdater.this.remoteVersion)) {
                this.install();
                return;
            }
            System.out.println("[CS-CoreLib - Updater] " + GitHubBuildsUpdater.this.plugin.getName() + " is up to date!");
            try {
                GitHubBuildsUpdater.this.thread.join();
            }
            catch (InterruptedException x) {
                x.printStackTrace();
            }
        }

        private void install() {
            System.out.println("[CS-CoreLib - Updater] " + GitHubBuildsUpdater.this.plugin.getName() + " is outdated!");
            System.out.println("[CS-CoreLib - Updater] Downloading " + GitHubBuildsUpdater.this.plugin.getName() + " v" + GitHubBuildsUpdater.this.remoteVersion);
            GitHubBuildsUpdater.this.plugin.getServer().getScheduler().runTask(GitHubBuildsUpdater.this.plugin, () -> {
                BufferedInputStream input = null;
                FileOutputStream output = null;
                System.out.println(GitHubBuildsUpdater.this.download.toString());
                try {
                    int read;
                    input = new BufferedInputStream(GitHubBuildsUpdater.this.download.openStream());
                    output = new FileOutputStream(new File("plugins/" + Bukkit.getUpdateFolder(), GitHubBuildsUpdater.this.file.getName()));
                    byte[] data = new byte[1024];
                    while ((read = input.read(data, 0, 1024)) != -1) {
                        output.write(data, 0, read);
                    }
                }
                catch (Exception ex) {
                    System.err.println(" ");
                    System.err.println("#################### - ERROR - ####################");
                    System.err.println("Could not auto-update " + GitHubBuildsUpdater.this.plugin.getName());
                    System.err.println("#################### - ERROR - ####################");
                    System.err.println(" ");
                    ex.printStackTrace();
                }
                finally {
                    try {
                        if (input != null) {
                            input.close();
                        }
                        if (output != null) {
                            output.close();
                        }
                        System.err.println(" ");
                        System.err.println("#################### - UPDATE - ####################");
                        System.err.println(GitHubBuildsUpdater.this.plugin.getName() + " was successfully updated (" + GitHubBuildsUpdater.this.localVersion + " -> " + GitHubBuildsUpdater.this.remoteVersion + ")");
                        System.err.println("Please restart your Server in order to use the new Version");
                        System.err.println(" ");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        GitHubBuildsUpdater.this.thread.join();
                    }
                    catch (InterruptedException x) {
                        x.printStackTrace();
                    }
                }
            });
        }
    }
}

