/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Math.DoubleHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockInfoConfig;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.UniversalBlockMenu;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BlockStorage {
    private static final String path_blocks = "data-storage/Slimefun/stored-blocks/";
    private static final String path_chunks = "data-storage/Slimefun/stored-chunks/";
    private World world;
    private Map<Location, Config> storage = new HashMap<Location, Config>();
    private Map<Location, BlockMenu> inventories = new HashMap<Location, BlockMenu>();
    private Map<String, Config> blocksCache = new HashMap<String, Config>();
    private static int chunkChanges = 0;
    private int changes = 0;

    public static BlockStorage getStorage(World world) {
        return SlimefunPlugin.getUtilities().worlds.get(world.getName());
    }

    public static BlockStorage getForcedStorage(World world) {
        return BlockStorage.isWorldRegistered(world.getName()) ? SlimefunPlugin.getUtilities().worlds.get(world.getName()) : new BlockStorage(world);
    }

    private static String serializeLocation(Location l) {
        return l.getWorld().getName() + ";" + l.getBlockX() + ";" + l.getBlockY() + ";" + l.getBlockZ();
    }

    private static String serializeChunk(Chunk chunk) {
        return chunk.getWorld().getName() + ";Chunk;" + chunk.getX() + ";" + chunk.getZ();
    }

    private static String locationToChunkString(Location l) {
        return l.getWorld().getName() + ";Chunk;" + (l.getBlockX() >> 4) + ";" + (l.getBlockZ() >> 4);
    }

    private static Location deserializeLocation(String l) {
        try {
            String[] components = l.split(";");
            if (components.length != 4) {
                return null;
            }
            World w = Bukkit.getWorld((String)components[0]);
            if (w != null) {
                return new Location(w, (double)Integer.parseInt(components[1]), (double)Integer.parseInt(components[2]), (double)Integer.parseInt(components[3]));
            }
        }
        catch (NumberFormatException x) {
            Slimefun.getLogger().log(Level.WARNING, "Could not parse Number", x);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockStorage(World w) {
        if (SlimefunPlugin.getUtilities().worlds.containsKey(w.getName())) {
            return;
        }
        this.world = w;
        Slimefun.getLogger().log(Level.INFO, "Loading Blocks for World \"" + w.getName() + "\"");
        Slimefun.getLogger().log(Level.INFO, "This may take a long time...");
        File f = new File(path_blocks + w.getName());
        if (f.exists()) {
            long total = f.listFiles().length;
            long start = System.currentTimeMillis();
            long done = 0L;
            long timestamp = System.currentTimeMillis();
            long totalBlocks = 0L;
            try {
                for (File file : f.listFiles()) {
                    if (file.getName().equals("null.sfb")) {
                        Slimefun.getLogger().log(Level.WARNING, "Corrupted file detected!");
                        Slimefun.getLogger().log(Level.WARNING, "Slimefun will simply skip this File, but you");
                        Slimefun.getLogger().log(Level.WARNING, "should maybe look into it!");
                        Slimefun.getLogger().log(Level.WARNING, file.getPath());
                        continue;
                    }
                    if (!file.getName().endsWith(".sfb")) continue;
                    if (timestamp + (long)SlimefunPlugin.getSettings().blocksInfoLoadingDelay < System.currentTimeMillis()) {
                        Slimefun.getLogger().log(Level.INFO, "Loading Blocks... " + Math.round((float)done * 100.0f / (float)total * 100.0f / 100.0f) + "% done (\"" + w.getName() + "\")");
                        timestamp = System.currentTimeMillis();
                    }
                    YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);
                    for (String key : cfg.getKeys(false)) {
                        Location l = BlockStorage.deserializeLocation(key);
                        String chunkString = BlockStorage.locationToChunkString(l);
                        try {
                            ++totalBlocks;
                            String json = cfg.getString(key);
                            BlockInfoConfig blockInfo = BlockStorage.parseBlockInfo(l, json);
                            if (blockInfo == null || !blockInfo.contains("id")) continue;
                            if (this.storage.containsKey(l)) {
                                Slimefun.getLogger().log(Level.INFO, "Ignoring duplicate block @ " + l.getBlockX() + ", " + l.getBlockY() + ", " + l.getBlockZ());
                                Slimefun.getLogger().log(Level.INFO, "Old block data: " + BlockStorage.serializeBlockInfo(this.storage.get(l)));
                                Slimefun.getLogger().log(Level.INFO, "New block data (" + key + "): " + json);
                                continue;
                            }
                            this.storage.put(l, blockInfo);
                            if (!SlimefunItem.isTicking(file.getName().replace(".sfb", ""))) continue;
                            Set locations = SlimefunPlugin.getUtilities().tickingChunks.getOrDefault(chunkString, new HashSet());
                            locations.add(l);
                            SlimefunPlugin.getUtilities().tickingChunks.put(chunkString, locations);
                            if (SlimefunPlugin.getUtilities().loadedTickers.contains(chunkString)) continue;
                            SlimefunPlugin.getUtilities().loadedTickers.add(chunkString);
                        }
                        catch (Exception x) {
                            Slimefun.getLogger().log(Level.WARNING, "Failed to load " + file.getName() + "(" + key + ") for Slimefun " + Slimefun.getVersion(), x);
                        }
                    }
                    ++done;
                }
            }
            finally {
                long time = System.currentTimeMillis() - start;
                Slimefun.getLogger().log(Level.INFO, "Loading Blocks... 100% (FINISHED - " + time + "ms)");
                Slimefun.getLogger().log(Level.INFO, "Loaded a total of " + totalBlocks + " Blocks for World \"" + this.world.getName() + "\"");
                if (totalBlocks > 0L) {
                    Slimefun.getLogger().log(Level.INFO, "Avg: " + DoubleHandler.fixDouble((double)((double)time / (double)totalBlocks), (int)3) + "ms/Block");
                }
            }
        } else {
            f.mkdirs();
        }
        File chunks = new File("data-storage/Slimefun/stored-chunks/chunks.sfc");
        if (chunks.exists()) {
            YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)chunks);
            for (String key : cfg.getKeys(false)) {
                try {
                    if (!this.world.getName().equals(key.split(";")[0])) continue;
                    SlimefunPlugin.getUtilities().mapChunks.put(key, cfg.getString(key));
                }
                catch (Exception x) {
                    Slimefun.getLogger().log(Level.WARNING, "Failed to load " + chunks.getName() + " in World " + this.world.getName() + "(" + key + ") for Slimefun " + Slimefun.getVersion(), x);
                }
            }
        }
        SlimefunPlugin.getUtilities().worlds.put(this.world.getName(), this);
        for (File file : new File("data-storage/Slimefun/stored-inventories").listFiles()) {
            if (!file.getName().startsWith(w.getName()) || !file.getName().endsWith(".sfi")) continue;
            Location l = BlockStorage.deserializeLocation(file.getName().replace(".sfi", ""));
            Config cfg = new Config(file);
            try {
                BlockMenuPreset preset = BlockMenuPreset.getPreset(cfg.getString("preset"));
                if (preset == null) {
                    preset = BlockMenuPreset.getPreset(BlockStorage.checkID(l));
                }
                if (preset == null) continue;
                this.inventories.put(l, new BlockMenu(preset, l, cfg));
            }
            catch (Exception x) {
                Slimefun.getLogger().log(Level.SEVERE, "An Error occured while loading this Inventory: " + file.getName(), x);
            }
        }
        for (File file : new File("data-storage/Slimefun/universal-inventories").listFiles()) {
            Config cfg;
            BlockMenuPreset preset;
            if (!file.getName().endsWith(".sfi") || (preset = BlockMenuPreset.getPreset((cfg = new Config(file)).getString("preset"))) == null) continue;
            SlimefunPlugin.getUtilities().universalInventories.put(preset.getID(), new UniversalBlockMenu(preset, cfg));
        }
    }

    public void computeChanges() {
        this.changes = this.blocksCache.size() + chunkChanges;
        HashMap<Location, BlockMenu> inventories2 = new HashMap<Location, BlockMenu>(this.inventories);
        for (Map.Entry entry : inventories2.entrySet()) {
            this.changes += ((BlockMenu)((Object)entry.getValue())).getUnsavedChanges();
        }
        HashMap<String, UniversalBlockMenu> universalInventories2 = new HashMap<String, UniversalBlockMenu>(SlimefunPlugin.getUtilities().universalInventories);
        for (Map.Entry entry : universalInventories2.entrySet()) {
            this.changes += ((UniversalBlockMenu)((Object)entry.getValue())).getUnsavedChanges();
        }
    }

    public int getChanges() {
        return this.changes;
    }

    public void save(boolean remove) {
        this.save(true, remove);
    }

    public void save(boolean computeChanges, boolean remove) {
        if (computeChanges) {
            this.computeChanges();
        }
        if (this.changes == 0) {
            return;
        }
        Slimefun.getLogger().log(Level.INFO, "Saving Blocks for World \"" + this.world.getName() + "\" (" + this.changes + " Change(s) queued)");
        HashMap<String, Config> cache = new HashMap<String, Config>(this.blocksCache);
        for (Map.Entry entry : cache.entrySet()) {
            this.blocksCache.remove(entry.getKey());
            Config config = (Config)entry.getValue();
            if (config.getKeys().isEmpty()) {
                if (config.getFile().delete()) continue;
                Slimefun.getLogger().log(Level.WARNING, "Could not delete File: " + config.getFile().getName());
                continue;
            }
            File file = new File(config.getFile().getParentFile(), config.getFile().getName() + ".tmp");
            config.save(file);
            try {
                Files.move(file.toPath(), config.getFile().toPath(), StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException x) {
                Slimefun.getLogger().log(Level.SEVERE, "An Error occured while copying a temporary File for Slimefun " + Slimefun.getVersion(), x);
            }
        }
        HashMap<Location, BlockMenu> inventories2 = new HashMap<Location, BlockMenu>(this.inventories);
        for (Map.Entry entry : inventories2.entrySet()) {
            ((BlockMenu)((Object)entry.getValue())).save((Location)entry.getKey());
        }
        HashMap<String, UniversalBlockMenu> hashMap = new HashMap<String, UniversalBlockMenu>(SlimefunPlugin.getUtilities().universalInventories);
        for (Map.Entry entry : hashMap.entrySet()) {
            ((UniversalBlockMenu)((Object)entry.getValue())).save();
        }
        if (chunkChanges > 0) {
            File file = new File("data-storage/Slimefun/stored-chunks/chunks.sfc");
            Config config = new Config("data-storage/Slimefun/temp.yml");
            for (Map.Entry<String, String> entry : SlimefunPlugin.getUtilities().mapChunks.entrySet()) {
                config.setValue(entry.getKey(), (Object)entry.getValue());
            }
            config.save(file);
            if (remove) {
                SlimefunPlugin.getUtilities().worlds.remove(this.world.getName());
            }
        }
        this.changes = 0;
        chunkChanges = 0;
    }

    public static void store(Block block, ItemStack item) {
        SlimefunItem sfitem = SlimefunItem.getByItem(item);
        if (sfitem != null) {
            BlockStorage.addBlockInfo(block, "id", sfitem.getID(), true);
        }
    }

    public static void store(Block block, String item) {
        BlockStorage.addBlockInfo(block, "id", item, true);
    }

    public static ItemStack retrieve(Block block) {
        if (!BlockStorage.hasBlockInfo(block)) {
            return null;
        }
        SlimefunItem item = SlimefunItem.getByID(BlockStorage.getLocationInfo(block.getLocation(), "id"));
        BlockStorage.clearBlockInfo(block);
        if (item == null) {
            return null;
        }
        return item.getItem();
    }

    @Deprecated
    public static Config getBlockInfo(Block block) {
        return BlockStorage.getLocationInfo(block.getLocation());
    }

    @Deprecated
    public static Config getBlockInfo(Location l) {
        return BlockStorage.getLocationInfo(l);
    }

    public static Config getLocationInfo(Location l) {
        BlockStorage storage = BlockStorage.getStorage(l.getWorld());
        Config cfg = storage.storage.get(l);
        return cfg == null ? new BlockInfoConfig() : cfg;
    }

    private static Map<String, String> parseJSON(String json) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (json != null && json.length() > 2) {
            JsonParser parser = new JsonParser();
            JsonObject obj = parser.parse(json).getAsJsonObject();
            for (Map.Entry entry : obj.entrySet()) {
                map.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        }
        return map;
    }

    private static BlockInfoConfig parseBlockInfo(Location l, String json) {
        try {
            return new BlockInfoConfig(BlockStorage.parseJSON(json));
        }
        catch (Exception x) {
            Logger logger = Slimefun.getLogger();
            logger.log(Level.WARNING, x.getClass().getName());
            logger.log(Level.WARNING, "Failed to parse BlockInfo for Block @ " + l.getBlockX() + ", " + l.getBlockY() + ", " + l.getBlockZ());
            logger.log(Level.WARNING, json);
            logger.log(Level.WARNING, "");
            logger.log(Level.WARNING, "IGNORE THIS ERROR UNLESS IT IS SPAMMING");
            logger.log(Level.WARNING, "");
            logger.log(Level.SEVERE, "An Error occured while parsing Block Info for Slimefun " + Slimefun.getVersion(), x);
            return null;
        }
    }

    private static String serializeBlockInfo(Config cfg) {
        JsonObject json = new JsonObject();
        for (String key : cfg.getKeys()) {
            json.add(key, (JsonElement)new JsonPrimitive(cfg.getString(key)));
        }
        return json.toString();
    }

    private static String getJSONData(Chunk chunk) {
        if (chunk == null) {
            return null;
        }
        return SlimefunPlugin.getUtilities().mapChunks.get(BlockStorage.serializeChunk(chunk));
    }

    @Deprecated
    public static String getBlockInfo(Block block, String key) {
        return BlockStorage.getLocationInfo(block.getLocation(), key);
    }

    @Deprecated
    public static String getBlockInfo(Location l, String key) {
        return BlockStorage.getLocationInfo(l, key);
    }

    public static String getLocationInfo(Location l, String key) {
        return BlockStorage.getLocationInfo(l).getString(key);
    }

    public static void addBlockInfo(Location l, String key, String value) {
        BlockStorage.addBlockInfo(l, key, value, false);
    }

    public static void addBlockInfo(Block block, String key, String value) {
        BlockStorage.addBlockInfo(block.getLocation(), key, value);
    }

    public static void addBlockInfo(Block block, String key, String value, boolean updateTicker) {
        BlockStorage.addBlockInfo(block.getLocation(), key, value, updateTicker);
    }

    public static void addBlockInfo(Location l, String key, String value, boolean updateTicker) {
        Config cfg = BlockStorage.hasBlockInfo(l) ? BlockStorage.getLocationInfo(l) : new BlockInfoConfig();
        cfg.setValue(key, (Object)value);
        BlockStorage.setBlockInfo(l, cfg, updateTicker);
    }

    public static boolean hasBlockInfo(Block block) {
        return BlockStorage.hasBlockInfo(block.getLocation());
    }

    public static boolean hasBlockInfo(Location l) {
        BlockStorage storage = BlockStorage.getStorage(l.getWorld());
        return storage != null && storage.storage.containsKey(l) && BlockStorage.getLocationInfo(l, "id") != null;
    }

    public static void setBlockInfo(Block block, Config cfg, boolean updateTicker) {
        BlockStorage.setBlockInfo(block.getLocation(), cfg, updateTicker);
    }

    public static void setBlockInfo(Location l, Config cfg, boolean updateTicker) {
        BlockStorage storage = BlockStorage.getStorage(l.getWorld());
        storage.storage.put(l, cfg);
        if (BlockMenuPreset.isInventory(cfg.getString("id"))) {
            if (BlockMenuPreset.isUniversalInventory(cfg.getString("id"))) {
                if (!SlimefunPlugin.getUtilities().universalInventories.containsKey(cfg.getString("id"))) {
                    storage.loadUniversalInventory(BlockMenuPreset.getPreset(cfg.getString("id")));
                }
            } else if (!storage.hasInventory(l)) {
                File file = new File("data-storage/Slimefun/stored-inventories/" + BlockStorage.serializeLocation(l) + ".sfi");
                if (file.exists()) {
                    storage.inventories.put(l, new BlockMenu(BlockMenuPreset.getPreset(cfg.getString("id")), l, new Config(file)));
                } else {
                    storage.loadInventory(l, BlockMenuPreset.getPreset(cfg.getString("id")));
                }
            }
        }
        BlockStorage.refreshCache(BlockStorage.getStorage(l.getWorld()), l, cfg.getString("id"), BlockStorage.serializeBlockInfo(cfg), updateTicker);
    }

    public static void setBlockInfo(Block b, String json, boolean updateTicker) {
        BlockStorage.setBlockInfo(b.getLocation(), json, updateTicker);
    }

    public static void setBlockInfo(Location l, String json, boolean updateTicker) {
        BlockInfoConfig blockInfo;
        BlockInfoConfig blockInfoConfig = blockInfo = json == null ? new BlockInfoConfig() : BlockStorage.parseBlockInfo(l, json);
        if (blockInfo == null) {
            return;
        }
        BlockStorage.setBlockInfo(l, (Config)blockInfo, updateTicker);
    }

    public static void clearBlockInfo(Block block) {
        BlockStorage.clearBlockInfo(block.getLocation());
    }

    public static void clearBlockInfo(Location l) {
        BlockStorage.clearBlockInfo(l, true);
    }

    public static void clearBlockInfo(Block b, boolean destroy) {
        BlockStorage.clearBlockInfo(b.getLocation(), destroy);
    }

    public static void clearBlockInfo(Location l, boolean destroy) {
        SlimefunPlugin.getTicker().delete.put(l, destroy);
    }

    public static void _integrated_removeBlockInfo(Location l, boolean destroy) {
        BlockStorage storage = BlockStorage.getStorage(l.getWorld());
        if (BlockStorage.hasBlockInfo(l)) {
            BlockStorage.refreshCache(storage, l, BlockStorage.getLocationInfo(l).getString("id"), null, destroy);
            storage.storage.remove(l);
        }
        if (destroy) {
            String chunkString;
            if (storage.hasInventory(l)) {
                storage.clearInventory(l);
            }
            if (storage.hasUniversalInventory(l)) {
                storage.getUniversalInventory(l).close();
                storage.getUniversalInventory(l).save();
            }
            if (SlimefunPlugin.getUtilities().tickingChunks.containsKey(chunkString = BlockStorage.locationToChunkString(l))) {
                Set<Location> locations = SlimefunPlugin.getUtilities().tickingChunks.get(chunkString);
                locations.remove(l);
                if (locations.isEmpty()) {
                    SlimefunPlugin.getUtilities().tickingChunks.remove(chunkString);
                    SlimefunPlugin.getUtilities().loadedTickers.remove(chunkString);
                } else {
                    SlimefunPlugin.getUtilities().tickingChunks.put(chunkString, locations);
                }
            }
        }
    }

    @Deprecated
    public static void moveBlockInfo(Block block, Block newBlock) {
        BlockStorage.moveBlockInfo(block.getLocation(), newBlock.getLocation());
    }

    public static void moveBlockInfo(Location from, Location to) {
        SlimefunPlugin.getTicker().move.put(from, to);
    }

    @Deprecated
    public static void _integrated_moveBlockInfo(Block block, Block newBlock) {
        BlockStorage._integrated_moveLocationInfo(block.getLocation(), newBlock.getLocation());
    }

    public static void _integrated_moveLocationInfo(Location from, Location to) {
        if (!BlockStorage.hasBlockInfo(from)) {
            return;
        }
        BlockStorage storage = BlockStorage.getStorage(from.getWorld());
        BlockStorage.setBlockInfo(to, BlockStorage.getLocationInfo(from), true);
        if (storage.inventories.containsKey(from)) {
            BlockMenu menu = storage.inventories.get(from);
            storage.inventories.put(to, menu);
            storage.clearInventory(from);
            menu.move(to);
        }
        BlockStorage.refreshCache(storage, from, BlockStorage.getLocationInfo(from).getString("id"), null, true);
        storage.storage.remove(from);
        String chunkString = BlockStorage.locationToChunkString(from);
        if (SlimefunPlugin.getUtilities().tickingChunks.containsKey(chunkString)) {
            Set<Location> locations = SlimefunPlugin.getUtilities().tickingChunks.get(chunkString);
            locations.remove(from);
            if (locations.isEmpty()) {
                SlimefunPlugin.getUtilities().tickingChunks.remove(chunkString);
                SlimefunPlugin.getUtilities().loadedTickers.remove(chunkString);
            } else {
                SlimefunPlugin.getUtilities().tickingChunks.put(chunkString, locations);
            }
        }
    }

    private static void refreshCache(BlockStorage storage, Location l, String key, String value, boolean updateTicker) {
        SlimefunItem item;
        Config cfg = storage.blocksCache.containsKey(key) ? storage.blocksCache.get(key) : new Config(path_blocks + l.getWorld().getName() + "/" + key + ".sfb");
        cfg.setValue(BlockStorage.serializeLocation(l), (Object)value);
        storage.blocksCache.put(key, cfg);
        if (updateTicker && (item = SlimefunItem.getByID(key)) != null && item.isTicking()) {
            String chunkString = BlockStorage.locationToChunkString(l);
            if (value != null) {
                Set<Location> locations = SlimefunPlugin.getUtilities().tickingChunks.get(chunkString);
                if (locations == null) {
                    locations = new HashSet<Location>();
                }
                locations.add(l);
                SlimefunPlugin.getUtilities().tickingChunks.put(chunkString, locations);
                if (!SlimefunPlugin.getUtilities().loadedTickers.contains(chunkString)) {
                    SlimefunPlugin.getUtilities().loadedTickers.add(chunkString);
                }
            }
        }
    }

    public static SlimefunItem check(Block block) {
        return BlockStorage.check(block.getLocation());
    }

    public static SlimefunItem check(Location l) {
        if (!BlockStorage.hasBlockInfo(l)) {
            return null;
        }
        return SlimefunItem.getByID(BlockStorage.getLocationInfo(l, "id"));
    }

    public static String checkID(Block block) {
        return BlockStorage.checkID(block.getLocation());
    }

    public static boolean check(Block block, String slimefunItem) {
        return BlockStorage.check(block.getLocation(), slimefunItem);
    }

    public static String checkID(Location l) {
        if (!BlockStorage.hasBlockInfo(l)) {
            return null;
        }
        return BlockStorage.getLocationInfo(l, "id");
    }

    public static boolean check(Location l, String slimefunItem) {
        if (!BlockStorage.hasBlockInfo(l)) {
            return false;
        }
        try {
            String id = BlockStorage.getLocationInfo(l, "id");
            return id != null && id.equalsIgnoreCase(slimefunItem);
        }
        catch (NullPointerException x) {
            return false;
        }
    }

    public static boolean isWorldRegistered(String name) {
        return SlimefunPlugin.getUtilities().worlds.containsKey(name);
    }

    public static Set<String> getTickingChunks() {
        return new HashSet<String>(SlimefunPlugin.getUtilities().loadedTickers);
    }

    @Deprecated
    public static Set<Block> getTickingBlocks(Chunk chunk) {
        return BlockStorage.getTickingBlocks(chunk.toString());
    }

    public static Set<Location> getTickingLocations(Chunk chunk) {
        return BlockStorage.getTickingLocations(chunk.toString());
    }

    @Deprecated
    public static Set<Block> getTickingBlocks(String chunk) {
        HashSet<Block> ret = new HashSet<Block>();
        for (Location l : BlockStorage.getTickingLocations(chunk)) {
            ret.add(l.getBlock());
        }
        return ret;
    }

    public static Set<Location> getTickingLocations(String chunk) {
        return new HashSet<Location>((Collection)SlimefunPlugin.getUtilities().tickingChunks.get(chunk));
    }

    public BlockMenu loadInventory(Location l, BlockMenuPreset preset) {
        BlockMenu menu = new BlockMenu(preset, l);
        this.inventories.put(l, menu);
        return menu;
    }

    public void loadUniversalInventory(BlockMenuPreset preset) {
        SlimefunPlugin.getUtilities().universalInventories.put(preset.getID(), new UniversalBlockMenu(preset));
    }

    public void clearInventory(Location l) {
        BlockMenu menu = BlockStorage.getInventory(l);
        if (menu != null) {
            for (HumanEntity human : new ArrayList(menu.toInventory().getViewers())) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunPlugin.instance, () -> ((HumanEntity)human).closeInventory());
            }
            this.inventories.get(l).delete(l);
            this.inventories.remove(l);
        }
    }

    public boolean hasInventory(Location l) {
        return this.inventories.containsKey(l);
    }

    public boolean hasUniversalInventory(String id) {
        return SlimefunPlugin.getUtilities().universalInventories.containsKey(id);
    }

    public UniversalBlockMenu getUniversalInventory(Block block) {
        return this.getUniversalInventory(block.getLocation());
    }

    public UniversalBlockMenu getUniversalInventory(Location l) {
        String id = BlockStorage.checkID(l);
        return id == null ? null : this.getUniversalInventory(id);
    }

    public UniversalBlockMenu getUniversalInventory(String id) {
        return SlimefunPlugin.getUtilities().universalInventories.get(id);
    }

    public static BlockMenu getInventory(Block b) {
        return BlockStorage.getInventory(b.getLocation());
    }

    public static BlockMenu getInventory(Location l) {
        BlockStorage storage = BlockStorage.getStorage(l.getWorld());
        if (storage == null) {
            return null;
        }
        if (!storage.hasInventory(l)) {
            return storage.loadInventory(l, BlockMenuPreset.getPreset(BlockStorage.checkID(l)));
        }
        return storage.inventories.get(l);
    }

    public static Config getChunkInfo(Chunk chunk) {
        try {
            Config cfg = new Config("data-storage/Slimefun/temp.yml");
            if (!SlimefunPlugin.getUtilities().mapChunks.containsKey(BlockStorage.serializeChunk(chunk))) {
                return cfg;
            }
            for (Map.Entry<String, String> entry : BlockStorage.parseJSON(BlockStorage.getJSONData(chunk)).entrySet()) {
                cfg.setValue(entry.getKey(), (Object)entry.getValue());
            }
            return cfg;
        }
        catch (Exception x) {
            Slimefun.getLogger().log(Level.SEVERE, "Failed to parse ChunkInfo for Chunk: " + (chunk == null ? "?" : Integer.valueOf(chunk.getX())) + ", " + (chunk == null ? "?" : Integer.valueOf(chunk.getZ())) + " (" + BlockStorage.getJSONData(chunk) + ") for Slimefun " + Slimefun.getVersion(), x);
            return new Config("data-storage/Slimefun/temp.yml");
        }
    }

    public static boolean hasChunkInfo(Chunk chunk) {
        return SlimefunPlugin.getUtilities().mapChunks.containsKey(BlockStorage.serializeChunk(chunk));
    }

    public static void setChunkInfo(Chunk chunk, String key, String value) {
        Config cfg = new Config("data-storage/Slimefun/temp.yml");
        if (BlockStorage.hasChunkInfo(chunk)) {
            cfg = BlockStorage.getChunkInfo(chunk);
        }
        cfg.setValue(key, (Object)value);
        JsonObject json = new JsonObject();
        for (String path : cfg.getKeys()) {
            json.add(path, (JsonElement)new JsonPrimitive(cfg.getString(path)));
        }
        SlimefunPlugin.getUtilities().mapChunks.put(BlockStorage.serializeChunk(chunk), json.toString());
        ++chunkChanges;
    }

    public static String getChunkInfo(Chunk chunk, String key) {
        return BlockStorage.getChunkInfo(chunk).getString(key);
    }

    public static boolean hasChunkInfo(Chunk chunk, String key) {
        return BlockStorage.getChunkInfo(chunk, key) != null;
    }

    public static void clearChunkInfo(Chunk chunk) {
        SlimefunPlugin.getUtilities().mapChunks.remove(BlockStorage.serializeChunk(chunk));
    }

    public static String getBlockInfoAsJson(Block block) {
        return BlockStorage.getBlockInfoAsJson(block.getLocation());
    }

    public static String getBlockInfoAsJson(Location l) {
        return BlockStorage.serializeBlockInfo(BlockStorage.getLocationInfo(l));
    }

    public boolean hasUniversalInventory(Block block) {
        return this.hasUniversalInventory(block.getLocation());
    }

    public boolean hasUniversalInventory(Location l) {
        String id = BlockStorage.checkID(l);
        return id != null && this.hasUniversalInventory(id);
    }
}

