/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.inventory;

import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.PlayerProfile;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class BackpackInventory {
    private int id;
    private int size;
    private PlayerProfile profile;
    private Config cfg;
    private Inventory inventory;

    public BackpackInventory(PlayerProfile profile, int id) {
        this(profile, id, profile.getConfig().getInt("backpacks." + id + ".size"));
        for (int i = 0; i < this.size; ++i) {
            this.inventory.setItem(i, this.cfg.getItem("backpacks." + id + ".contents." + i));
        }
    }

    public BackpackInventory(PlayerProfile profile, int id, int size) {
        this.profile = profile;
        this.id = id;
        this.cfg = profile.getConfig();
        this.size = size;
        this.cfg.setValue("backpacks." + id + ".size", (Object)size);
        profile.markDirty();
        this.inventory = Bukkit.createInventory(null, (int)size, (String)("Backpack [" + size + " Slots]"));
    }

    public int getID() {
        return this.id;
    }

    public int getSize() {
        return this.size;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void open(Player ... players) {
        for (Player p : players) {
            p.openInventory(this.inventory);
        }
    }

    public void setSize(int size) {
        this.size = size;
        this.cfg.setValue("backpacks." + this.id + ".size", (Object)size);
        Inventory inventory = Bukkit.createInventory(null, (int)size, (String)("Backpack [" + size + " Slots]"));
        for (int slot = 0; slot < this.inventory.getSize(); ++slot) {
            inventory.setItem(slot, this.inventory.getItem(slot));
        }
        this.inventory = inventory;
        this.markDirty();
    }

    public void save() {
        for (int i = 0; i < this.size; ++i) {
            this.cfg.setValue("backpacks." + this.id + ".contents." + i, (Object)this.inventory.getItem(i));
        }
    }

    public void markDirty() {
        this.profile.markDirty();
    }
}

