/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.listeners;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import me.mrCookieSlime.EmeraldEnchants.EmeraldEnchants;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SoulboundItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.Talisman;
import me.mrCookieSlime.Slimefun.Objects.handlers.EntityKillHandler;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.Soul;
import me.mrCookieSlime.Slimefun.utils.Utilities;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class DamageListener
implements Listener {
    private SimpleDateFormat format = new SimpleDateFormat("(MMM d, yyyy @ hh:mm)");
    private Utilities utilities;

    public DamageListener(SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.utilities = SlimefunPlugin.getUtilities();
    }

    @EventHandler
    public void onDamage(EntityDeathEvent e) {
        Player p;
        if (e.getEntity() instanceof Player) {
            Object item;
            p = (Player)e.getEntity();
            if (p.getInventory().containsAtLeast(SlimefunItems.GPS_EMERGENCY_TRANSMITTER, 1)) {
                Slimefun.getGPSNetwork().addWaypoint(p, "&4Deathpoint &7" + this.format.format(new Date()), p.getLocation().getBlock().getLocation());
            }
            for (int slot = 0; slot < p.getInventory().getSize(); ++slot) {
                item = p.getInventory().getItem(slot);
                if (!this.isSoulbound((ItemStack)item)) continue;
                Soul.storeItem(p.getUniqueId(), slot, (ItemStack)item);
            }
            Iterator drops = e.getDrops().iterator();
            while (drops.hasNext()) {
                item = (ItemStack)drops.next();
                if (!this.isSoulbound((ItemStack)item)) continue;
                drops.remove();
            }
        }
        if (e.getEntity().getKiller() instanceof Player) {
            p = e.getEntity().getKiller();
            ItemStack item = p.getInventory().getItemInMainHand();
            if (SlimefunPlugin.getUtilities().drops.containsKey(e.getEntity().getType())) {
                for (ItemStack drop : SlimefunPlugin.getUtilities().drops.get(e.getEntity().getType())) {
                    if (!Slimefun.hasUnlocked(p, drop, true)) continue;
                    e.getDrops().add(drop);
                }
            }
            if (item != null && item.getType() != null && item.getType() != Material.AIR) {
                for (ItemHandler handler : SlimefunItem.getHandlers("EntityKillHandler")) {
                    if (!((EntityKillHandler)handler).onKill(e, (Entity)e.getEntity(), p, item)) continue;
                    return;
                }
            }
            if (!e.getEntity().getCanPickupItems() && Talisman.checkFor((Event)e, SlimefunItem.getByID("HUNTER_TALISMAN")) && !(e.getEntity() instanceof Player)) {
                ArrayList extraDrops = new ArrayList(e.getDrops());
                if (e.getEntity() instanceof ChestedHorse) {
                    for (ItemStack invItem : ((ChestedHorse)e.getEntity()).getInventory().getStorageContents()) {
                        extraDrops.remove(invItem);
                    }
                    extraDrops.remove(new ItemStack(Material.CHEST));
                }
                for (ItemStack drop : extraDrops) {
                    e.getDrops().add(drop);
                }
            }
        }
    }

    private boolean isSoulbound(ItemStack item) {
        if (item == null || item.getType() == null || item.getType() == Material.AIR) {
            return false;
        }
        if (SlimefunManager.isItemSimiliar(item, SlimefunItems.BOUND_BACKPACK, false)) {
            return true;
        }
        return SlimefunItem.getByItem(this.removeEnchantments(item)) instanceof SoulboundItem;
    }

    @EventHandler
    public void onArrowHit(EntityDamageEvent e) {
        if (e.getEntity() instanceof Player && e.getCause() == EntityDamageEvent.DamageCause.FALL && this.utilities.damage.contains(e.getEntity().getUniqueId())) {
            e.setCancelled(true);
            this.utilities.damage.remove(e.getEntity().getUniqueId());
        }
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent e) {
        Soul.retrieveItems(e.getPlayer());
    }

    private ItemStack removeEnchantments(ItemStack itemStack) {
        ItemStack strippedItem = itemStack.clone();
        for (Enchantment enchantment : itemStack.getEnchantments().keySet()) {
            strippedItem.removeEnchantment(enchantment);
        }
        if (SlimefunPlugin.getHooks().isEmeraldEnchantsInstalled()) {
            for (Enchantment enchantment : EmeraldEnchants.getInstance().getRegistry().getEnchantments(itemStack)) {
                EmeraldEnchants.getInstance().getRegistry().applyEnchantment(strippedItem, enchantment.getEnchantment(), 0);
            }
        }
        return strippedItem;
    }
}

