/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import me.mrCookieSlime.CSCoreLibPlugin.general.Chat.TellRawMessage;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.ErrorReport;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TickerTask
implements Runnable {
    private boolean halted = false;
    protected Map<Location, Location> move = new HashMap<Location, Location>();
    protected Map<Location, Boolean> delete = new HashMap<Location, Boolean>();
    protected Map<Location, Long> blockTimings = new HashMap<Location, Long>();
    private Set<BlockTicker> tickers = new HashSet<BlockTicker>();
    private int skipped = 0;
    private int chunks = 0;
    private int machines = 0;
    private long time = 0L;
    private Map<String, Integer> chunkItemCount = new HashMap<String, Integer>();
    private Map<String, Integer> machineCount = new HashMap<String, Integer>();
    private Map<String, Long> machineTimings = new HashMap<String, Long>();
    private Map<String, Long> chunkTimings = new HashMap<String, Long>();
    private Set<String> chunksSkipped = new HashSet<String>();
    private Map<Location, Integer> buggedBlocks = new HashMap<Location, Integer>();

    @Override
    public void run() {
        long timestamp = System.currentTimeMillis();
        this.skipped = 0;
        this.chunks = 0;
        this.machines = 0;
        this.chunkItemCount.clear();
        this.machineCount.clear();
        this.time = 0L;
        this.chunkTimings.clear();
        this.chunksSkipped.clear();
        this.machineTimings.clear();
        this.blockTimings.clear();
        HashMap<Location, Integer> bugged = new HashMap<Location, Integer>(this.buggedBlocks);
        this.buggedBlocks.clear();
        HashMap<Location, Boolean> remove = new HashMap<Location, Boolean>(this.delete);
        for (Map.Entry entry : remove.entrySet()) {
            BlockStorage._integrated_removeBlockInfo((Location)entry.getKey(), (Boolean)entry.getValue());
            this.delete.remove(entry.getKey());
        }
        if (!this.halted) {
            for (String string : BlockStorage.getTickingChunks()) {
                long timestamp2 = System.currentTimeMillis();
                ++this.chunks;
                for (Location l : BlockStorage.getTickingLocations(string)) {
                    if (l.getWorld().isChunkLoaded(l.getBlockX() >> 4, l.getBlockZ() >> 4)) {
                        Block b = l.getBlock();
                        SlimefunItem item = BlockStorage.check(l);
                        if (item != null && item.getBlockTicker() != null) {
                            ++this.machines;
                            try {
                                item.getBlockTicker().update();
                                if (item.getBlockTicker().isSynchronized()) {
                                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunPlugin.instance, () -> {
                                        try {
                                            long timestamp3 = System.currentTimeMillis();
                                            item.getBlockTicker().tick(b, item, BlockStorage.getLocationInfo(l));
                                            Long machinetime = this.machineTimings.get(item.getID());
                                            Integer chunk = this.chunkItemCount.get(c);
                                            Integer machine = this.machineCount.get(item.getID());
                                            this.machineTimings.put(item.getID(), (machinetime != null ? machinetime : 0L) + (System.currentTimeMillis() - timestamp3));
                                            this.chunkItemCount.put(c, (chunk != null ? chunk : 0) + 1);
                                            this.machineCount.put(item.getID(), (machine != null ? machine : 0) + 1);
                                            this.blockTimings.put(l, System.currentTimeMillis() - timestamp3);
                                        }
                                        catch (Exception x) {
                                            int errors = 0;
                                            if (bugged.containsKey(l)) {
                                                errors = (Integer)bugged.get(l);
                                            }
                                            if (++errors == 1) {
                                                new ErrorReport(x, this, l, item);
                                                this.buggedBlocks.put(l, errors);
                                            }
                                            if (errors == 4) {
                                                Slimefun.getLogger().log(Level.SEVERE, "X: " + l.getBlockX() + " Y: " + l.getBlockY() + " Z: " + l.getBlockZ() + "(" + item.getID() + ")");
                                                Slimefun.getLogger().log(Level.SEVERE, "has thrown 4 Exceptions in the last 4 Ticks, the Block has been terminated.");
                                                Slimefun.getLogger().log(Level.SEVERE, "Check your /plugins/Slimefun/error-reports/ folder for details.");
                                                Slimefun.getLogger().log(Level.SEVERE, " ");
                                                BlockStorage._integrated_removeBlockInfo(l, true);
                                                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunPlugin.instance, () -> l.getBlock().setType(Material.AIR));
                                            }
                                            this.buggedBlocks.put(l, errors);
                                        }
                                    });
                                } else {
                                    long timestamp3 = System.currentTimeMillis();
                                    item.getBlockTicker().tick(b, item, BlockStorage.getLocationInfo(l));
                                    this.machineTimings.put(item.getID(), (this.machineTimings.containsKey(item.getID()) ? this.machineTimings.get(item.getID()) : 0L) + (System.currentTimeMillis() - timestamp3));
                                    this.chunkItemCount.put(string, (this.chunkItemCount.containsKey(string) ? this.chunkItemCount.get(string) : 0) + 1);
                                    this.machineCount.put(item.getID(), (this.machineCount.containsKey(item.getID()) ? this.machineCount.get(item.getID()) : 0) + 1);
                                    this.blockTimings.put(l, System.currentTimeMillis() - timestamp3);
                                }
                                this.tickers.add(item.getBlockTicker());
                            }
                            catch (Exception x) {
                                int errors = 0;
                                if (bugged.containsKey(l)) {
                                    errors = (Integer)bugged.get(l);
                                }
                                if (++errors == 1) {
                                    new ErrorReport(x, this, l, item);
                                    this.buggedBlocks.put(l, errors);
                                    continue;
                                }
                                if (errors == 4) {
                                    Slimefun.getLogger().log(Level.SEVERE, "X: " + l.getBlockX() + " Y: " + l.getBlockY() + " Z: " + l.getBlockZ() + "(" + item.getID() + ")");
                                    Slimefun.getLogger().log(Level.SEVERE, "has thrown 4 Exceptions in the last 4 Ticks, the Block has been terminated.");
                                    Slimefun.getLogger().log(Level.SEVERE, "Check your /plugins/Slimefun/error-reports/ folder for details.");
                                    Slimefun.getLogger().log(Level.SEVERE, " ");
                                    BlockStorage._integrated_removeBlockInfo(l, true);
                                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunPlugin.instance, () -> l.getBlock().setType(Material.AIR));
                                    continue;
                                }
                                this.buggedBlocks.put(l, errors);
                            }
                            continue;
                        }
                        ++this.skipped;
                        continue;
                    }
                    this.skipped += BlockStorage.getTickingLocations(string).size();
                    this.chunksSkipped.add(string);
                    --this.chunks;
                    break;
                }
                this.chunkTimings.put(string, System.currentTimeMillis() - timestamp2);
            }
        }
        for (Map.Entry entry : this.move.entrySet()) {
            BlockStorage._integrated_moveLocationInfo((Location)entry.getKey(), (Location)entry.getValue());
        }
        this.move.clear();
        Iterator<BlockTicker> iterator = this.tickers.iterator();
        while (iterator.hasNext()) {
            iterator.next().startNewTick();
            iterator.remove();
        }
        this.time = System.currentTimeMillis() - timestamp;
    }

    public long getTime() {
        return this.time;
    }

    public void info(CommandSender sender) {
        int hidden;
        Object hover;
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&2== &aSlimefun Diagnostic Tool &2=="));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&6Halted: &e&l" + String.valueOf(this.halted).toUpperCase())));
        sender.sendMessage("");
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&6Impact: &e" + this.time + "ms / 50-750ms")));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&6Ticked Chunks: &e" + this.chunks)));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&6Ticked Machines: &e" + this.machines)));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&6Skipped Machines: &e" + this.skipped)));
        sender.sendMessage("");
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6Ticking Machines:"));
        if (sender instanceof Player) {
            TellRawMessage tellraw = new TellRawMessage();
            tellraw.addText("   &7&oHover for more Info");
            hover = new StringBuilder();
            hidden = 0;
            for (Map.Entry<String, Integer> entry : this.machineCount.entrySet()) {
                long timings = this.machineTimings.get(entry.getKey());
                if (timings > 0L) {
                    ((StringBuilder)hover).append("\n&c" + entry.getKey() + " - " + entry.getValue() + "x &7(" + timings + "ms)");
                    continue;
                }
                ++hidden;
            }
            ((StringBuilder)hover).append("\n\n&c+ &4" + hidden + " Hidden");
            tellraw.addHoverEvent(TellRawMessage.HoverAction.SHOW_TEXT, ((StringBuilder)hover).toString());
            try {
                tellraw.send(new Player[]{(Player)sender});
            }
            catch (Exception x) {
                Slimefun.getLogger().log(Level.SEVERE, "An Error occured while sending a Timings Summary for Slimefun " + Slimefun.getVersion(), x);
            }
        } else {
            int hidden2 = 0;
            for (Map.Entry<String, Integer> entry : this.machineCount.entrySet()) {
                long timings = this.machineTimings.get(entry.getKey());
                if (timings > 0L) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("  &e" + entry.getKey() + " - " + entry.getValue() + "x &7(" + timings + "ms)")));
                    continue;
                }
                ++hidden2;
            }
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&c+ &4" + hidden2 + " Hidden")));
        }
        sender.sendMessage("");
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6Ticking Chunks:"));
        if (sender instanceof Player) {
            TellRawMessage tellraw = new TellRawMessage();
            tellraw.addText("   &7&oHover for more Info");
            hover = new StringBuilder();
            hidden = 0;
            for (Map.Entry<String, Long> entry : this.chunkTimings.entrySet()) {
                if (this.chunksSkipped.contains(entry.getKey())) continue;
                if (entry.getValue() > 0L) {
                    ((StringBuilder)hover).append("\n&c" + entry.getKey().replace("CraftChunk", "") + " - " + (this.chunkItemCount.containsKey(entry.getKey()) ? this.chunkItemCount.get(entry.getKey()) : 0) + "x &7(" + entry.getValue() + "ms)");
                    continue;
                }
                ++hidden;
            }
            ((StringBuilder)hover).append("\n\n&c+ &4" + hidden + " Hidden");
            tellraw.addHoverEvent(TellRawMessage.HoverAction.SHOW_TEXT, ((StringBuilder)hover).toString());
            try {
                tellraw.send(new Player[]{(Player)sender});
            }
            catch (Exception x) {
                Slimefun.getLogger().log(Level.SEVERE, "An Error occured while sending a Timings Summary for Slimefun " + Slimefun.getVersion(), x);
            }
        } else {
            int hidden3 = 0;
            for (Map.Entry<String, Long> entry : this.chunkTimings.entrySet()) {
                if (this.chunksSkipped.contains(entry.getKey())) continue;
                if (entry.getValue() > 0L) {
                    sender.sendMessage("  &c" + entry.getKey().replace("CraftChunk", "") + " - " + (this.chunkItemCount.containsKey(entry.getKey()) ? this.chunkItemCount.get(entry.getKey()) : 0) + "x &7(" + entry.getValue() + "ms)");
                    continue;
                }
                ++hidden3;
            }
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&c+ &4" + hidden3 + " Hidden")));
        }
    }

    public long getTimings(Block b) {
        return this.blockTimings.containsKey(b.getLocation()) ? this.blockTimings.get(b.getLocation()) : 0L;
    }

    public long getTimings(String item) {
        return this.machineTimings.containsKey(item) ? this.machineTimings.get(item) : 0L;
    }

    public long getTimings(Chunk c) {
        return this.chunkTimings.containsKey(c.toString()) ? this.chunkTimings.get(c.toString()) : 0L;
    }

    public void addBlockTimings(Location l, long time) {
        this.blockTimings.put(l, time);
    }

    public boolean isHalted() {
        return this.halted;
    }

    public void halt() {
        this.halted = true;
    }

    public String toString() {
        return "TickerTask {\n     HALTED = " + this.halted + "\n" + "     tickers = " + this.tickers + "\n" + "     move = " + this.move + "\n" + "     delete = " + this.delete + "\n" + "     chunks = " + this.chunkItemCount + "\n" + "     machines = " + this.machineCount + "\n" + "     machinetime = " + this.machineTimings + "\n" + "     chunktime = " + this.chunkTimings + "\n" + "     skipped = " + this.chunksSkipped + "\n" + "}";
    }
}

