/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.items;

import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.Interfaces.NotPlaceable;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SimpleSlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockBreakHandler;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.materials.MaterialTools;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectionModule;
import me.mrCookieSlime.Slimefun.utils.DamageableItem;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public class ExplosiveShovel
extends SimpleSlimefunItem<BlockBreakHandler>
implements NotPlaceable,
DamageableItem {
    private boolean damageOnUse;

    public ExplosiveShovel(Category category, ItemStack item, String id, RecipeType recipeType, ItemStack[] recipe, String[] keys, Object[] values) {
        super(category, item, id, recipeType, recipe, keys, values);
    }

    @Override
    public BlockBreakHandler getItemHandler() {
        return (e, item, fortune, drops) -> {
            if (SlimefunManager.isItemSimiliar(item, SlimefunItems.EXPLOSIVE_SHOVEL, true)) {
                e.getBlock().getWorld().createExplosion(e.getBlock().getLocation(), 0.0f);
                e.getBlock().getWorld().playSound(e.getBlock().getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            Block b = e.getBlock().getRelative(x, y, z);
                            boolean correctType = false;
                            for (Material mat : MaterialTools.getShovelItems()) {
                                if (b.getType() != mat) continue;
                                correctType = true;
                                break;
                            }
                            if (!correctType || !SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), b.getLocation(), ProtectionModule.Action.BREAK_BLOCK)) continue;
                            if (SlimefunPlugin.getHooks().isCoreProtectInstalled()) {
                                SlimefunPlugin.getHooks().getCoreProtectAPI().logRemoval(e.getPlayer().getName(), b.getLocation(), b.getType(), b.getBlockData());
                            }
                            b.getWorld().playEffect(b.getLocation(), Effect.STEP_SOUND, (Object)b.getType());
                            for (ItemStack drop : b.getDrops()) {
                                b.getWorld().dropItemNaturally(b.getLocation(), drop);
                            }
                            b.setType(Material.AIR);
                            this.damageItem(e.getPlayer(), item);
                        }
                    }
                }
                return true;
            }
            return false;
        };
    }

    @Override
    public void postRegister() {
        this.damageOnUse = (Boolean)Slimefun.getItemValue(this.getID(), "damage-on-use");
    }

    @Override
    public boolean isDamageable() {
        return this.damageOnUse;
    }
}

