/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.items;

import java.util.List;
import java.util.Random;
import me.mrCookieSlime.CSCoreLibPlugin.CSCoreLib;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.CSCoreLibPlugin.general.Player.PlayerInventory;
import me.mrCookieSlime.CSCoreLibPlugin.general.String.StringUtils;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.HandledBlock;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.Interfaces.NotPlaceable;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.UnregisterReason;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockBreakHandler;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class ExplosivePickaxe
extends SlimefunItem
implements NotPlaceable {
    private String[] blacklist;
    private boolean damageOnUse;

    public ExplosivePickaxe(Category category, ItemStack item, String id, RecipeType recipeType, ItemStack[] recipe, String[] keys, Object[] values) {
        super(category, item, id, recipeType, recipe, keys, values);
    }

    @Override
    public void register(boolean slimefun) {
        final Random random = new Random();
        this.addItemHandler(new BlockBreakHandler(){

            @Override
            public boolean onBlockBreak(BlockBreakEvent e, ItemStack item, int fortune, List<ItemStack> drops) {
                if (SlimefunManager.isItemSimiliar(item, SlimefunItems.EXPLOSIVE_PICKAXE, true)) {
                    e.getBlock().getWorld().createExplosion(e.getBlock().getLocation(), 0.0f);
                    e.getBlock().getWorld().playSound(e.getBlock().getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
                    for (int x = -1; x <= 1; ++x) {
                        for (int y = -1; y <= 1; ++y) {
                            for (int z = -1; z <= 1; ++z) {
                                Block b = e.getBlock().getRelative(x, y, z);
                                if (b.getType() == Material.AIR || b.isLiquid() || StringUtils.equals((String)b.getType().toString(), (String[])ExplosivePickaxe.this.blacklist) || !CSCoreLib.getLib().getProtectionManager().canBuild(e.getPlayer().getUniqueId(), b)) continue;
                                if (SlimefunPlugin.getHooks().isCoreProtectInstalled()) {
                                    SlimefunPlugin.getHooks().getCoreProtectAPI().logRemoval(e.getPlayer().getName(), b.getLocation(), b.getType(), b.getBlockData());
                                }
                                b.getWorld().playEffect(b.getLocation(), Effect.STEP_SOUND, (Object)b.getType());
                                SlimefunItem sfItem = BlockStorage.check(b);
                                boolean allow = false;
                                if (sfItem != null && !(sfItem instanceof HandledBlock)) {
                                    if (SlimefunPlugin.getUtilities().blockHandlers.containsKey(sfItem.getID())) {
                                        allow = SlimefunPlugin.getUtilities().blockHandlers.get(sfItem.getID()).onBreak(e.getPlayer(), e.getBlock(), sfItem, UnregisterReason.PLAYER_BREAK);
                                    }
                                    if (allow) {
                                        drops.add(BlockStorage.retrieve(e.getBlock()));
                                    }
                                } else if (b.getType() == Material.PLAYER_HEAD) {
                                    b.breakNaturally();
                                } else if (b.getType().name().endsWith("_SHULKER_BOX")) {
                                    b.breakNaturally();
                                } else {
                                    for (ItemStack drop : b.getDrops()) {
                                        b.getWorld().dropItemNaturally(b.getLocation(), (ItemStack)(b.getType().toString().endsWith("_ORE") && b.getType() != Material.IRON_ORE && b.getType() != Material.GOLD_ORE ? new CustomItem(drop, fortune) : drop));
                                    }
                                    b.setType(Material.AIR);
                                }
                                if ((!ExplosivePickaxe.this.damageOnUse || item.getEnchantments().containsKey(Enchantment.DURABILITY)) && random.nextInt(100) > 60 + 40 / (item.getEnchantmentLevel(Enchantment.DURABILITY) + 1)) continue;
                                PlayerInventory.damageItemInHand((Player)e.getPlayer());
                            }
                        }
                    }
                    PlayerInventory.update((Player)e.getPlayer());
                    return true;
                }
                return false;
            }
        });
        super.register(slimefun);
        this.damageOnUse = (Boolean)Slimefun.getItemValue(this.getID(), "damage-on-use");
        Object value = Slimefun.getItemValue(this.getID(), "unbreakable-blocks");
        this.blacklist = (String[])((List)value).stream().toArray(String[]::new);
    }
}

