/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun;

import java.io.File;
import java.util.logging.Level;
import me.mrCookieSlime.CSCoreLibPlugin.CSCoreLib;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.PluginUtils;
import me.mrCookieSlime.CSCoreLibPlugin.general.Reflection.ReflectionUtils;
import me.mrCookieSlime.Slimefun.GEO.OreGenSystem;
import me.mrCookieSlime.Slimefun.GEO.Resources.NetherIceResource;
import me.mrCookieSlime.Slimefun.GEO.Resources.OilResource;
import me.mrCookieSlime.Slimefun.GPS.GPSNetwork;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.MultiBlock;
import me.mrCookieSlime.Slimefun.Objects.Research;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunArmorPiece;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.multiblocks.OreWasher;
import me.mrCookieSlime.Slimefun.Setup.CSCoreLibLoader;
import me.mrCookieSlime.Slimefun.Setup.Files;
import me.mrCookieSlime.Slimefun.Setup.Messages;
import me.mrCookieSlime.Slimefun.Setup.MiscSetup;
import me.mrCookieSlime.Slimefun.Setup.ResearchSetup;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.Setup.SlimefunSetup;
import me.mrCookieSlime.Slimefun.ancient_altar.AncientAltarListener;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.PlayerProfile;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunBackup;
import me.mrCookieSlime.Slimefun.api.TickerTask;
import me.mrCookieSlime.Slimefun.api.energy.ItemEnergy;
import me.mrCookieSlime.Slimefun.api.inventory.UniversalBlockMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.CargoNet;
import me.mrCookieSlime.Slimefun.autosave.BlockAutoSaver;
import me.mrCookieSlime.Slimefun.autosave.PlayerAutoSaver;
import me.mrCookieSlime.Slimefun.bstats.bukkit.Metrics;
import me.mrCookieSlime.Slimefun.commands.SlimefunCommand;
import me.mrCookieSlime.Slimefun.commands.SlimefunTabCompleter;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.BukkitUpdater;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.GitHubBuildsUpdater;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.Updater;
import me.mrCookieSlime.Slimefun.hooks.SlimefunHooks;
import me.mrCookieSlime.Slimefun.hooks.github.GitHubConnector;
import me.mrCookieSlime.Slimefun.hooks.github.GitHubSetup;
import me.mrCookieSlime.Slimefun.listeners.AndroidKillingListener;
import me.mrCookieSlime.Slimefun.listeners.ArmorListener;
import me.mrCookieSlime.Slimefun.listeners.AutonomousToolsListener;
import me.mrCookieSlime.Slimefun.listeners.BackpackListener;
import me.mrCookieSlime.Slimefun.listeners.BlockListener;
import me.mrCookieSlime.Slimefun.listeners.BowListener;
import me.mrCookieSlime.Slimefun.listeners.CoolerListener;
import me.mrCookieSlime.Slimefun.listeners.DamageListener;
import me.mrCookieSlime.Slimefun.listeners.FurnaceListener;
import me.mrCookieSlime.Slimefun.listeners.GearListener;
import me.mrCookieSlime.Slimefun.listeners.GuideOnJoinListener;
import me.mrCookieSlime.Slimefun.listeners.ItemListener;
import me.mrCookieSlime.Slimefun.listeners.ItemPickupListener;
import me.mrCookieSlime.Slimefun.listeners.NetworkListener;
import me.mrCookieSlime.Slimefun.listeners.PlayerQuitListener;
import me.mrCookieSlime.Slimefun.listeners.TalismanListener;
import me.mrCookieSlime.Slimefun.listeners.TeleporterListener;
import me.mrCookieSlime.Slimefun.listeners.ToolListener;
import me.mrCookieSlime.Slimefun.listeners.WorldListener;
import me.mrCookieSlime.Slimefun.utils.Settings;
import me.mrCookieSlime.Slimefun.utils.Utilities;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public final class SlimefunPlugin
extends JavaPlugin {
    public static SlimefunPlugin instance;
    private TickerTask ticker;
    private Config researches;
    private Config items;
    private Config whitelist;
    private Config config;
    public GPSNetwork gps = new GPSNetwork();
    private Utilities utilities = new Utilities();
    private Settings settings;
    private SlimefunHooks hooks;
    private final String[] supported = new String[]{"v1_14_"};

    public void onEnable() {
        CSCoreLibLoader loader = new CSCoreLibLoader((Plugin)this);
        if (loader.load()) {
            String currentVersion = ReflectionUtils.getVersion();
            if (currentVersion.startsWith("v")) {
                boolean compatibleVersion = false;
                StringBuilder versions = new StringBuilder();
                int i = 0;
                for (String version : this.supported) {
                    if (currentVersion.startsWith(version)) {
                        compatibleVersion = true;
                    }
                    if (i == 0) {
                        versions.append(version.substring(1).replaceFirst("_", ".").replace("_", ".X"));
                    } else if (i == this.supported.length - 1) {
                        versions.append(" or " + version.substring(1).replaceFirst("_", ".").replace("_", ".X"));
                    } else {
                        versions.append(", " + version.substring(1).replaceFirst("_", ".").replace("_", ".X"));
                    }
                    ++i;
                }
                if (!compatibleVersion) {
                    this.getLogger().log(Level.SEVERE, "### Slimefun was not installed correctly!");
                    this.getLogger().log(Level.SEVERE, "###");
                    this.getLogger().log(Level.SEVERE, "### You are using the wrong Version of Minecraft!");
                    this.getLogger().log(Level.SEVERE, "###");
                    this.getLogger().log(Level.SEVERE, "### You are using Minecraft " + ReflectionUtils.getVersion());
                    this.getLogger().log(Level.SEVERE, "### but Slimefun v" + this.getDescription().getVersion() + " requires you to be using");
                    this.getLogger().log(Level.SEVERE, "### Minecraft " + versions.toString());
                    this.getLogger().log(Level.SEVERE, "###");
                    this.getLogger().log(Level.SEVERE, "### Please use an older Version of Slimefun and disable auto-updating");
                    this.getLogger().log(Level.SEVERE, "### or consider updating your Server Software.");
                    this.getServer().getPluginManager().disablePlugin((Plugin)this);
                    return;
                }
            }
            instance = this;
            this.getLogger().log(Level.INFO, "Loading Files...");
            Files files = new Files();
            files.cleanup();
            this.getLogger().log(Level.INFO, "Loading Config...");
            PluginUtils utils = new PluginUtils((Plugin)this);
            utils.setupConfig();
            this.config = utils.getConfig();
            this.settings = new Settings(this.config);
            this.researches = new Config(files.researches);
            this.items = new Config(files.items);
            this.whitelist = new Config(files.whitelist);
            utils.setupLocalization();
            Messages.local = utils.getLocalization();
            Messages.setup();
            new Metrics((Plugin)this);
            Updater updater = !this.getDescription().getVersion().startsWith("DEV - ") ? new BukkitUpdater((Plugin)this, this.getFile(), 53485) : new GitHubBuildsUpdater((Plugin)this, this.getFile(), "TheBusyBiscuit/Slimefun4/master");
            if (this.config.getBoolean("options.auto-update")) {
                updater.start();
            }
            String[] storage = new String[]{"blocks", "stored-blocks", "stored-inventories", "stored-chunks", "universal-inventories", "waypoints", "block-backups"};
            String[] general = new String[]{"scripts", "generators", "error-reports", "cache/github"};
            for (String s : storage) {
                this.createDir("data-storage/Slimefun/" + s);
            }
            for (String s : general) {
                this.createDir("plugins/Slimefun/" + s);
            }
            this.getLogger().log(Level.INFO, "Loading Items...");
            MiscSetup.setupItemSettings();
            try {
                SlimefunSetup.setupItems();
            }
            catch (Exception x) {
                this.getLogger().log(Level.SEVERE, "An Error occured while initializing SlimefunItems for Slimefun " + Slimefun.getVersion());
            }
            MiscSetup.loadDescriptions();
            this.settings.researchesEnabled = SlimefunPlugin.getResearchCfg().getBoolean("enable-researching");
            this.settings.smelteryFireBreakChance = (Integer)Slimefun.getItemValue("SMELTERY", "chance.fireBreak");
            this.getLogger().log(Level.INFO, "Loading Researches...");
            ResearchSetup.setupResearches();
            MiscSetup.setupMisc();
            this.getLogger().log(Level.INFO, "Loading World Generators...");
            OreGenSystem.registerResource(new OilResource());
            OreGenSystem.registerResource(new NetherIceResource());
            GitHubSetup.setup();
            new ArmorListener(this);
            new ItemListener(this);
            new BlockListener(this);
            new GearListener(this);
            new AutonomousToolsListener(this);
            new DamageListener(this);
            new BowListener(this);
            new ToolListener(this);
            new FurnaceListener(this);
            new TeleporterListener(this);
            new AndroidKillingListener(this);
            new NetworkListener(this);
            new ItemPickupListener(this);
            if (this.config.getBoolean("items.talismans")) {
                new TalismanListener(this);
            }
            if (this.config.getBoolean("items.backpacks")) {
                new BackpackListener(this);
            }
            if (this.config.getBoolean("items.coolers")) {
                new CoolerListener(this);
            }
            if (this.config.getBoolean("options.give-guide-on-first-join")) {
                new GuideOnJoinListener(this);
            }
            new WorldListener(this);
            new PlayerQuitListener(this);
            this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
                MiscSetup.loadItems(this.settings);
                for (World world : Bukkit.getWorlds()) {
                    new BlockStorage(world);
                }
                if (SlimefunItem.getByID("ANCIENT_ALTAR") != null) {
                    new AncientAltarListener(instance);
                }
            }, 0L);
            SlimefunCommand command = new SlimefunCommand(this);
            this.getCommand("slimefun").setExecutor((CommandExecutor)command);
            this.getCommand("slimefun").setTabCompleter((TabCompleter)new SlimefunTabCompleter(command));
            if (this.config.getBoolean("options.enable-armor-effects")) {
                this.getServer().getScheduler().runTaskTimer((Plugin)this, () -> {
                    block0: for (Player p : Bukkit.getOnlinePlayers()) {
                        for (ItemStack armor : p.getInventory().getArmorContents()) {
                            if (armor == null || !Slimefun.hasUnlocked(p, armor, true)) continue;
                            if (SlimefunItem.getByItem(armor) instanceof SlimefunArmorPiece) {
                                for (PotionEffect effect : ((SlimefunArmorPiece)SlimefunItem.getByItem(armor)).getEffects()) {
                                    p.removePotionEffect(effect.getType());
                                    p.addPotionEffect(effect);
                                }
                            }
                            if ((!SlimefunManager.isItemSimiliar(armor, SlimefunItem.getItem("SOLAR_HELMET"), false) || p.getWorld().getTime() >= 12300L) && (p.getWorld().getTime() <= 23850L || p.getEyeLocation().getBlock().getLightFromSky() != 15)) continue;
                            ItemEnergy.chargeInventory(p, Float.valueOf(String.valueOf(Slimefun.getItemValue("SOLAR_HELMET", "charge-amount"))).floatValue());
                        }
                        for (ItemStack radioactive : this.utilities.radioactiveItems) {
                            if (!p.getInventory().containsAtLeast(radioactive, 1) && !SlimefunManager.isItemSimiliar(p.getInventory().getItemInOffHand(), radioactive, true)) continue;
                            if (SlimefunManager.isItemSimiliar(SlimefunItems.SCUBA_HELMET, p.getInventory().getHelmet(), true) && SlimefunManager.isItemSimiliar(SlimefunItems.HAZMATSUIT_CHESTPLATE, p.getInventory().getChestplate(), true) && SlimefunManager.isItemSimiliar(SlimefunItems.HAZMATSUIT_LEGGINGS, p.getInventory().getLeggings(), true) && SlimefunManager.isItemSimiliar(SlimefunItems.RUBBER_BOOTS, p.getInventory().getBoots(), true)) continue block0;
                            if (!Slimefun.isEnabled(p, radioactive, false)) continue;
                            p.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, 400, 3));
                            p.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 400, 3));
                            p.addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, 400, 3));
                            p.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 400, 3));
                            p.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 400, 1));
                            p.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_DIGGING, 400, 1));
                            p.setFireTicks(400);
                            continue block0;
                        }
                    }
                }, 0L, (long)this.config.getInt("options.armor-update-interval") * 20L);
            }
            this.ticker = new TickerTask();
            this.getServer().getScheduler().runTaskTimer((Plugin)this, (Runnable)new PlayerAutoSaver(), 2000L, (long)this.settings.blocksAutoSaveDelay * 60L * 20L);
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)new BlockAutoSaver(), 2000L, (long)this.settings.blocksAutoSaveDelay * 60L * 20L);
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)this.ticker, 100L, (long)this.config.getInt("URID.custom-ticker-delay"));
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> this.utilities.connectors.forEach(GitHubConnector::pullFile), 80L, 72000L);
            this.getLogger().log(Level.INFO, "Finished!");
            this.hooks = new SlimefunHooks(this);
            OreWasher.items = new ItemStack[]{SlimefunItems.IRON_DUST, SlimefunItems.GOLD_DUST, SlimefunItems.ALUMINUM_DUST, SlimefunItems.COPPER_DUST, SlimefunItems.ZINC_DUST, SlimefunItems.TIN_DUST, SlimefunItems.LEAD_DUST, SlimefunItems.SILVER_DUST, SlimefunItems.MAGNESIUM_DUST};
            CSCoreLib.getLib().filterLog("([A-Za-z0-9_]{3,16}) issued server command: /sf elevator (.{0,})");
        }
    }

    public void onDisable() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        if (this.ticker != null) {
            this.ticker.halted = true;
            this.ticker.run();
        }
        PlayerProfile.iterator().forEachRemaining(profile -> {
            if (profile.isDirty()) {
                profile.save();
            }
        });
        for (World world : Bukkit.getWorlds()) {
            try {
                BlockStorage storage = BlockStorage.getStorage(world);
                if (storage != null) {
                    storage.save(true);
                    continue;
                }
                this.getLogger().log(Level.SEVERE, "Could not save Slimefun Blocks for World \"" + world.getName() + "\"");
            }
            catch (Exception x) {
                this.getLogger().log(Level.SEVERE, "An Error occured while saving Slimefun-Blocks in World '" + world.getName() + "' for Slimefun " + Slimefun.getVersion());
            }
        }
        for (UniversalBlockMenu menu : this.utilities.universalInventories.values()) {
            menu.save();
        }
        SlimefunBackup.start();
        Messages.local = null;
        MultiBlock.list = null;
        Research.list = null;
        SlimefunItem.all = null;
        SlimefunItem.items = null;
        SlimefunItem.mapID = null;
        AContainer.processing = null;
        AContainer.progress = null;
        CargoNet.faces = null;
        OreWasher.items = null;
        instance = null;
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.closeInventory();
        }
    }

    private void createDir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static Config getCfg() {
        return SlimefunPlugin.instance.config;
    }

    public static Config getResearchCfg() {
        return SlimefunPlugin.instance.researches;
    }

    public static Config getItemCfg() {
        return SlimefunPlugin.instance.items;
    }

    public static Config getWhitelist() {
        return SlimefunPlugin.instance.whitelist;
    }

    @Deprecated
    public static int randomize(int max) {
        if (max < 1) {
            return 0;
        }
        return CSCoreLib.randomizer().nextInt(max);
    }

    @Deprecated
    public static boolean chance(int max, int percentage) {
        if (max < 1) {
            return false;
        }
        return CSCoreLib.randomizer().nextInt(max) <= percentage;
    }

    public static SlimefunHooks getHooks() {
        return SlimefunPlugin.instance.hooks;
    }

    public static Utilities getUtilities() {
        return SlimefunPlugin.instance.utilities;
    }

    public static Settings getSettings() {
        return SlimefunPlugin.instance.settings;
    }

    public static TickerTask getTicker() {
        return SlimefunPlugin.instance.ticker;
    }

    public static boolean isActive() {
        return instance != null;
    }
}

