/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.holograms;

import java.util.List;
import me.mrCookieSlime.CSCoreLibPlugin.general.World.ArmorStandFactory;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;

public final class AndroidHologram {
    private static final double offset = 1.2;

    private AndroidHologram() {
    }

    public static void update(Block b, String name) {
        ArmorStand hologram = AndroidHologram.getArmorStand(b, true);
        hologram.setCustomName(name);
    }

    public static void remove(Block b) {
        ArmorStand hologram = AndroidHologram.getArmorStand(b, false);
        if (hologram != null) {
            hologram.remove();
        }
    }

    public static List<Entity> getNearbyEntities(Block b, double radius) {
        ArmorStand hologram = AndroidHologram.getArmorStand(b, true);
        return hologram.getNearbyEntities(radius, 1.0, radius);
    }

    public static List<Entity> getNearbyEntities(Block b, double radius, double y) {
        ArmorStand hologram = AndroidHologram.getArmorStand(b, true);
        return hologram.getNearbyEntities(radius, y, radius);
    }

    private static ArmorStand getArmorStand(Block b, boolean createIfNoneExists) {
        Location l = new Location(b.getWorld(), (double)b.getX() + 0.5, (double)b.getY() + 1.2, (double)b.getZ() + 0.5);
        for (Entity n : l.getChunk().getEntities()) {
            if (!(n instanceof ArmorStand) || n.getCustomName() != null || !(l.distanceSquared(n.getLocation()) < 0.4)) continue;
            return (ArmorStand)n;
        }
        if (!createIfNoneExists) {
            return null;
        }
        ArmorStand hologram = ArmorStandFactory.createHidden((Location)l);
        hologram.setCustomNameVisible(false);
        hologram.setCustomName(null);
        return hologram;
    }
}

