/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.Research;
import me.mrCookieSlime.Slimefun.Objects.SlimefunBlockHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.ChargableItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.ChargedItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.DamagableChargableItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunBackpack;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunMachine;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.VanillaItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.handlers.ItemHandler;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.ancient_altar.AltarRecipe;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.energy.EnergyNet;
import me.mrCookieSlime.Slimefun.api.energy.EnergyNetComponent;
import me.mrCookieSlime.Slimefun.api.energy.EnergyTicker;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class SlimefunItem {
    public static List<SlimefunItem> items = new ArrayList<SlimefunItem>();
    public static Map<String, SlimefunItem> mapID = new HashMap<String, SlimefunItem>();
    public static List<ItemStack> radioactive = new ArrayList<ItemStack>();
    public static Set<String> tickers = new HashSet<String>();
    public static List<SlimefunItem> all = new ArrayList<SlimefunItem>();
    public static Map<String, Set<me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler>> handlers = new HashMap<String, Set<me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler>>();
    public static Map<String, SlimefunBlockHandler> blockhandler = new HashMap<String, SlimefunBlockHandler>();
    private String id;
    private String hash;
    private State state;
    private ItemStack item;
    private Category category;
    private ItemStack[] recipe;
    private RecipeType recipeType;
    protected ItemStack recipeOutput = null;
    private Research research;
    private int month = -1;
    private boolean enchantable = true;
    private boolean disenchantable = true;
    private boolean hidden = false;
    private boolean replacing = false;
    private boolean addon = false;
    private String permission = "";
    private Set<me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler> itemhandlers = new HashSet<me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler>();
    private boolean ticking = false;
    private BlockTicker blockTicker;
    private EnergyTicker energyTicker;
    private String[] keys = null;
    private Object[] values = null;
    private String wiki = null;

    public SlimefunItem(Category category, ItemStack item, String id, RecipeType recipeType, ItemStack[] recipe) {
        this.item = item;
        this.category = category;
        this.id = id;
        this.recipeType = recipeType;
        this.recipe = recipe;
    }

    public SlimefunItem(Category category, ItemStack item, String id, RecipeType recipeType, ItemStack[] recipe, ItemStack recipeOutput) {
        this.item = item;
        this.category = category;
        this.id = id;
        this.recipeType = recipeType;
        this.recipe = recipe;
        this.recipeOutput = recipeOutput;
    }

    public SlimefunItem(Category category, ItemStack item, String id, RecipeType recipeType, ItemStack[] recipe, ItemStack recipeOutput, String[] keys, Object[] values) {
        this.item = item;
        this.category = category;
        this.id = id;
        this.recipeType = recipeType;
        this.recipe = recipe;
        this.recipeOutput = recipeOutput;
        this.keys = keys;
        this.values = values;
    }

    public SlimefunItem(Category category, ItemStack item, String id, RecipeType recipeType, ItemStack[] recipe, String[] keys, Object[] values) {
        this.item = item;
        this.category = category;
        this.id = id;
        this.recipeType = recipeType;
        this.recipe = recipe;
        this.keys = keys;
        this.values = values;
    }

    public SlimefunItem(Category category, ItemStack item, String id, RecipeType recipeType, ItemStack[] recipe, boolean hidden) {
        this.item = item;
        this.category = category;
        this.id = id;
        this.recipeType = recipeType;
        this.recipe = recipe;
        this.hidden = hidden;
    }

    @Deprecated
    public String getName() {
        return this.id;
    }

    public String getID() {
        return this.id;
    }

    public String getHash() {
        return this.hash;
    }

    public State getState() {
        return this.state;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public Category getCategory() {
        return this.category;
    }

    public ItemStack[] getRecipe() {
        return this.recipe;
    }

    public RecipeType getRecipeType() {
        return this.recipeType;
    }

    @Deprecated
    public ItemStack getCustomOutput() {
        return this.recipeOutput;
    }

    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    public Research getResearch() {
        return this.research;
    }

    public int getMonth() {
        return this.month;
    }

    public boolean isEnchantable() {
        return this.enchantable;
    }

    public boolean isDisenchantable() {
        return this.disenchantable;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isReplacing() {
        return this.replacing;
    }

    public boolean isAddonItem() {
        return this.addon;
    }

    public String getPermission() {
        return this.permission;
    }

    public Set<me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler> getHandlers() {
        return this.itemhandlers;
    }

    public boolean isTicking() {
        return this.ticking;
    }

    @Deprecated
    public BlockTicker getTicker() {
        return this.blockTicker;
    }

    public BlockTicker getBlockTicker() {
        return this.blockTicker;
    }

    public EnergyTicker getEnergyTicker() {
        return this.energyTicker;
    }

    public String[] listKeys() {
        return this.keys;
    }

    public Object[] listValues() {
        return this.values;
    }

    public boolean isDisabled() {
        return this.state != State.ENABLED;
    }

    public void register() {
        this.register(false);
    }

    public void register(boolean slimefun) {
        this.addon = !slimefun;
        try {
            if (mapID.containsKey(this.id)) {
                throw new IllegalArgumentException("ID \"" + this.id + "\" already exists");
            }
            if (this.recipe.length < 9) {
                this.recipe = new ItemStack[]{null, null, null, null, null, null, null, null, null};
            }
            all.add(this);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".enabled", (Object)true);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".can-be-used-in-workbenches", (Object)this.replacing);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".hide-in-guide", (Object)this.hidden);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".allow-enchanting", (Object)this.enchantable);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".allow-disenchanting", (Object)this.disenchantable);
            SlimefunPlugin.getItemCfg().setDefaultValue(this.id + ".required-permission", (Object)this.permission);
            if (this.keys != null && this.values != null) {
                for (int i = 0; i < this.keys.length; ++i) {
                    SlimefunPlugin.getItemCfg().setDefaultValue(this.id + "." + this.keys[i], this.values[i]);
                }
            }
            for (World world : Bukkit.getWorlds()) {
                SlimefunPlugin.getWhitelist().setDefaultValue(world.getName() + ".enabled", (Object)true);
                SlimefunPlugin.getWhitelist().setDefaultValue(world.getName() + ".enabled-items." + this.id, (Object)true);
            }
            if (this.ticking && !SlimefunPlugin.getCfg().getBoolean("URID.enable-tickers")) {
                this.state = State.DISABLED;
                return;
            }
            if (SlimefunPlugin.getItemCfg().getBoolean(this.id + ".enabled")) {
                if (!Category.list().contains(this.category)) {
                    this.category.register();
                }
                this.state = State.ENABLED;
                this.replacing = SlimefunPlugin.getItemCfg().getBoolean(this.id + ".can-be-used-in-workbenches");
                this.hidden = SlimefunPlugin.getItemCfg().getBoolean(this.id + ".hide-in-guide");
                this.enchantable = SlimefunPlugin.getItemCfg().getBoolean(this.id + ".allow-enchanting");
                this.disenchantable = SlimefunPlugin.getItemCfg().getBoolean(this.id + ".allow-disenchanting");
                this.permission = SlimefunPlugin.getItemCfg().getString(this.id + ".required-permission");
                items.add(this);
                if (slimefun) {
                    ++SlimefunPlugin.getUtilities().vanillaItems;
                }
                mapID.put(this.id, this);
                this.create();
                for (me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler handler : this.itemhandlers) {
                    Set<me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler> handlerset = SlimefunItem.getHandlers(handler.toCodename());
                    handlerset.add(handler);
                    handlers.put(handler.toCodename(), handlerset);
                }
                if (SlimefunPlugin.getSettings().printOutLoading) {
                    Slimefun.getLogger().log(Level.INFO, "Loaded Item \"{0}\"", this.id);
                }
            } else {
                this.state = this instanceof VanillaItem ? State.VANILLA : State.DISABLED;
            }
        }
        catch (Exception x) {
            Slimefun.getLogger().log(Level.WARNING, "Registering the Item '" + this.id + "' for Slimefun " + Slimefun.getVersion() + " has failed", x);
        }
    }

    public static List<SlimefunItem> list() {
        return items;
    }

    public void bindToResearch(Research r) {
        if (r != null) {
            r.getAffectedItems().add(this);
        }
        this.research = r;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setRecipe(ItemStack[] recipe) {
        this.recipe = recipe;
    }

    public void setRecipeType(RecipeType type) {
        this.recipeType = type;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public void setRecipeOutput(ItemStack output) {
        this.recipeOutput = output;
    }

    public void setReplacing(boolean replacing) {
        this.replacing = replacing;
    }

    @Deprecated
    public static SlimefunItem getByName(String name) {
        return mapID.get(name);
    }

    public static SlimefunItem getByID(String id) {
        return mapID.get(id);
    }

    public static SlimefunItem getByItem(ItemStack item) {
        if (item == null) {
            return null;
        }
        for (SlimefunItem sfi : items) {
            if (!(sfi instanceof ChargableItem && SlimefunManager.isItemSimiliar(item, sfi.getItem(), false) || sfi instanceof DamagableChargableItem && SlimefunManager.isItemSimiliar(item, sfi.getItem(), false) || sfi instanceof ChargedItem && SlimefunManager.isItemSimiliar(item, sfi.getItem(), false) || sfi instanceof SlimefunBackpack && SlimefunManager.isItemSimiliar(item, sfi.getItem(), false)) && !SlimefunManager.isItemSimiliar(item, sfi.getItem(), true)) continue;
            return sfi;
        }
        if (SlimefunManager.isItemSimiliar(item, SlimefunItems.BROKEN_SPAWNER, false)) {
            return SlimefunItem.getByID("BROKEN_SPAWNER");
        }
        if (SlimefunManager.isItemSimiliar(item, SlimefunItems.REPAIRED_SPAWNER, false)) {
            return SlimefunItem.getByID("REINFORCED_SPAWNER");
        }
        return null;
    }

    public boolean isItem(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (this instanceof ChargableItem && SlimefunManager.isItemSimiliar(item, this.item, false)) {
            return true;
        }
        if (this instanceof DamagableChargableItem && SlimefunManager.isItemSimiliar(item, this.item, false)) {
            return true;
        }
        if (this instanceof ChargedItem && SlimefunManager.isItemSimiliar(item, this.item, false)) {
            return true;
        }
        return SlimefunManager.isItemSimiliar(item, this.item, true);
    }

    public void load() {
        try {
            if (!this.hidden) {
                this.category.add(this);
            }
            ItemStack output = this.item.clone();
            if (this.recipeOutput != null) {
                output = this.recipeOutput.clone();
            }
            if (this.recipeType.toItem().isSimilar(RecipeType.MOB_DROP.toItem())) {
                String mob = ChatColor.stripColor((String)this.recipe[4].getItemMeta().getDisplayName()).toUpperCase().replace(" ", "_");
                try {
                    EntityType entity = EntityType.valueOf((String)mob);
                    List dropping = SlimefunPlugin.getUtilities().drops.getOrDefault(entity, new ArrayList());
                    dropping.add(output);
                    SlimefunPlugin.getUtilities().drops.put(entity, dropping);
                }
                catch (Exception x) {
                    Slimefun.getLogger().log(Level.WARNING, "An Exception occured when setting a Drop for the Mob: " + mob + " (" + x.getClass().getSimpleName() + ")");
                }
            } else if (this.recipeType.toItem().isSimilar(RecipeType.ANCIENT_ALTAR.toItem())) {
                new AltarRecipe(Arrays.asList(this.recipe), output);
            } else if (this.recipeType.getMachine() != null && SlimefunItem.getByID(this.recipeType.getMachine().getID()) instanceof SlimefunMachine) {
                ((SlimefunMachine)SlimefunItem.getByID(this.recipeType.getMachine().getID())).addRecipe(this.recipe, output);
            }
            this.install();
        }
        catch (Exception x) {
            Slimefun.getLogger().log(Level.WARNING, "Item Setup failed: " + this.id + " (" + x.getClass().getSimpleName() + ")");
        }
    }

    public static State getState(ItemStack item) {
        for (SlimefunItem i : all) {
            if (!i.isItem(item)) continue;
            return i.getState();
        }
        return State.ENABLED;
    }

    public static boolean isDisabled(ItemStack item) {
        for (SlimefunItem i : all) {
            if (!i.isItem(item)) continue;
            return i.isDisabled();
        }
        return false;
    }

    public void install() {
    }

    public void create() {
    }

    @Deprecated
    public void addItemHandler(ItemHandler ... handler) {
        this.addItemHandler((me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler[])handler);
    }

    public void addItemHandler(me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler ... handler) {
        this.itemhandlers.addAll(Arrays.asList(handler));
        for (me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler h : handler) {
            if (h instanceof BlockTicker) {
                this.ticking = true;
                tickers.add(this.getID());
                this.blockTicker = (BlockTicker)h;
                continue;
            }
            if (!(h instanceof EnergyTicker)) continue;
            this.energyTicker = (EnergyTicker)h;
            EnergyNet.registerComponent(this.getID(), EnergyNetComponent.SOURCE);
        }
    }

    public void register(boolean vanilla, me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler ... handlers) {
        this.addItemHandler(handlers);
        this.register(vanilla);
    }

    public void register(me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler ... handlers) {
        this.addItemHandler(handlers);
        this.register(false);
    }

    @Deprecated
    public void register(boolean vanilla, ItemHandler ... handlers) {
        this.addItemHandler(handlers);
        this.register(vanilla);
    }

    @Deprecated
    public void register(ItemHandler ... handlers) {
        this.register((me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler[])handlers);
    }

    public void register(boolean vanilla, SlimefunBlockHandler handler) {
        blockhandler.put(this.getID(), handler);
        this.register(vanilla);
    }

    public void register(SlimefunBlockHandler handler) {
        blockhandler.put(this.getID(), handler);
        this.register(false);
    }

    public static Set<me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler> getHandlers(String codeid) {
        if (handlers.containsKey(codeid)) {
            return handlers.get(codeid);
        }
        return new HashSet<me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler>();
    }

    public static void setRadioactive(ItemStack item) {
        radioactive.add(item);
    }

    public static ItemStack getItem(String id) {
        SlimefunItem item = SlimefunItem.getByID(id);
        return item != null ? item.getItem() : null;
    }

    public static void patchExistingItem(String id, ItemStack stack) {
        SlimefunItem item = SlimefunItem.getByID(id);
        if (item != null) {
            Slimefun.getLogger().log(Level.INFO, "Patching existing Item... {0}", id);
            Slimefun.getLogger().log(Level.INFO, "This might take a while");
            ItemStack old = item.getItem();
            item.setItem(stack);
            for (SlimefunItem sfi : SlimefunItem.list()) {
                ItemStack[] recipe = sfi.getRecipe();
                for (int i = 0; i < 9; ++i) {
                    if (!SlimefunManager.isItemSimiliar(recipe[i], old, true)) continue;
                    recipe[i] = stack;
                }
                sfi.setRecipe(recipe);
            }
        }
    }

    public void registerChargeableBlock(int capacity) {
        this.registerChargeableBlock(false, capacity);
    }

    public void registerChargeableBlock(boolean slimefun, int capacity) {
        this.register(slimefun);
        ChargableBlock.registerChargableBlock(this.id, capacity, true);
        EnergyNet.registerComponent(this.id, EnergyNetComponent.CONSUMER);
    }

    public void registerUnrechargeableBlock(boolean slimefun, int capacity) {
        this.register(slimefun);
        ChargableBlock.registerChargableBlock(this.id, capacity, false);
    }

    public void registerBlockCapacitor(boolean slimefun, int capacity) {
        this.register(slimefun);
        ChargableBlock.registerCapacitor(this.id, capacity);
    }

    public void registerEnergyDistributor(boolean slimefun) {
        this.register(slimefun);
        EnergyNet.registerComponent(this.id, EnergyNetComponent.DISTRIBUTOR);
    }

    public void registerDistibutingCapacitor(boolean slimefun, int capacity) {
        this.register(slimefun);
        EnergyNet.registerComponent(this.id, EnergyNetComponent.DISTRIBUTOR);
        ChargableBlock.registerCapacitor(this.id, capacity);
    }

    protected void setItem(ItemStack stack) {
        this.item = stack;
    }

    public static boolean isTicking(String item) {
        return tickers.contains(item);
    }

    public static void registerBlockHandler(String id, SlimefunBlockHandler handler) {
        blockhandler.put(id, handler);
    }

    public void registerChargeableBlock(boolean vanilla, int capacity, me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler ... handlers) {
        this.addItemHandler(handlers);
        this.registerChargeableBlock(vanilla, capacity);
    }

    public BlockMenu getBlockMenu(Block b) {
        return BlockStorage.getInventory(b);
    }

    public void addWikipage(String page) {
        this.wiki = "https://github.com/TheBusyBiscuit/Slimefun4/wiki/" + page;
    }

    public boolean hasWiki() {
        return this.wiki != null;
    }

    public String getWiki() {
        return this.wiki;
    }

    public String toString() {
        return "SlimefunItem: " + this.id + " (" + (Object)((Object)this.state) + ", vanilla=" + !this.addon + ")";
    }

    public static enum State {
        ENABLED,
        DISABLED,
        VANILLA;

    }
}

