/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.IntStream;
import me.mrCookieSlime.CSCoreLibPlugin.CSCoreLib;
import me.mrCookieSlime.CSCoreLibPlugin.general.Clock;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.PlayerProfile;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.TickerTask;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ErrorReport {
    private File file;

    public ErrorReport(Throwable throwable, Consumer<PrintStream> printer) {
        AutoCloseable stream;
        String path = "plugins/Slimefun/error-reports/" + Clock.getFormattedTime();
        this.file = new File(path + ".err");
        if (this.file.exists()) {
            stream = IntStream.iterate(1, i -> i + 1).filter(i -> !new File(path + " (" + i + ").err").exists());
            int id = stream.findFirst().getAsInt();
            this.file = new File(path + " (" + id + ").err");
        }
        try {
            stream = new PrintStream(this.file);
            Throwable throwable2 = null;
            try {
                ((PrintStream)stream).println();
                ((PrintStream)stream).println("Java Environment:");
                ((PrintStream)stream).println("  Operating System: " + System.getProperty("os.name"));
                ((PrintStream)stream).println("  Java Version: " + System.getProperty("java.version"));
                ((PrintStream)stream).println();
                ((PrintStream)stream).println("Server Software: " + Bukkit.getName());
                ((PrintStream)stream).println("  Build: " + Bukkit.getVersion());
                ((PrintStream)stream).println("  Minecraft: " + Bukkit.getBukkitVersion());
                ((PrintStream)stream).println();
                ((PrintStream)stream).println("Slimefun Environment:");
                ((PrintStream)stream).println("  CS-CoreLib v" + CSCoreLib.getLib().getDescription().getVersion());
                ((PrintStream)stream).println("  Slimefun v" + SlimefunPlugin.instance.getDescription().getVersion());
                ((PrintStream)stream).println();
                ArrayList<String> plugins = new ArrayList<String>();
                ArrayList<String> addons = new ArrayList<String>();
                for (Plugin p : Bukkit.getPluginManager().getPlugins()) {
                    if (Bukkit.getPluginManager().isPluginEnabled(p)) {
                        plugins.add("  + " + p.getName() + " " + p.getDescription().getVersion());
                        if (!p.getDescription().getDepend().contains("Slimefun") && !p.getDescription().getSoftDepend().contains("Slimefun")) continue;
                        addons.add("  + " + p.getName() + " " + p.getDescription().getVersion());
                        continue;
                    }
                    plugins.add("  - " + p.getName() + " " + p.getDescription().getVersion());
                    if (!p.getDescription().getDepend().contains("Slimefun") && !p.getDescription().getSoftDepend().contains("Slimefun")) continue;
                    addons.add("  - " + p.getName() + " " + p.getDescription().getVersion());
                }
                ((PrintStream)stream).println("Installed Addons (" + addons.size() + ")");
                addons.forEach(((PrintStream)stream)::println);
                ((PrintStream)stream).println();
                ((PrintStream)stream).println("Installed Plugins (" + plugins.size() + "):");
                plugins.forEach(((PrintStream)stream)::println);
                ((PrintStream)stream).println();
                printer.accept((PrintStream)stream);
                ((PrintStream)stream).println("Stacktrace:");
                ((PrintStream)stream).println();
                throwable.printStackTrace((PrintStream)stream);
                Slimefun.getLogger().log(Level.WARNING, "An Error occured! It has been saved as: ");
                Slimefun.getLogger().log(Level.WARNING, "/plugins/Slimefun/error-reports/" + this.file.getName());
                Slimefun.getLogger().log(Level.WARNING, "Please consider sending this File to the developer(s) of Slimefun, this message does not have to be included.");
                Slimefun.getLogger().log(Level.WARNING, "You can put the file on Pastebin and then post it here: https://github.com/TheBusyBiscuit/Slimefun4/issues");
                Slimefun.getLogger().log(Level.WARNING, "");
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                if (stream != null) {
                    if (throwable2 != null) {
                        try {
                            ((PrintStream)stream).close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                    } else {
                        ((PrintStream)stream).close();
                    }
                }
            }
        }
        catch (FileNotFoundException x) {
            Slimefun.getLogger().log(Level.SEVERE, "An Error occured while saving an Error-Report for Slimefun " + Slimefun.getVersion(), x);
        }
    }

    public ErrorReport(Throwable throwable, TickerTask task, Location l, SlimefunItem item) {
        this(throwable, (PrintStream stream) -> {
            stream.println("Block Info:");
            stream.println("  World: " + l.getWorld().getName());
            stream.println("  X: " + l.getBlockX());
            stream.println("  Y: " + l.getBlockY());
            stream.println("  Z: " + l.getBlockZ());
            stream.println("  Material: " + l.getBlock().getType());
            stream.println("  State: " + l.getBlock().getState().getClass().getName());
            stream.println();
            stream.println("Ticker-Info:");
            stream.println("  Type: " + (item.getBlockTicker().isSynchronized() ? "Synchronized" : "Asynchronous"));
            stream.println("  Object Dump: " + task.toString());
            stream.println();
            stream.println("Slimefun Data:");
            stream.println("  ID: " + item.getID());
            stream.println("  Inventory: " + BlockStorage.getStorage(l.getWorld()).hasInventory(l));
            stream.println("  Data: " + BlockStorage.getBlockInfoAsJson(l));
            stream.println();
        });
    }

    public ErrorReport(Throwable throwable, Player p) {
        this(throwable, (PrintStream stream) -> {
            stream.println("Player Info:");
            stream.println("  ID: " + p.getUniqueId() + " (" + p.getName() + ")");
            stream.println("  World: " + p.getWorld().getName());
            stream.println("  X: " + p.getLocation().getX());
            stream.println("  Y: " + p.getLocation().getY());
            stream.println("  Z: " + p.getLocation().getZ());
            stream.println("  Profile in RAM? " + PlayerProfile.isLoaded(p.getUniqueId()));
            stream.println();
            stream.println("Item in Main Hand:");
            stream.println(p.getInventory().getItemInMainHand());
            stream.println(SlimefunItem.getByItem(p.getInventory().getItemInMainHand()));
            stream.println();
            stream.println("Item in Off Hand:");
            stream.println(p.getInventory().getItemInOffHand());
            stream.println(SlimefunItem.getByItem(p.getInventory().getItemInOffHand()));
            stream.println();
            stream.println("Helmet:");
            stream.println(p.getInventory().getHelmet());
            stream.println(SlimefunItem.getByItem(p.getInventory().getHelmet()));
            stream.println();
            stream.println("Chestplate:");
            stream.println(p.getInventory().getChestplate());
            stream.println(SlimefunItem.getByItem(p.getInventory().getChestplate()));
            stream.println();
            stream.println("Leggings:");
            stream.println(p.getInventory().getLeggings());
            stream.println(SlimefunItem.getByItem(p.getInventory().getLeggings()));
            stream.println();
            stream.println("Boots:");
            stream.println(p.getInventory().getBoots());
            stream.println(SlimefunItem.getByItem(p.getInventory().getBoots()));
            stream.println();
        });
    }

    public File getFile() {
        return this.file;
    }

    public static void tryCatch(Function<Exception, ErrorReport> function, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception x) {
            function.apply(x);
        }
    }
}

