/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines;

import java.util.logging.Level;
import me.mrCookieSlime.CSCoreLibPlugin.CSCoreLib;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunBlockHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.UnregisterReason;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.holograms.XPCollectorHologram;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class XPCollector
extends SlimefunItem {
    private static final int[] border = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};

    public XPCollector(Category category, ItemStack item, String name, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, name, recipeType, recipe);
        new BlockMenuPreset(name, "&aEXP Collector"){

            @Override
            public void init() {
                XPCollector.this.constructMenu(this);
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || CSCoreLib.getLib().getProtectionManager().canAccessChest(p.getUniqueId(), b, true);
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.WITHDRAW) {
                    return XPCollector.this.getOutputSlots();
                }
                return new int[0];
            }
        };
        XPCollector.registerBlockHandler(name, new SlimefunBlockHandler(){

            @Override
            public void onPlace(Player p, Block b, SlimefunItem item) {
                BlockStorage.addBlockInfo(b, "owner", p.getUniqueId().toString());
            }

            @Override
            public boolean onBreak(Player p, Block b, SlimefunItem item, UnregisterReason reason) {
                XPCollectorHologram.remove(b);
                BlockMenu inv = BlockStorage.getInventory(b);
                if (inv != null) {
                    for (int slot : XPCollector.this.getOutputSlots()) {
                        if (inv.getItemInSlot(slot) == null) continue;
                        b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                        inv.replaceExistingItem(slot, null);
                    }
                }
                return true;
            }
        });
    }

    private Inventory inject(Block b) {
        int size = BlockStorage.getInventory(b).toInventory().getSize();
        Inventory inv = Bukkit.createInventory(null, (int)size);
        for (int i = 0; i < size; ++i) {
            inv.setItem(i, (ItemStack)new CustomItem(Material.COMMAND_BLOCK, " &4ALL YOUR PLACEHOLDERS ARE BELONG TO US", new String[0]));
        }
        for (int slot : this.getOutputSlots()) {
            inv.setItem(slot, BlockStorage.getInventory(b).getItemInSlot(slot));
        }
        return inv;
    }

    protected boolean fits(Block b, ItemStack ... items) {
        return this.inject(b).addItem(items).isEmpty();
    }

    protected void pushItems(Block b, ItemStack ... items) {
        Inventory inv = this.inject(b);
        inv.addItem(items);
        for (int slot : this.getOutputSlots()) {
            BlockStorage.getInventory(b).replaceExistingItem(slot, inv.getItem(slot));
        }
    }

    public int[] getOutputSlots() {
        return new int[]{12, 13, 14};
    }

    protected void constructMenu(BlockMenuPreset preset) {
        for (int i : border) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.PURPLE_STAINED_GLASS_PANE), " "), (p, slot, item, action) -> false);
        }
    }

    public int getEnergyConsumption() {
        return 10;
    }

    @Override
    public void register(boolean slimefun) {
        this.addItemHandler(new BlockTicker(){

            @Override
            public void tick(Block b, SlimefunItem sf, Config data) {
                try {
                    XPCollector.this.tick(b);
                }
                catch (Exception x) {
                    Slimefun.getLogger().log(Level.SEVERE, "An Error occured while ticking an Exp Collector for Slimefun " + Slimefun.getVersion(), x);
                }
            }

            @Override
            public boolean isSynchronized() {
                return true;
            }
        });
        super.register(slimefun);
    }

    protected void tick(Block b) throws Exception {
        for (Entity n : XPCollectorHologram.getArmorStand(b, true).getNearbyEntities(4.0, 4.0, 4.0)) {
            if (!(n instanceof ExperienceOrb)) continue;
            if (ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
                return;
            }
            if (!n.isValid()) continue;
            int xp = this.getEXP(b) + ((ExperienceOrb)n).getExperience();
            ChargableBlock.addCharge(b, -this.getEnergyConsumption());
            n.remove();
            int withdrawn = 0;
            for (int level = 0; level < this.getEXP(b); level += 10) {
                if (!this.fits(b, new ItemStack[]{new CustomItem(Material.EXPERIENCE_BOTTLE, "&aFlask of Knowledge", new String[0])})) continue;
                withdrawn += 10;
                this.pushItems(b, new ItemStack[]{new CustomItem(Material.EXPERIENCE_BOTTLE, "&aFlask of Knowledge", new String[0])});
            }
            BlockStorage.addBlockInfo(b, "stored-exp", String.valueOf(xp - withdrawn));
            return;
        }
    }

    private int getEXP(Block b) {
        Config cfg = BlockStorage.getLocationInfo(b.getLocation());
        if (cfg.contains("stored-exp")) {
            return Integer.parseInt(cfg.getString("stored-exp"));
        }
        BlockStorage.addBlockInfo(b, "stored-exp", "0");
        return 0;
    }
}

