/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.hooks;

import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.hooks.ClearLagHook;
import me.mrCookieSlime.Slimefun.hooks.PlaceholderAPIHook;
import me.mrCookieSlime.Slimefun.hooks.WorldEditHook;
import net.coreprotect.CoreProtect;
import net.coreprotect.CoreProtectAPI;
import org.bukkit.plugin.Plugin;

public final class SlimefunHooks {
    private boolean exoticGarden = false;
    private boolean coreProtect = false;
    private boolean clearLag = false;
    private boolean worldEdit = false;
    private boolean placeHolderAPI = false;
    private CoreProtectAPI coreProtectAPI;

    public SlimefunHooks(SlimefunPlugin plugin) {
        if (plugin.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.placeHolderAPI = true;
            new PlaceholderAPIHook().register();
        }
        plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, () -> {
            if (plugin.getServer().getPluginManager().isPluginEnabled("ClearLag")) {
                this.clearLag = true;
                new ClearLagHook(plugin);
            }
            this.exoticGarden = plugin.getServer().getPluginManager().isPluginEnabled("ExoticGarden");
            if (plugin.getServer().getPluginManager().isPluginEnabled("CoreProtect")) {
                this.coreProtectAPI = ((CoreProtect)plugin.getServer().getPluginManager().getPlugin("CoreProtect")).getAPI();
            }
            if (plugin.getServer().getPluginManager().isPluginEnabled("WorldEdit")) {
                try {
                    Class.forName("com.sk89q.worldedit.extent.Extent");
                    this.worldEdit = true;
                    new WorldEditHook();
                    System.out.println("[Slimefun] Successfully hooked into WorldEdit!");
                }
                catch (Exception x) {
                    System.err.println("[Slimefun] Failed to hook into WorldEdit!");
                    System.err.println("[Slimefun] Maybe consider updating WorldEdit or Slimefun?");
                }
            }
        });
    }

    public boolean isExoticGardenInstalled() {
        return this.exoticGarden;
    }

    public boolean isCoreProtectInstalled() {
        return this.coreProtect;
    }

    public boolean isClearLagInstalled() {
        return this.clearLag;
    }

    public boolean isWorldEditInstalled() {
        return this.worldEdit;
    }

    public boolean isPlaceholderAPIInstalled() {
        return this.placeHolderAPI;
    }

    public CoreProtectAPI getCoreProtectAPI() {
        return this.coreProtectAPI;
    }
}

