/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines;

import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Level;
import me.mrCookieSlime.CSCoreLibPlugin.CSCoreLib;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.InvUtils;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunBlockHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.UnregisterReason;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class CropGrowthAccelerator
extends SlimefunItem {
    private static final int[] border = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
    public static final Map<Material, Integer> crops = new EnumMap<Material, Integer>(Material.class);

    public CropGrowthAccelerator(Category category, ItemStack item, String name, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, name, recipeType, recipe);
        new BlockMenuPreset(name, "&bGrowth Accelerator"){

            @Override
            public void init() {
                CropGrowthAccelerator.this.constructMenu(this);
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || CSCoreLib.getLib().getProtectionManager().canAccessChest(p.getUniqueId(), b, true);
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.INSERT) {
                    return CropGrowthAccelerator.this.getInputSlots();
                }
                return new int[0];
            }
        };
        CropGrowthAccelerator.registerBlockHandler(name, new SlimefunBlockHandler(){

            @Override
            public boolean onBreak(Player p, Block b, SlimefunItem item, UnregisterReason reason) {
                BlockMenu inv = BlockStorage.getInventory(b);
                if (inv != null) {
                    for (int slot : CropGrowthAccelerator.this.getInputSlots()) {
                        if (inv.getItemInSlot(slot) == null) continue;
                        b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                        inv.replaceExistingItem(slot, null);
                    }
                }
                return true;
            }
        });
    }

    protected void constructMenu(BlockMenuPreset preset) {
        for (int i : border) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.CYAN_STAINED_GLASS_PANE), " "), (p, slot, item, action) -> false);
        }
    }

    public abstract int getEnergyConsumption();

    public abstract int getRadius();

    public abstract int getSpeed();

    public int[] getInputSlots() {
        return new int[]{10, 11, 12, 13, 14, 15, 16};
    }

    @Override
    public void register(boolean slimefun) {
        this.addItemHandler(new BlockTicker(){

            @Override
            public void tick(Block b, SlimefunItem sf, Config data) {
                try {
                    CropGrowthAccelerator.this.tick(b);
                }
                catch (Exception x) {
                    Slimefun.getLogger().log(Level.SEVERE, "An Error occured while ticking a Crop Growth Accelerator for Slimefun " + Slimefun.getVersion(), x);
                }
            }

            @Override
            public boolean isSynchronized() {
                return true;
            }
        });
        super.register(slimefun);
    }

    protected void tick(Block b) throws Exception {
        if (this.work(b) > 0) {
            for (int slot : this.getInputSlots()) {
                if (!SlimefunManager.isItemSimiliar(BlockStorage.getInventory(b).getItemInSlot(slot), SlimefunItems.FERTILIZER, false)) continue;
                BlockStorage.getInventory(b).replaceExistingItem(slot, InvUtils.decreaseItem((ItemStack)BlockStorage.getInventory(b).getItemInSlot(slot), (int)1));
                break;
            }
        }
    }

    private int work(Block b) {
        int work = 0;
        for (int x = -this.getRadius(); x <= this.getRadius(); ++x) {
            for (int z = -this.getRadius(); z <= this.getRadius(); ++z) {
                Block block = b.getRelative(x, 0, z);
                if (!crops.containsKey(block.getType()) || ((Ageable)block.getBlockData()).getAge() >= crops.get(block.getType())) continue;
                for (int slot : this.getInputSlots()) {
                    if (!SlimefunManager.isItemSimiliar(BlockStorage.getInventory(b).getItemInSlot(slot), SlimefunItems.FERTILIZER, false)) continue;
                    if (work > this.getSpeed() - 1 || ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
                        return work;
                    }
                    ChargableBlock.addCharge(b, -this.getEnergyConsumption());
                    Ageable ageable = (Ageable)block.getBlockData();
                    ageable.setAge(ageable.getAge() + 1);
                    block.setBlockData((BlockData)ageable);
                    block.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, block.getLocation().add(0.5, 0.5, 0.5), 4, (double)0.1f, (double)0.1f, (double)0.1f);
                    return ++work;
                }
            }
        }
        return work;
    }

    static {
        crops.put(Material.WHEAT, 7);
        crops.put(Material.POTATOES, 7);
        crops.put(Material.CARROTS, 7);
        crops.put(Material.NETHER_WART, 3);
        crops.put(Material.BEETROOTS, 3);
        crops.put(Material.COCOA, 8);
        crops.put(Material.SWEET_BERRY_BUSH, 3);
    }
}

