/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import me.mrCookieSlime.CSCoreLibPlugin.CSCoreLib;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.InvUtils;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.CSCoreLibPlugin.general.World.CustomSkull;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunBlockHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.UnregisterReason;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineHelper;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines.ReactorAccessPort;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.energy.EnergyTicker;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.holograms.ReactorHologram;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public abstract class AReactor
extends SlimefunItem {
    public static Map<Location, MachineFuel> processing = new HashMap<Location, MachineFuel>();
    public static Map<Location, Integer> progress = new HashMap<Location, Integer>();
    private static final BlockFace[] cooling = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};
    private Set<MachineFuel> recipes = new HashSet<MachineFuel>();
    private static final int[] border = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 12, 13, 14, 21, 23};
    private static final int[] border_1 = new int[]{9, 10, 11, 18, 20, 27, 29, 36, 38, 45, 46, 47};
    private static final int[] border_2 = new int[]{15, 16, 17, 24, 26, 33, 35, 42, 44, 51, 52, 53};
    private static final int[] border_3 = new int[]{30, 31, 32, 39, 41, 48, 50};
    private static final int[] border_4 = new int[]{25, 34, 43};
    private static final int infoSlot = 49;

    public AReactor(Category category, ItemStack item, String id, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, id, recipeType, recipe);
        new BlockMenuPreset(id, this.getInventoryTitle()){

            @Override
            public void init() {
                AReactor.this.constructMenu(this);
            }

            @Override
            public void newInstance(BlockMenu menu, Block b) {
                try {
                    if (BlockStorage.getLocationInfo(b.getLocation(), "reactor-mode") == null) {
                        BlockStorage.addBlockInfo(b, "reactor-mode", "generator");
                    }
                    if (!BlockStorage.hasBlockInfo(b) || BlockStorage.getLocationInfo(b.getLocation(), "reactor-mode").equals("generator")) {
                        menu.replaceExistingItem(4, (ItemStack)new CustomItem(CustomSkull.getItem((String)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTM0M2NlNThkYTU0Yzc5OTI0YTJjOTMzMWNmYzQxN2ZlOGNjYmJlYTliZTQ1YTdhYzg1ODYwYTZjNzMwIn19fQ=="), "&7Focus: &eElectricity", new String[]{"", "&6Your Reactor will focus on Power Generation", "&6If your Energy Network doesn't need Power", "&6it will not produce any either", "", "&7> Click to change the Focus to &eProduction"}));
                        menu.addMenuClickHandler(4, (p, slot, item, action) -> {
                            BlockStorage.addBlockInfo(b, "reactor-mode", "production");
                            this.newInstance(menu, b);
                            return false;
                        });
                    } else {
                        menu.replaceExistingItem(4, (ItemStack)new CustomItem(SlimefunItems.PLUTONIUM, "&7Focus: &eProduction", new String[]{"", "&6Your Reactor will focus on producing goods", "&6If your Energy Network doesn't need Power", "&6it will continue to run and simply will", "&6not generate any Power in the mean time", "", "&7> Click to change the Focus to &ePower Generation"}));
                        menu.addMenuClickHandler(4, (p, slot, item, action) -> {
                            BlockStorage.addBlockInfo(b, "reactor-mode", "generator");
                            this.newInstance(menu, b);
                            return false;
                        });
                    }
                    BlockMenu ap = AReactor.this.getAccessPort(b.getLocation());
                    if (ap != null) {
                        menu.replaceExistingItem(49, (ItemStack)new CustomItem(new ItemStack(Material.GREEN_WOOL), "&7Access Port", new String[]{"", "&6Detected", "", "&7> Click to view Access Port"}));
                        menu.addMenuClickHandler(49, (p, slot, item, action) -> {
                            ap.open(new Player[]{p});
                            this.newInstance(menu, b);
                            return false;
                        });
                    } else {
                        menu.replaceExistingItem(49, (ItemStack)new CustomItem(new ItemStack(Material.RED_WOOL), "&7Access Port", new String[]{"", "&cNot detected", "", "&7Access Port must be", "&7placed 3 blocks above", "&7a reactor!"}));
                        menu.addMenuClickHandler(49, (p, slot, item, action) -> {
                            this.newInstance(menu, b);
                            menu.open(new Player[]{p});
                            return false;
                        });
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || CSCoreLib.getLib().getProtectionManager().canAccessChest(p.getUniqueId(), b, true);
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }
        };
        AReactor.registerBlockHandler(id, new SlimefunBlockHandler(){

            @Override
            public boolean onBreak(Player p, Block b, SlimefunItem item, UnregisterReason reason) {
                BlockMenu inv = BlockStorage.getInventory(b);
                if (inv != null) {
                    for (int slot : AReactor.this.getFuelSlots()) {
                        if (inv.getItemInSlot(slot) == null) continue;
                        b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                        inv.replaceExistingItem(slot, null);
                    }
                    for (int slot : AReactor.this.getCoolantSlots()) {
                        if (inv.getItemInSlot(slot) == null) continue;
                        b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                        inv.replaceExistingItem(slot, null);
                    }
                    for (int slot : AReactor.this.getOutputSlots()) {
                        if (inv.getItemInSlot(slot) == null) continue;
                        b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                        inv.replaceExistingItem(slot, null);
                    }
                }
                progress.remove(b.getLocation());
                processing.remove(b.getLocation());
                ReactorHologram.remove(b.getLocation());
                return true;
            }
        });
        this.registerDefaultRecipes();
    }

    private void constructMenu(BlockMenuPreset preset) {
        for (int i : border) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " "), (p, slot, item, action) -> false);
        }
        for (int i : border_1) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.LIME_STAINED_GLASS_PANE), " "), (p, slot, item, action) -> false);
        }
        for (int i : border_3) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.GREEN_STAINED_GLASS_PANE), " "), (p, slot, item, action) -> false);
        }
        preset.addItem(22, (ItemStack)new CustomItem(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " "), (p, slot, item, action) -> false);
        preset.addItem(1, (ItemStack)new CustomItem(SlimefunItems.URANIUM, "&7Fuel Slot", new String[]{"", "&rThis Slot accepts radioactive Fuel such as:", "&2Uranium &ror &aNeptunium"}), (p, slot, item, action) -> false);
        for (int i : border_2) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.CYAN_STAINED_GLASS_PANE), " "), (p, slot, item, action) -> false);
        }
        if (this.needsCooling()) {
            preset.addItem(7, (ItemStack)new CustomItem(this.getCoolant(), "&bCoolant Slot", new String[]{"", "&rThis Slot accepts Coolant Cells", "&4Without any Coolant Cells, your Reactor", "&4will explode"}));
        } else {
            preset.addItem(7, (ItemStack)new CustomItem(new ItemStack(Material.BARRIER), "&bCoolant Slot", new String[]{"", "&rThis Slot accepts Coolant Cells"}));
            for (int i : border_4) {
                preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.BARRIER), "&cNo Coolant Required"), (p, slot, item, action) -> false);
            }
        }
    }

    public abstract String getInventoryTitle();

    public abstract void registerDefaultRecipes();

    public abstract int getEnergyProduction();

    public abstract void extraTick(Location var1);

    public abstract ItemStack getCoolant();

    public boolean needsCooling() {
        return this.getCoolant() != null;
    }

    public int[] getInputSlots() {
        return new int[]{19, 28, 37, 25, 34, 43};
    }

    public int[] getFuelSlots() {
        return new int[]{19, 28, 37};
    }

    public int[] getCoolantSlots() {
        int[] nArray;
        if (this.needsCooling()) {
            int[] nArray2 = new int[3];
            nArray2[0] = 25;
            nArray2[1] = 34;
            nArray = nArray2;
            nArray2[2] = 43;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    public int[] getOutputSlots() {
        return new int[]{40};
    }

    public MachineFuel getProcessing(Location l) {
        return processing.get(l);
    }

    public boolean isProcessing(Location l) {
        return progress.containsKey(l);
    }

    public void registerFuel(MachineFuel fuel) {
        this.recipes.add(fuel);
    }

    @Override
    public void register(boolean slimefun) {
        this.addItemHandler(new EnergyTicker(){
            private Set<Location> explode = new HashSet<Location>();

            @Override
            public double generateEnergy(Location l, SlimefunItem sf, Config data) {
                BlockMenu port = AReactor.this.getAccessPort(l);
                if (AReactor.this.isProcessing(l)) {
                    AReactor.this.extraTick(l);
                    int timeleft = progress.get(l);
                    if (timeleft > 0) {
                        int produced = AReactor.this.getEnergyProduction();
                        int space = ChargableBlock.getMaxCharge(l) - ChargableBlock.getCharge(l);
                        if (space >= produced) {
                            ChargableBlock.addCharge(l, AReactor.this.getEnergyProduction());
                            space -= produced;
                        }
                        if (space >= produced || !BlockStorage.getLocationInfo(l, "reactor-mode").equals("generator")) {
                            progress.put(l, timeleft - 1);
                            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, () -> {
                                if (!l.getBlock().getRelative(cooling[new Random().nextInt(cooling.length)]).isLiquid()) {
                                    this.explode.add(l);
                                }
                            });
                            ItemStack item = AReactor.this.getProgressBar().clone();
                            ItemMeta im = item.getItemMeta();
                            im.setDisplayName(" ");
                            ArrayList<String> lore = new ArrayList<String>();
                            lore.add(MachineHelper.getProgress(timeleft, processing.get(l).getTicks()));
                            lore.add(MachineHelper.getCoolant(timeleft, processing.get(l).getTicks()));
                            lore.add("");
                            lore.add(MachineHelper.getTimeLeft(timeleft / 2));
                            im.setLore(lore);
                            item.setItemMeta(im);
                            BlockStorage.getInventory(l).replaceExistingItem(22, item);
                            if (AReactor.this.needsCooling()) {
                                boolean coolant;
                                boolean bl = coolant = (processing.get(l).getTicks() - timeleft) % 25 == 0;
                                if (coolant) {
                                    if (port != null) {
                                        for (int slot : AReactor.this.getCoolantSlots()) {
                                            if (!SlimefunManager.isItemSimiliar(port.getItemInSlot(slot), AReactor.this.getCoolant(), true)) continue;
                                            port.replaceExistingItem(slot, AReactor.this.pushItems(l, port.getItemInSlot(slot), AReactor.this.getCoolantSlots()));
                                        }
                                    }
                                    boolean explosion = true;
                                    for (int slot : AReactor.this.getCoolantSlots()) {
                                        if (!SlimefunManager.isItemSimiliar(BlockStorage.getInventory(l).getItemInSlot(slot), AReactor.this.getCoolant(), true)) continue;
                                        BlockStorage.getInventory(l).replaceExistingItem(slot, InvUtils.decreaseItem((ItemStack)BlockStorage.getInventory(l).getItemInSlot(slot), (int)1));
                                        ReactorHologram.update(l, "&b\u2744 &7100%");
                                        explosion = false;
                                        break;
                                    }
                                    if (explosion) {
                                        this.explode.add(l);
                                        return 0.0;
                                    }
                                } else {
                                    ReactorHologram.update(l, "&b\u2744 &7" + MachineHelper.getPercentage(timeleft, processing.get(l).getTicks()) + "%");
                                }
                            }
                            return ChargableBlock.getCharge(l);
                        }
                        return 0.0;
                    }
                    BlockStorage.getInventory(l).replaceExistingItem(22, (ItemStack)new CustomItem(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " "));
                    if (processing.get(l).getOutput() != null) {
                        AReactor.this.pushItems(l, processing.get(l).getOutput());
                    }
                    if (port != null) {
                        for (int slot : AReactor.this.getOutputSlots()) {
                            if (BlockStorage.getInventory(l).getItemInSlot(slot) == null) continue;
                            BlockStorage.getInventory(l).replaceExistingItem(slot, ReactorAccessPort.pushItems(port.getLocation(), BlockStorage.getInventory(l).getItemInSlot(slot)));
                        }
                    }
                    progress.remove(l);
                    processing.remove(l);
                    return 0.0;
                }
                BlockMenu menu = BlockStorage.getInventory(l);
                HashMap found = new HashMap();
                MachineFuel fuel = AReactor.this.findRecipe(menu, found);
                if (port != null) {
                    AReactor.this.restockCoolant(l, port);
                }
                if (fuel != null) {
                    for (Map.Entry entry : found.entrySet()) {
                        menu.replaceExistingItem((Integer)entry.getKey(), InvUtils.decreaseItem((ItemStack)menu.getItemInSlot((Integer)entry.getKey()), (int)((Integer)entry.getValue())));
                    }
                    processing.put(l, fuel);
                    progress.put(l, fuel.getTicks());
                }
                return 0.0;
            }

            @Override
            public boolean explode(Location l) {
                boolean explosion = this.explode.contains(l);
                if (explosion) {
                    BlockStorage.getInventory(l).close();
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, () -> ReactorHologram.remove(l), 0L);
                    this.explode.remove(l);
                    processing.remove(l);
                    progress.remove(l);
                }
                return explosion;
            }
        });
        super.register(slimefun);
    }

    private void restockCoolant(Location l, BlockMenu port) {
        for (int slot : this.getFuelSlots()) {
            for (MachineFuel recipe : this.recipes) {
                if (!SlimefunManager.isItemSimiliar(port.getItemInSlot(slot), recipe.getInput(), true) || this.pushItems(l, (ItemStack)new CustomItem(port.getItemInSlot(slot), 1), this.getFuelSlots()) != null) continue;
                port.replaceExistingItem(slot, InvUtils.decreaseItem((ItemStack)port.getItemInSlot(slot), (int)1));
                return;
            }
        }
    }

    private MachineFuel findRecipe(BlockMenu menu, Map<Integer, Integer> found) {
        for (MachineFuel recipe : this.recipes) {
            for (int slot : this.getInputSlots()) {
                if (!SlimefunManager.isItemSimiliar(menu.getItemInSlot(slot), recipe.getInput(), true)) continue;
                found.put(slot, recipe.getInput().getAmount());
                return recipe;
            }
        }
        return null;
    }

    private Inventory inject(Location l) {
        int size = BlockStorage.getInventory(l).toInventory().getSize();
        Inventory inv = Bukkit.createInventory(null, (int)size);
        for (int i = 0; i < size; ++i) {
            inv.setItem(i, (ItemStack)new CustomItem(Material.COMMAND_BLOCK, " &4ALL YOUR PLACEHOLDERS ARE BELONG TO US", new String[0]));
        }
        for (int slot : this.getOutputSlots()) {
            inv.setItem(slot, BlockStorage.getInventory(l).getItemInSlot(slot));
        }
        return inv;
    }

    private Inventory inject(Location l, int[] slots) {
        int size = BlockStorage.getInventory(l).toInventory().getSize();
        Inventory inv = Bukkit.createInventory(null, (int)size);
        for (int i = 0; i < size; ++i) {
            inv.setItem(i, (ItemStack)new CustomItem(Material.COMMAND_BLOCK, " &4ALL YOUR PLACEHOLDERS ARE BELONG TO US", new String[0]));
        }
        for (int slot : slots) {
            inv.setItem(slot, BlockStorage.getInventory(l).getItemInSlot(slot));
        }
        return inv;
    }

    public void pushItems(Location l, ItemStack item) {
        Inventory inv = this.inject(l);
        inv.addItem(new ItemStack[]{item});
        for (int slot : this.getOutputSlots()) {
            BlockStorage.getInventory(l).replaceExistingItem(slot, inv.getItem(slot));
        }
    }

    public ItemStack pushItems(Location l, ItemStack item, int[] slots) {
        Inventory inv = this.inject(l, slots);
        Optional optional = inv.addItem(new ItemStack[]{item}).values().stream().findFirst();
        for (int slot : slots) {
            BlockStorage.getInventory(l).replaceExistingItem(slot, inv.getItem(slot));
        }
        if (optional.isPresent()) {
            return (ItemStack)optional.get();
        }
        return null;
    }

    public abstract ItemStack getProgressBar();

    public Set<MachineFuel> getFuelTypes() {
        return this.recipes;
    }

    public BlockMenu getAccessPort(Location l) {
        Location portL = new Location(l.getWorld(), l.getX(), l.getY() + 3.0, l.getZ());
        if (BlockStorage.check(portL, "REACTOR_ACCESS_PORT")) {
            return BlockStorage.getInventory(portL);
        }
        return null;
    }
}

