/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Variable;
import me.mrCookieSlime.CSCoreLibPlugin.general.Particles.FireworkShow;
import me.mrCookieSlime.Slimefun.Events.ResearchUnlockEvent;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Setup.Messages;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import me.mrCookieSlime.Slimefun.api.PlayerProfile;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class Research {
    private static final int[] research_progress = new int[]{23, 44, 57, 92};
    public static List<Research> list = new LinkedList<Research>();
    private int id;
    private String name;
    private List<SlimefunItem> items;
    private int cost;
    private boolean enabled;

    public Research(int id, String name, int cost) {
        this.id = id;
        this.name = name;
        this.cost = cost;
        this.items = new ArrayList<SlimefunItem>();
        this.enabled = true;
    }

    public boolean isEnabled() {
        return SlimefunStartup.instance.getSettings().researchesEnabled && this.enabled;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public int getLevel() {
        return this.cost;
    }

    @Deprecated
    public void setLevel(int level) {
        this.cost = level;
    }

    public int getCost() {
        return this.cost;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public void addItems(SlimefunItem ... items) {
        for (SlimefunItem item : items) {
            if (item == null) continue;
            item.bindToResearch(this);
        }
    }

    public List<SlimefunItem> getAffectedItems() {
        return this.items;
    }

    @Deprecated
    public boolean hasUnlocked(Player p) {
        return this.hasUnlocked(p.getUniqueId());
    }

    @Deprecated
    public boolean hasUnlocked(UUID uuid) {
        return PlayerProfile.fromUUID(uuid).hasUnlocked(this);
    }

    public boolean canUnlock(Player p) {
        if (!this.isEnabled()) {
            return true;
        }
        return p.getGameMode() == GameMode.CREATIVE && SlimefunStartup.instance.getSettings().researchesFreeInCreative || p.getLevel() >= this.cost;
    }

    @Deprecated
    public void lock(Player p) {
        PlayerProfile.fromUUID(p.getUniqueId()).setResearched(this, false);
        Messages.local.sendTranslation((CommandSender)p, "commands.research.reset-target", true, new Variable[0]);
    }

    public void unlock(Player p, boolean instant) {
        if (!this.hasUnlocked(p)) {
            ResearchUnlockEvent event = new ResearchUnlockEvent(p, this);
            Bukkit.getPluginManager().callEvent((Event)event);
            Runnable runnable = () -> {
                PlayerProfile.fromUUID(p.getUniqueId()).setResearched(this, true);
                Messages.local.sendTranslation((CommandSender)p, "messages.unlocked", true, new Variable[]{new Variable("%research%", this.getName())});
                if (SlimefunStartup.getCfg().getBoolean("options.research-unlock-fireworks")) {
                    FireworkShow.launchRandom((Player)p, (int)1);
                }
            };
            if (!event.isCancelled()) {
                if (instant) {
                    runnable.run();
                } else if (!SlimefunStartup.instance.getUtilities().researching.contains(p.getUniqueId())) {
                    SlimefunStartup.instance.getUtilities().researching.add(p.getUniqueId());
                    Messages.local.sendTranslation((CommandSender)p, "messages.research.start", true, new Variable[]{new Variable("%research%", this.getName())});
                    for (int i = 1; i < research_progress.length + 1; ++i) {
                        int j = i;
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, () -> {
                            p.playSound(p.getLocation(), Sound.ENTITY_BAT_TAKEOFF, 0.7f, 1.0f);
                            Messages.local.sendTranslation((CommandSender)p, "messages.research.progress", true, new Variable[]{new Variable("%research%", this.getName()), new Variable("%progress%", research_progress[j - 1] + "%")});
                        }, (long)i * 20L);
                    }
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, () -> {
                        runnable.run();
                        SlimefunStartup.instance.getUtilities().researching.remove(p.getUniqueId());
                    }, (long)(research_progress.length + 1) * 20L);
                }
            }
        }
    }

    public void register() {
        SlimefunStartup.getResearchCfg().setDefaultValue("enable-researching", (Object)true);
        if (SlimefunStartup.getResearchCfg().contains(this.getID() + ".enabled") && !SlimefunStartup.getResearchCfg().getBoolean(this.getID() + ".enabled")) {
            Iterator<SlimefunItem> iterator = this.items.iterator();
            while (iterator.hasNext()) {
                SlimefunItem item = iterator.next();
                if (item != null) {
                    item.bindToResearch(null);
                }
                iterator.remove();
            }
            return;
        }
        SlimefunStartup.getResearchCfg().setDefaultValue(this.getID() + ".name", (Object)this.getName());
        SlimefunStartup.getResearchCfg().setDefaultValue(this.getID() + ".cost", (Object)this.getCost());
        SlimefunStartup.getResearchCfg().setDefaultValue(this.getID() + ".enabled", (Object)true);
        this.name = SlimefunStartup.getResearchCfg().getString(this.getID() + ".name");
        this.cost = SlimefunStartup.getResearchCfg().getInt(this.getID() + ".cost");
        this.enabled = SlimefunStartup.getResearchCfg().getBoolean(this.getID() + ".enabled");
        list.add(this);
        if (SlimefunStartup.getCfg().getBoolean("options.print-out-loading")) {
            System.out.println("[Slimefun] Loaded Research \"" + this.getName() + "\"");
        }
    }

    public static List<Research> list() {
        return list;
    }

    public static boolean isResearching(Player p) {
        return SlimefunStartup.instance.getUtilities().researching.contains(p.getUniqueId());
    }

    @Deprecated
    public static void sendStats(CommandSender sender, Player p) {
        PlayerProfile profile = PlayerProfile.fromUUID(p.getUniqueId());
        Set<Research> researched = profile.getResearches();
        int levels = researched.stream().mapToInt(Research::getCost).sum();
        String progress = String.valueOf((float)Math.round((float)researched.size() * 100.0f / (float)Research.list().size() * 100.0f) / 100.0f);
        progress = Float.parseFloat(progress) < 16.0f ? "&4" + progress + " &r% " : (Float.parseFloat(progress) < 32.0f ? "&c" + progress + " &r% " : (Float.parseFloat(progress) < 48.0f ? "&6" + progress + " &r% " : (Float.parseFloat(progress) < 64.0f ? "&e" + progress + " &r% " : (Float.parseFloat(progress) < 80.0f ? "&2" + progress + " &r% " : "&a" + progress + " &r% "))));
        sender.sendMessage("");
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7Statistics for Player: &b" + p.getName())));
        sender.sendMessage("");
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7Title: &b" + Research.getTitle(p, researched))));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7Research Progress: " + progress + "&e(" + researched.size() + " / " + Research.list().size() + ")")));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7Total XP Levels spent: &b" + levels)));
    }

    @Deprecated
    public static String getTitle(Player p, Collection<Research> researched) {
        return PlayerProfile.fromUUID(p.getUniqueId()).getTitle();
    }

    public static Research getByID(int id) {
        for (Research research : list) {
            if (research.getID() != id) continue;
            return research;
        }
        return null;
    }

    @Deprecated
    public static List<Research> getResearches(UUID uuid) {
        ArrayList<Research> researched = new ArrayList<Research>();
        for (Research r : Research.list()) {
            if (!r.hasUnlocked(uuid)) continue;
            researched.add(r);
        }
        return researched;
    }

    @Deprecated
    public static List<Research> getResearches(String uuid) {
        return Research.getResearches(UUID.fromString(uuid));
    }
}

