/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Setup;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import me.mrCookieSlime.Slimefun.Lists.Categories;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunArmorPiece;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.VanillaItem;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;

public final class SlimefunManager {
    public static SlimefunStartup plugin;
    public static String prefix;
    public static Map<EntityType, List<ItemStack>> drops;

    private SlimefunManager() {
    }

    public static void registerArmorSet(ItemStack baseComponent, ItemStack[] items, String idSyntax, PotionEffect[][] effects, boolean special, boolean slimefun) {
        String[] components = new String[]{"_HELMET", "_CHESTPLATE", "_LEGGINGS", "_BOOTS"};
        Category cat = special ? Categories.MAGIC_ARMOR : Categories.ARMOR;
        ArrayList<ItemStack[]> recipes = new ArrayList<ItemStack[]>();
        recipes.add(new ItemStack[]{baseComponent, baseComponent, baseComponent, baseComponent, null, baseComponent, null, null, null});
        recipes.add(new ItemStack[]{baseComponent, null, baseComponent, baseComponent, baseComponent, baseComponent, baseComponent, baseComponent, baseComponent});
        recipes.add(new ItemStack[]{baseComponent, baseComponent, baseComponent, baseComponent, null, baseComponent, baseComponent, null, baseComponent});
        recipes.add(new ItemStack[]{null, null, null, baseComponent, null, baseComponent, baseComponent, null, baseComponent});
        for (int i = 0; i < 4; ++i) {
            if (i < effects.length && effects[i].length > 0) {
                new SlimefunArmorPiece(cat, items[i], idSyntax + components[i], RecipeType.ARMOR_FORGE, (ItemStack[])recipes.get(i), effects[i]).register(slimefun);
                continue;
            }
            new SlimefunItem(cat, items[i], idSyntax + components[i], RecipeType.ARMOR_FORGE, (ItemStack[])recipes.get(i)).register(slimefun);
        }
    }

    public static void registerArmorSet(ItemStack baseComponent, ItemStack[] items, String idSyntax, boolean slimefun, boolean vanilla) {
        String[] components = new String[]{"_HELMET", "_CHESTPLATE", "_LEGGINGS", "_BOOTS"};
        Category cat = Categories.ARMOR;
        ArrayList<ItemStack[]> recipes = new ArrayList<ItemStack[]>();
        recipes.add(new ItemStack[]{baseComponent, baseComponent, baseComponent, baseComponent, null, baseComponent, null, null, null});
        recipes.add(new ItemStack[]{baseComponent, null, baseComponent, baseComponent, baseComponent, baseComponent, baseComponent, baseComponent, baseComponent});
        recipes.add(new ItemStack[]{baseComponent, baseComponent, baseComponent, baseComponent, null, baseComponent, baseComponent, null, baseComponent});
        recipes.add(new ItemStack[]{null, null, null, baseComponent, null, baseComponent, baseComponent, null, baseComponent});
        for (int i = 0; i < 4; ++i) {
            if (vanilla) {
                new VanillaItem(cat, items[i], idSyntax + components[i], RecipeType.ARMOR_FORGE, (ItemStack[])recipes.get(i)).register(slimefun);
                continue;
            }
            new SlimefunItem(cat, items[i], idSyntax + components[i], RecipeType.ARMOR_FORGE, (ItemStack[])recipes.get(i)).register(slimefun);
        }
    }

    public static boolean isItemSimiliar(ItemStack item, ItemStack sfitem, boolean lore) {
        if (item == null) {
            return sfitem == null;
        }
        if (sfitem == null) {
            return false;
        }
        if (item.getType() == sfitem.getType() && item.getAmount() >= sfitem.getAmount()) {
            if (item.hasItemMeta() && sfitem.hasItemMeta()) {
                if (item.getItemMeta().hasDisplayName() && sfitem.getItemMeta().hasDisplayName()) {
                    if (item.getItemMeta().getDisplayName().equals(sfitem.getItemMeta().getDisplayName())) {
                        if (lore) {
                            if (item.getItemMeta().hasLore() && sfitem.getItemMeta().hasLore()) {
                                return SlimefunManager.equalsLore(item.getItemMeta().getLore(), sfitem.getItemMeta().getLore());
                            }
                            return !item.getItemMeta().hasLore() && !sfitem.getItemMeta().hasLore();
                        }
                        return true;
                    }
                    return false;
                }
                if (!item.getItemMeta().hasDisplayName() && !sfitem.getItemMeta().hasDisplayName()) {
                    if (lore) {
                        if (item.getItemMeta().hasLore() && sfitem.getItemMeta().hasLore()) {
                            return SlimefunManager.equalsLore(item.getItemMeta().getLore(), sfitem.getItemMeta().getLore());
                        }
                        return !item.getItemMeta().hasLore() && !sfitem.getItemMeta().hasLore();
                    }
                    return true;
                }
                return false;
            }
            return !item.hasItemMeta() && !sfitem.hasItemMeta();
        }
        return false;
    }

    @Deprecated
    public static boolean isItemSimiliar(ItemStack item, ItemStack sfitem, boolean lore, DataType data) {
        return SlimefunManager.isItemSimiliar(item, sfitem, lore);
    }

    private static boolean equalsLore(List<String> lore, List<String> lore2) {
        String string1 = "";
        String string2 = "";
        for (String string : lore) {
            if (string.startsWith("&e&e&7")) continue;
            string1 = string1 + "-NEW LINE-" + string;
        }
        for (String string : lore2) {
            if (string.startsWith("&e&e&7")) continue;
            string2 = string2 + "-NEW LINE-" + string;
        }
        return string1.equals(string2);
    }

    static {
        drops = new EnumMap<EntityType, List<ItemStack>>(EntityType.class);
    }

    @Deprecated
    public static enum DataType {
        ALWAYS,
        NEVER,
        IF_COLORED;

    }
}

