/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.energy;

import java.util.HashSet;
import java.util.Set;
import me.mrCookieSlime.CSCoreLibPlugin.general.Math.DoubleHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.network.Network;
import me.mrCookieSlime.Slimefun.holograms.EnergyHologram;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;

public class EnergyNet
extends Network {
    private static final int RANGE = 6;
    public static Set<String> machinesInput = new HashSet<String>();
    public static Set<String> machinesStorage = new HashSet<String>();
    public static Set<String> machinesOutput = new HashSet<String>();
    private Set<Location> input = new HashSet<Location>();
    private Set<Location> storage = new HashSet<Location>();
    private Set<Location> output = new HashSet<Location>();

    public static NetworkComponent getComponent(Block b) {
        return EnergyNet.getComponent(b.getLocation());
    }

    public static NetworkComponent getComponent(String id) {
        if (machinesInput.contains(id)) {
            return NetworkComponent.SOURCE;
        }
        if (machinesStorage.contains(id)) {
            return NetworkComponent.DISTRIBUTOR;
        }
        if (machinesOutput.contains(id)) {
            return NetworkComponent.CONSUMER;
        }
        return NetworkComponent.NONE;
    }

    public static NetworkComponent getComponent(Location l) {
        if (!BlockStorage.hasBlockInfo(l)) {
            return NetworkComponent.NONE;
        }
        String id = BlockStorage.checkID(l);
        if (machinesInput.contains(id)) {
            return NetworkComponent.SOURCE;
        }
        if (machinesStorage.contains(id)) {
            return NetworkComponent.DISTRIBUTOR;
        }
        if (machinesOutput.contains(id)) {
            return NetworkComponent.CONSUMER;
        }
        return NetworkComponent.NONE;
    }

    public static void registerComponent(String id, NetworkComponent component) {
        switch (component) {
            case CONSUMER: {
                machinesOutput.add(id);
                break;
            }
            case DISTRIBUTOR: {
                machinesStorage.add(id);
                break;
            }
            case SOURCE: {
                machinesInput.add(id);
                break;
            }
        }
    }

    public static EnergyNet getNetworkFromLocation(Location l) {
        return EnergyNet.getNetworkFromLocation(l, EnergyNet.class);
    }

    public static EnergyNet getNetworkFromLocationOrCreate(Location l) {
        EnergyNet energyNetwork = EnergyNet.getNetworkFromLocation(l);
        if (energyNetwork == null) {
            energyNetwork = new EnergyNet(l);
            EnergyNet.registerNetwork(energyNetwork);
        }
        return energyNetwork;
    }

    protected EnergyNet(Location l) {
        super(l);
    }

    @Override
    public int getRange() {
        return 6;
    }

    @Override
    public Network.Component classifyLocation(Location l) {
        if (this.regulator.equals((Object)l)) {
            return Network.Component.REGULATOR;
        }
        switch (EnergyNet.getComponent(l)) {
            case DISTRIBUTOR: {
                return Network.Component.CONNECTOR;
            }
            case CONSUMER: 
            case SOURCE: {
                return Network.Component.TERMINUS;
            }
        }
        return null;
    }

    @Override
    public void locationClassificationChange(Location l, Network.Component from, Network.Component to) {
        if (from == Network.Component.TERMINUS) {
            this.input.remove(l);
            this.output.remove(l);
        }
        switch (EnergyNet.getComponent(l)) {
            case DISTRIBUTOR: {
                if (!ChargableBlock.isCapacitor(l)) break;
                this.storage.add(l);
                break;
            }
            case CONSUMER: {
                this.output.add(l);
                break;
            }
            case SOURCE: {
                this.input.add(l);
                break;
            }
        }
    }

    public void tick(Block b) {
        if (!this.regulator.equals((Object)b.getLocation())) {
            EnergyHologram.update(b, "&4Multiple Energy Regulators connected");
            return;
        }
        super.tick();
        double supply = 0.0;
        double demand = 0.0;
        if (this.connectorNodes.isEmpty() && this.terminusNodes.isEmpty()) {
            EnergyHologram.update(b, "&4No Energy Network found");
        } else {
            int capacity;
            HashSet<Location> exploded = new HashSet<Location>();
            for (Location source : this.input) {
                long timestamp = System.currentTimeMillis();
                SlimefunItem item = BlockStorage.check(source);
                double energy = item.getEnergyTicker().generateEnergy(source, item, BlockStorage.getLocationInfo(source));
                if (item.getEnergyTicker().explode(source)) {
                    exploded.add(source);
                    BlockStorage.clearBlockInfo(source);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, () -> {
                        source.getBlock().setType(Material.LAVA);
                        source.getWorld().createExplosion(source, 0.0f, false);
                    });
                } else {
                    supply += energy;
                }
                SlimefunStartup.ticker.blockTimings.put(source, System.currentTimeMillis() - timestamp);
            }
            this.input.removeAll(exploded);
            for (Location battery : this.storage) {
                supply += (double)ChargableBlock.getCharge(battery);
            }
            int available = (int)DoubleHandler.fixDouble((double)supply);
            for (Location destination : this.output) {
                capacity = ChargableBlock.getMaxCharge(destination);
                int charge = ChargableBlock.getCharge(destination);
                if (charge >= capacity) continue;
                int rest = capacity - charge;
                demand += (double)rest;
                if (available <= 0) continue;
                if (available > rest) {
                    ChargableBlock.setUnsafeCharge(destination, capacity, false);
                    available -= rest;
                    continue;
                }
                ChargableBlock.setUnsafeCharge(destination, charge + available, false);
                available = 0;
            }
            for (Location battery : this.storage) {
                if (available > 0) {
                    capacity = ChargableBlock.getMaxCharge(battery);
                    if (available > capacity) {
                        ChargableBlock.setUnsafeCharge(battery, capacity, true);
                        available -= capacity;
                        continue;
                    }
                    ChargableBlock.setUnsafeCharge(battery, available, true);
                    available = 0;
                    continue;
                }
                ChargableBlock.setUnsafeCharge(battery, 0, true);
            }
            for (Location source : this.input) {
                if (!ChargableBlock.isChargable(source)) continue;
                if (available > 0) {
                    capacity = ChargableBlock.getMaxCharge(source);
                    if (available > capacity) {
                        ChargableBlock.setUnsafeCharge(source, capacity, false);
                        available -= capacity;
                        continue;
                    }
                    ChargableBlock.setUnsafeCharge(source, available, false);
                    available = 0;
                    continue;
                }
                ChargableBlock.setUnsafeCharge(source, 0, false);
            }
            EnergyHologram.update(b, supply, demand);
        }
    }

    public static enum NetworkComponent {
        SOURCE,
        DISTRIBUTOR,
        CONSUMER,
        NONE;

    }
}

