/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines;

import java.util.ArrayList;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.InvUtils;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineHelper;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class AutoAnvil
extends AContainer {
    public AutoAnvil(Category category, ItemStack item, String name, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, name, recipeType, recipe);
    }

    @Override
    public String getInventoryTitle() {
        return "Auto-Anvil";
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.IRON_PICKAXE);
    }

    @Override
    public void registerDefaultRecipes() {
    }

    @Override
    public int getSpeed() {
        return 1;
    }

    @Override
    public String getMachineIdentifier() {
        return "AUTO_ANVIL";
    }

    public abstract int getRepairFactor();

    @Override
    protected void tick(Block b) {
        if (this.isProcessing(b)) {
            int timeleft = (Integer)progress.get(b);
            if (timeleft > 0) {
                ItemStack item = this.getProgressBar().clone();
                ItemMeta im = item.getItemMeta();
                ((Damageable)im).setDamage((int)MachineHelper.getDurability(item, timeleft, ((MachineRecipe)processing.get(b)).getTicks()));
                im.setDisplayName(" ");
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(MachineHelper.getProgress(timeleft, ((MachineRecipe)processing.get(b)).getTicks()));
                lore.add("");
                lore.add(MachineHelper.getTimeLeft(timeleft / 2));
                im.setLore(lore);
                item.setItemMeta(im);
                BlockStorage.getInventory(b).replaceExistingItem(22, item);
                if (ChargableBlock.isChargable(b)) {
                    if (ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
                        return;
                    }
                    ChargableBlock.addCharge(b, -this.getEnergyConsumption());
                    progress.put(b, timeleft - 1);
                } else {
                    progress.put(b, timeleft - 1);
                }
            } else {
                BlockStorage.getInventory(b).replaceExistingItem(22, (ItemStack)new CustomItem(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " "));
                this.pushItems(b, ((MachineRecipe)processing.get(b)).getOutput());
                progress.remove(b);
                processing.remove(b);
            }
        } else {
            BlockMenu menu = BlockStorage.getInventory(b);
            MachineRecipe recipe = null;
            for (int slot : this.getInputSlots()) {
                ItemStack target = menu.getItemInSlot(slot == this.getInputSlots()[0] ? this.getInputSlots()[1] : this.getInputSlots()[0]);
                ItemStack item = menu.getItemInSlot(slot);
                if (item == null || item.getType().getMaxDurability() <= 0 || ((Damageable)item.getItemMeta()).getDamage() <= 0) continue;
                if (!SlimefunManager.isItemSimiliar(target, SlimefunItems.DUCT_TAPE, true)) break;
                ItemStack newItem = item.clone();
                short durability = (short)(((Damageable)newItem.getItemMeta()).getDamage() - item.getType().getMaxDurability() / this.getRepairFactor());
                if (durability < 0) {
                    durability = 0;
                }
                ItemMeta meta = newItem.getItemMeta();
                ((Damageable)meta).setDamage((int)durability);
                newItem.setItemMeta(meta);
                recipe = new MachineRecipe(30, new ItemStack[]{target, item}, new ItemStack[]{newItem});
                break;
            }
            if (recipe != null) {
                if (!this.fits(b, recipe.getOutput())) {
                    return;
                }
                for (int slot : this.getInputSlots()) {
                    menu.replaceExistingItem(slot, InvUtils.decreaseItem((ItemStack)menu.getItemInSlot(slot), (int)1));
                }
                processing.put(b, recipe);
                progress.put(b, recipe.getTicks());
            }
        }
    }
}

