/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Setup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import me.mrCookieSlime.CSCoreLibPlugin.general.Chat.Colors;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItemSerializer;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Misc.PostSlimefunLoadingHandler;
import me.mrCookieSlime.Slimefun.Objects.Research;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.Alloy;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.ReplacingAlloy;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunMachine;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines.AutomatedCraftingChamber;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.Setup.WikiSetup;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunRecipes;
import me.mrCookieSlime.Slimefun.utils.Settings;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public final class MiscSetup {
    public static List<PostSlimefunLoadingHandler> post_handlers = new ArrayList<PostSlimefunLoadingHandler>();

    private MiscSetup() {
    }

    public static void setupMisc() {
        if (SlimefunItem.getByID("COMMON_TALISMAN") != null && ((Boolean)Slimefun.getItemValue("COMMON_TALISMAN", "recipe-requires-nether-stars")).booleanValue()) {
            SlimefunItem.getByID("COMMON_TALISMAN").setRecipe(new ItemStack[]{SlimefunItems.MAGIC_LUMP_2, SlimefunItems.GOLD_8K, SlimefunItems.MAGIC_LUMP_2, null, new ItemStack(Material.NETHER_STAR), null, SlimefunItems.MAGIC_LUMP_2, SlimefunItems.GOLD_8K, SlimefunItems.MAGIC_LUMP_2});
        }
        SlimefunItem.setRadioactive(SlimefunItems.URANIUM);
        SlimefunItem.setRadioactive(SlimefunItems.SMALL_URANIUM);
        SlimefunItem.setRadioactive(SlimefunItems.BLISTERING_INGOT);
        SlimefunItem.setRadioactive(SlimefunItems.BLISTERING_INGOT_2);
        SlimefunItem.setRadioactive(SlimefunItems.BLISTERING_INGOT_3);
        SlimefunItem.setRadioactive(SlimefunItems.NETHER_ICE);
        SlimefunItem.setRadioactive(SlimefunItems.ENRICHED_NETHER_ICE);
    }

    public static void loadItems(Settings settings) {
        SlimefunItem crusher;
        Iterator<SlimefunItem> iterator = SlimefunItem.items.iterator();
        while (iterator.hasNext()) {
            SlimefunItem item = iterator.next();
            if (item == null) {
                System.err.println("[Slimefun] Removed bugged Item ('NULL?')");
                iterator.remove();
                continue;
            }
            if (item.getItem() != null) continue;
            System.err.println("[Slimefun] Removed bugged Item ('" + item.getID() + "')");
            iterator.remove();
        }
        ArrayList<SlimefunItem> pre = new ArrayList<SlimefunItem>();
        ArrayList<SlimefunItem> init = new ArrayList<SlimefunItem>();
        ArrayList<SlimefunItem> post = new ArrayList<SlimefunItem>();
        for (SlimefunItem item : SlimefunItem.list()) {
            if (item instanceof Alloy || item instanceof ReplacingAlloy) {
                pre.add(item);
                continue;
            }
            if (item instanceof SlimefunMachine) {
                init.add(item);
                continue;
            }
            post.add(item);
        }
        for (SlimefunItem item : pre) {
            item.load();
        }
        for (SlimefunItem item : init) {
            item.load();
        }
        for (SlimefunItem item : post) {
            item.load();
        }
        AutomatedCraftingChamber crafter = (AutomatedCraftingChamber)SlimefunItem.getByID("AUTOMATED_CRAFTING_CHAMBER");
        if (crafter != null) {
            SlimefunMachine machine = (SlimefunMachine)SlimefunItem.getByID("ENHANCED_CRAFTING_TABLE");
            for (ItemStack[] inputs : RecipeType.getRecipeInputList(machine)) {
                StringBuilder builder = new StringBuilder();
                int i = 0;
                for (ItemStack item : inputs) {
                    if (i > 0) {
                        builder.append(" </slot> ");
                    }
                    builder.append(CustomItemSerializer.serialize((ItemStack)item, (CustomItemSerializer.ItemFlag[])new CustomItemSerializer.ItemFlag[]{CustomItemSerializer.ItemFlag.MATERIAL, CustomItemSerializer.ItemFlag.ITEMMETA_DISPLAY_NAME, CustomItemSerializer.ItemFlag.ITEMMETA_LORE}));
                    ++i;
                }
                AutomatedCraftingChamber.recipes.put(builder.toString(), RecipeType.getRecipeOutputList(machine, inputs));
            }
        }
        ArrayList<ItemStack[]> grinder_recipes = new ArrayList<ItemStack[]>();
        SlimefunItem grinder = SlimefunItem.getByID("GRIND_STONE");
        if (grinder != null) {
            ItemStack[] input = null;
            for (ItemStack[] recipe2 : ((SlimefunMachine)grinder).getRecipes()) {
                if (input == null) {
                    input = recipe2;
                    continue;
                }
                if (input[0] != null && recipe2[0] != null) {
                    grinder_recipes.add(new ItemStack[]{input[0], recipe2[0]});
                }
                input = null;
            }
        }
        if ((crusher = SlimefunItem.getByID("ORE_CRUSHER")) != null) {
            ItemStack[] input = null;
            for (ItemStack[] recipe3 : ((SlimefunMachine)crusher).getRecipes()) {
                if (input == null) {
                    input = recipe3;
                    continue;
                }
                if (input[0] != null && recipe3[0] != null) {
                    grinder_recipes.add(new ItemStack[]{input[0], recipe3[0]});
                }
                input = null;
            }
        }
        Stream stream = grinder_recipes.stream();
        if (!settings.ORE_GRINDER_LEGACY) {
            stream = stream.sorted((a, b) -> Integer.compare(b[0].getAmount(), a[0].getAmount()));
        }
        stream.forEach(recipe -> SlimefunRecipes.registerMachineRecipe("ELECTRIC_ORE_GRINDER", 4, new ItemStack[]{recipe[0]}, new ItemStack[]{recipe[1]}));
        SlimefunItem smeltery = SlimefunItem.getByID("SMELTERY");
        if (smeltery != null) {
            ItemStack[] input = null;
            for (ItemStack[] recipe4 : ((SlimefunMachine)smeltery).getRecipes()) {
                if (input == null) {
                    input = recipe4;
                    continue;
                }
                if (input[0] != null && recipe4[0] != null) {
                    ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
                    boolean dust = false;
                    for (ItemStack i : input) {
                        if (i == null) continue;
                        inputs.add(i);
                        if (SlimefunManager.isItemSimiliar(i, SlimefunItems.ALUMINUM_DUST, true)) {
                            dust = true;
                        }
                        if (SlimefunManager.isItemSimiliar(i, SlimefunItems.COPPER_DUST, true)) {
                            dust = true;
                        }
                        if (SlimefunManager.isItemSimiliar(i, SlimefunItems.GOLD_DUST, true)) {
                            dust = true;
                        }
                        if (SlimefunManager.isItemSimiliar(i, SlimefunItems.IRON_DUST, true)) {
                            dust = true;
                        }
                        if (SlimefunManager.isItemSimiliar(i, SlimefunItems.LEAD_DUST, true)) {
                            dust = true;
                        }
                        if (SlimefunManager.isItemSimiliar(i, SlimefunItems.MAGNESIUM_DUST, true)) {
                            dust = true;
                        }
                        if (SlimefunManager.isItemSimiliar(i, SlimefunItems.SILVER_DUST, true)) {
                            dust = true;
                        }
                        if (SlimefunManager.isItemSimiliar(i, SlimefunItems.TIN_DUST, true)) {
                            dust = true;
                        }
                        if (!SlimefunManager.isItemSimiliar(i, SlimefunItems.ZINC_DUST, true)) continue;
                        dust = true;
                    }
                    if (!dust || inputs.size() != 1) {
                        SlimefunRecipes.registerMachineRecipe("ELECTRIC_SMELTERY", 12, inputs.toArray(new ItemStack[inputs.size()]), new ItemStack[]{recipe4[0]});
                    }
                }
                input = null;
            }
        }
        ConsoleCommandSender sender = Bukkit.getConsoleSender();
        ChatColor color = Colors.getRandom();
        for (PostSlimefunLoadingHandler handler : post_handlers) {
            handler.run(pre, init, post);
        }
        sender.sendMessage(color + "###################### - Slimefun - ######################");
        sender.sendMessage(color + "Successfully loaded " + SlimefunItem.list().size() + " Items (" + Research.list().size() + " Researches)");
        sender.sendMessage(color + "( " + SlimefunStartup.instance.getUtilities().vanillaItems + " Items from Slimefun, " + (SlimefunItem.list().size() - SlimefunStartup.instance.getUtilities().vanillaItems) + " Items from Addons )");
        sender.sendMessage(color + "##########################################################");
        SlimefunStartup.getItemCfg().save();
        SlimefunStartup.getResearchCfg().save();
        SlimefunStartup.getWhitelist().save();
    }

    public static void setupItemSettings() {
        for (World world : Bukkit.getWorlds()) {
            SlimefunStartup.getWhitelist().setDefaultValue(world.getName() + ".enabled-items.SLIMEFUN_GUIDE", (Object)true);
        }
        Slimefun.setItemVariable("ORE_CRUSHER", "double-ores", true);
        for (Enchantment e : Enchantment.values()) {
            for (int i = 1; i <= e.getMaxLevel(); ++i) {
                Slimefun.setItemVariable("MAGICIAN_TALISMAN", "allow-enchantments." + e.getKey().getKey() + ".level." + i, true);
            }
        }
    }

    public static void loadDescriptions() {
        Slimefun.addYoutubeVideo("ANCIENT_ALTAR", "https://youtu.be/mx2Y5DP8uZI");
        Slimefun.addYoutubeVideo("ANCIENT_PEDESTAL", "https://youtu.be/mx2Y5DP8uZI");
        Slimefun.addYoutubeVideo("BLISTERING_INGOT", "https://youtu.be/mPhKUv4JR_Y");
        Slimefun.addYoutubeVideo("BLISTERING_INGOT_2", "https://youtu.be/mPhKUv4JR_Y");
        Slimefun.addYoutubeVideo("BLISTERING_INGOT_3", "https://youtu.be/mPhKUv4JR_Y");
        Slimefun.addYoutubeVideo("INFERNAL_BONEMEAL", "https://youtu.be/gKxWqMlJDXY");
        Slimefun.addYoutubeVideo("RAINBOW_WOOL", "https://youtu.be/csvb0CxofdA");
        Slimefun.addYoutubeVideo("RAINBOW_GLASS", "https://youtu.be/csvb0CxofdA");
        Slimefun.addYoutubeVideo("RAINBOW_CLAY", "https://youtu.be/csvb0CxofdA");
        Slimefun.addYoutubeVideo("RAINBOW_GLASS_PANE", "https://youtu.be/csvb0CxofdA");
        Slimefun.addYoutubeVideo("RAINBOW_WOOL_XMAS", "https://youtu.be/l4pKk4SDE");
        Slimefun.addYoutubeVideo("RAINBOW_GLASS_XMAS", "https://youtu.be/l4pKk4SDE");
        Slimefun.addYoutubeVideo("RAINBOW_CLAY_XMAS", "https://youtu.be/l4pKk4SDE");
        Slimefun.addYoutubeVideo("RAINBOW_GLASS_PANE_XMAS", "https://youtu.be/l4pKk4SDE");
        Slimefun.addYoutubeVideo("OIL_PUMP", "https://youtu.be/_XmJ6hrv9uY");
        Slimefun.addYoutubeVideo("GPS_GEO_SCANNER", "https://youtu.be/_XmJ6hrv9uY");
        Slimefun.addYoutubeVideo("REFINERY", "https://youtu.be/_XmJ6hrv9uY");
        Slimefun.addYoutubeVideo("BUCKET_OF_OIL", "https://youtu.be/_XmJ6hrv9uY");
        Slimefun.addYoutubeVideo("BUCKET_OF_FUEL", "https://youtu.be/_XmJ6hrv9uY");
        Slimefun.addYoutubeVideo("GPS_TELEPORTER_PYLON", "https://youtu.be/ZnEhG8Kw6zU");
        Slimefun.addYoutubeVideo("GPS_TELEPORTATION_MATRIX", "https://youtu.be/ZnEhG8Kw6zU");
        Slimefun.addYoutubeVideo("GPS_TELEPORTER_PYLON", "https://youtu.be/ZnEhG8Kw6zU");
        Slimefun.addYoutubeVideo("PROGRAMMABLE_ANDROID_WOODCUTTER", "https://youtu.be/AGLsWSMs6A0");
        Slimefun.addYoutubeVideo("PROGRAMMABLE_ANDROID_BUTCHER", "https://youtu.be/G-re3qV-LJQ");
        Slimefun.addYoutubeVideo("PROGRAMMABLE_ANDROID_2_BUTCHER", "https://youtu.be/G-re3qV-LJQ");
        Slimefun.addYoutubeVideo("INFUSED_HOPPER", "https://youtu.be/_H2HGwkfBh8");
        Slimefun.addYoutubeVideo("ELEVATOR_PLATE", "https://youtu.be/OdKMjo6vNIs");
        Slimefun.addYoutubeVideo("ENERGY_REGULATOR", "https://youtu.be/QvSUfBYagXk");
        Slimefun.addYoutubeVideo("COMBUSTION_REACTOR", "https://youtu.be/QvSUfBYagXk");
        Slimefun.addYoutubeVideo("MULTIMETER", "https://youtu.be/QvSUfBYagXk");
        Slimefun.addYoutubeVideo("FOOD_FABRICATOR", "https://youtu.be/qJdFfvTGOmI");
        Slimefun.addYoutubeVideo("AUTO_BREEDER", "https://youtu.be/qJdFfvTGOmI");
        Slimefun.addYoutubeVideo("ORGANIC_FOOD_MELON", "https://youtu.be/qJdFfvTGOmI");
        Slimefun.addYoutubeVideo("ORGANIC_FOOD_WHEAT", "https://youtu.be/qJdFfvTGOmI");
        Slimefun.addYoutubeVideo("ORGANIC_FOOD_APPLE", "https://youtu.be/qJdFfvTGOmI");
        Slimefun.addYoutubeVideo("ORGANIC_FOOD_CARROT", "https://youtu.be/qJdFfvTGOmI");
        Slimefun.addYoutubeVideo("ORGANIC_FOOD_SEEDS", "https://youtu.be/qJdFfvTGOmI");
        Slimefun.addYoutubeVideo("ORGANIC_FOOD_BEETROOT", "https://youtu.be/qJdFfvTGOmI");
        Slimefun.addYoutubeVideo("ORGANIC_FOOD_POTATO", "https://youtu.be/qJdFfvTGOmI");
        Slimefun.addYoutubeVideo("ANIMAL_GROWTH_ACCELERATOR", "https://youtu.be/bV4wEaSxXFw");
        Slimefun.addYoutubeVideo("FOOD_COMPOSTER", "https://youtu.be/LjzUlFKAHCI");
        Slimefun.addYoutubeVideo("FERTILIZER_WHEAT", "https://youtu.be/LjzUlFKAHCI");
        Slimefun.addYoutubeVideo("FERTILIZER_APPLE", "https://youtu.be/LjzUlFKAHCI");
        Slimefun.addYoutubeVideo("FERTILIZER_POTATO", "https://youtu.be/LjzUlFKAHCI");
        Slimefun.addYoutubeVideo("FERTILIZER_CARROT", "https://youtu.be/LjzUlFKAHCI");
        Slimefun.addYoutubeVideo("FERTILIZER_SEEDS", "https://youtu.be/LjzUlFKAHCI");
        Slimefun.addYoutubeVideo("FERTILIZER_BEETROOT", "https://youtu.be/LjzUlFKAHCI");
        Slimefun.addYoutubeVideo("FERTILIZER_MELON", "https://youtu.be/LjzUlFKAHCI");
        Slimefun.addYoutubeVideo("CROP_GROWTH_ACCELERATOR", "https://youtu.be/LjzUlFKAHCI");
        Slimefun.addYoutubeVideo("XP_COLLECTOR", "https://youtu.be/fHtJDPeLMlg");
        Slimefun.addYoutubeVideo("ELECTRIC_ORE_GRINDER", "https://youtu.be/A6OuK7sfnaI");
        Slimefun.addYoutubeVideo("ELECTRIC_GOLD_PAN", "https://youtu.be/A6OuK7sfnaI");
        Slimefun.addYoutubeVideo("ELECTRIC_DUST_WASHER", "https://youtu.be/A6OuK7sfnaI");
        Slimefun.addYoutubeVideo("ELECTRIC_INGOT_FACTORY", "https://youtu.be/A6OuK7sfnaI");
        Slimefun.addYoutubeVideo("AUTOMATED_CRAFTING_CHAMBER", "https://youtu.be/FZj7nu9sOYA");
        Slimefun.addYoutubeVideo("CARGO_MANAGER", "https://youtu.be/Lt2aGw5lQPI");
        Slimefun.addYoutubeVideo("CARGO_NODE_INPUT", "https://youtu.be/Lt2aGw5lQPI");
        Slimefun.addYoutubeVideo("CARGO_NODE_OUTPUT", "https://youtu.be/Lt2aGw5lQPI");
        Slimefun.addYoutubeVideo("GPS_CONTROL_PANEL", "https://youtu.be/kOopBkiRzjs");
        Slimefun.addYoutubeVideo("GPS_TRANSMITTER", "https://youtu.be/kOopBkiRzjs");
        Slimefun.addYoutubeVideo("GPS_TRANSMITTER_2", "https://youtu.be/kOopBkiRzjs");
        Slimefun.addYoutubeVideo("GPS_TRANSMITTER_3", "https://youtu.be/kOopBkiRzjs");
        Slimefun.addYoutubeVideo("GPS_TRANSMITTER_4", "https://youtu.be/kOopBkiRzjs");
        Slimefun.addYoutubeVideo("SOLAR_GENERATOR", "https://youtu.be/kOopBkiRzjs");
        Slimefun.addYoutubeVideo("SOLAR_GENERATOR_2", "https://youtu.be/kOopBkiRzjs");
        Slimefun.addYoutubeVideo("SOLAR_GENERATOR_3", "https://youtu.be/kOopBkiRzjs");
        Slimefun.addYoutubeVideo("SOLAR_GENERATOR_4", "https://youtu.be/kOopBkiRzjs");
        WikiSetup.setup();
    }
}

