/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.InvUtils;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.MultiBlock;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Container;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class SlimefunMachine
extends SlimefunItem {
    private List<ItemStack[]> recipes = new ArrayList<ItemStack[]>();
    private List<ItemStack> shownRecipes = new ArrayList<ItemStack>();
    private Material trigger;
    private static final BlockFace[] outputFaces = new BlockFace[]{BlockFace.UP, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};

    public SlimefunMachine(Category category, ItemStack item, String id, ItemStack[] recipe, ItemStack[] machineRecipes, Material trigger) {
        super(category, item, id, RecipeType.MULTIBLOCK, recipe);
        this.shownRecipes.addAll(Arrays.asList(machineRecipes));
        this.trigger = trigger;
    }

    public SlimefunMachine(Category category, ItemStack item, String id, ItemStack[] recipe, ItemStack[] machineRecipes, Material trigger, boolean ghost) {
        super(category, item, id, RecipeType.MULTIBLOCK, recipe, ghost);
        this.shownRecipes.addAll(Arrays.asList(machineRecipes));
        this.trigger = trigger;
    }

    public SlimefunMachine(Category category, ItemStack item, String id, ItemStack[] recipe, ItemStack[] machineRecipes, Material trigger, String[] keys, Object[] values) {
        super(category, item, id, RecipeType.MULTIBLOCK, recipe, keys, values);
        this.shownRecipes.addAll(Arrays.asList(machineRecipes));
        this.trigger = trigger;
    }

    public List<ItemStack[]> getRecipes() {
        return this.recipes;
    }

    public List<ItemStack> getDisplayRecipes() {
        return this.shownRecipes;
    }

    public static BlockFace[] getOutputFaces() {
        return outputFaces;
    }

    public void addRecipe(ItemStack[] input, ItemStack output) {
        this.recipes.add(input);
        this.recipes.add(new ItemStack[]{output});
    }

    @Override
    public void create() {
        this.toMultiBlock().register();
    }

    @Override
    public void install() {
        for (ItemStack i : this.getDisplayRecipes()) {
            SlimefunItem item = SlimefunItem.getByItem(i);
            if (item == null) {
                this.recipes.add(new ItemStack[]{i});
                continue;
            }
            if (SlimefunItem.isDisabled(i)) continue;
            this.recipes.add(new ItemStack[]{i});
        }
    }

    public MultiBlock toMultiBlock() {
        ArrayList<Material> mats = new ArrayList<Material>();
        for (ItemStack i : this.getRecipe()) {
            if (i == null) {
                mats.add(null);
                continue;
            }
            if (i.getType() == Material.FLINT_AND_STEEL) {
                mats.add(Material.FIRE);
                continue;
            }
            mats.add(i.getType());
        }
        Material[] build = mats.toArray(new Material[mats.size()]);
        return new MultiBlock(build, this.trigger);
    }

    public Iterator<ItemStack[]> recipeIterator() {
        return this.recipes.iterator();
    }

    public static Inventory findValidOutputInv(ItemStack adding, Block dispBlock, Inventory dispInv) {
        return SlimefunMachine.findValidOutputInv(adding, dispBlock, dispInv, dispInv);
    }

    public static Inventory findValidOutputInv(ItemStack product, Block dispBlock, Inventory dispInv, Inventory placeCheckerInv) {
        Inventory outputInv = null;
        for (BlockFace face : outputFaces) {
            Inventory inv;
            Block potentialOutput = dispBlock.getRelative(face);
            String id = BlockStorage.checkID(potentialOutput);
            if (id == null || !id.equals("OUTPUT_CHEST") || !InvUtils.fits((Inventory)(inv = ((Container)potentialOutput.getState()).getInventory()), (ItemStack)product)) continue;
            outputInv = inv;
            break;
        }
        if (outputInv == null && InvUtils.fits((Inventory)placeCheckerInv, (ItemStack)product)) {
            outputInv = dispInv;
        }
        return outputInv;
    }
}

