/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem;

import java.util.ArrayList;
import java.util.Random;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Variable;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.Slimefun.Lists.Categories;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Research;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.EnderTalisman;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Setup.Messages;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;

public class Talisman
extends SlimefunItem {
    private String suffix;
    private boolean consumable = true;
    private boolean cancel = true;
    private PotionEffect[] effects;
    private int chance = 100;

    public Talisman(ItemStack item, String id, ItemStack[] recipe, boolean consumable, boolean cancelEvent, String messageSuffix, PotionEffect ... effects) {
        super(Categories.TALISMANS_1, item, id, RecipeType.MAGIC_WORKBENCH, recipe, (ItemStack)new CustomItem(item, consumable ? 4 : 1));
        this.consumable = consumable;
        this.cancel = cancelEvent;
        this.suffix = messageSuffix;
        this.effects = effects;
    }

    public Talisman(ItemStack item, String id, ItemStack[] recipe, boolean consumable, boolean cancelEvent, String messageSuffix, int chance, PotionEffect ... effects) {
        super(Categories.TALISMANS_1, item, id, RecipeType.MAGIC_WORKBENCH, recipe, (ItemStack)new CustomItem(item, consumable ? 4 : 1));
        this.consumable = consumable;
        this.cancel = cancelEvent;
        this.suffix = messageSuffix;
        this.effects = effects;
        this.chance = chance;
    }

    public Talisman(ItemStack item, String id, ItemStack[] recipe, String messageSuffix, int chance, PotionEffect ... effects) {
        super(Categories.TALISMANS_1, item, id, RecipeType.MAGIC_WORKBENCH, recipe, item);
        this.suffix = messageSuffix;
        this.effects = effects;
        this.chance = chance;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean isConsumable() {
        return this.consumable;
    }

    public boolean isEventCancelled() {
        return this.cancel;
    }

    public PotionEffect[] getEffects() {
        return this.effects;
    }

    public int getChance() {
        return this.chance;
    }

    public static boolean checkFor(Event e, SlimefunItem item) {
        if (!(item instanceof Talisman)) {
            return false;
        }
        Talisman talisman = (Talisman)item;
        if (new Random().nextInt(100) < talisman.getChance()) {
            return false;
        }
        Player p = Talisman.getPlayerByEventType(e);
        if (p == null || !Talisman.pass(p, talisman)) {
            return false;
        }
        if (p.getInventory().containsAtLeast(talisman.getItem(), 1)) {
            if (Slimefun.hasUnlocked(p, talisman.getItem(), true)) {
                Talisman.executeTalismanAttributes(e, p, talisman);
                return true;
            }
            return false;
        }
        if (p.getEnderChest().containsAtLeast(talisman.upgrade(), 1)) {
            if (Slimefun.hasUnlocked(p, talisman.upgrade(), true)) {
                Talisman.executeTalismanAttributes(e, p, talisman);
                return true;
            }
            return false;
        }
        return false;
    }

    public ItemStack upgrade() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("&7&oEnder Infused");
        lore.add("");
        for (String line : this.getItem().getItemMeta().getLore()) {
            lore.add(line);
        }
        return new CustomItem(this.getItem().getType(), "&5Ender " + ChatColor.stripColor((String)this.getItem().getItemMeta().getDisplayName()), lore.toArray(new String[lore.size()]));
    }

    @Override
    public void create() {
        EnderTalisman talisman = new EnderTalisman(this);
        talisman.register(true);
    }

    @Override
    public void install() {
        EnderTalisman talisman = (EnderTalisman)SlimefunItem.getByItem(this.upgrade());
        Research research = Research.getByID(112);
        if (talisman != null) {
            Slimefun.addOfficialWikiPage(talisman.getID(), "Talismans");
            if (research != null) {
                talisman.bindToResearch(research);
            }
        }
        Slimefun.addOfficialWikiPage(this.getID(), "Talismans");
    }

    private static boolean isTalismanMessage(Talisman talisman) {
        return !"".equalsIgnoreCase(talisman.getSuffix());
    }

    private static void executeTalismanAttributes(Event e, Player p, Talisman talisman) {
        Talisman.consumeItem(p, talisman);
        Talisman.applyTalismanEffects(p, talisman);
        Talisman.cancelEvent(e, talisman);
        Talisman.sendMessage(p, talisman);
    }

    private static void applyTalismanEffects(Player p, Talisman talisman) {
        for (PotionEffect effect : talisman.getEffects()) {
            p.addPotionEffect(effect);
        }
    }

    private static void cancelEvent(Event e, Talisman talisman) {
        if (e instanceof Cancellable && talisman.isEventCancelled()) {
            ((Cancellable)e).setCancelled(true);
        }
    }

    private static void sendMessage(Player p, Talisman talisman) {
        if (Talisman.isTalismanMessage(talisman)) {
            Messages.local.sendTranslation((CommandSender)p, "messages.talisman." + talisman.getSuffix(), true, new Variable[0]);
        }
    }

    private static void consumeItem(Player p, Talisman talisman) {
        if (talisman.isConsumable()) {
            p.getInventory().removeItem(new ItemStack[]{talisman.getItem()});
        }
    }

    private static Player getPlayerByEventType(Event e) {
        if (e instanceof EntityDeathEvent) {
            return ((EntityDeathEvent)e).getEntity().getKiller();
        }
        if (e instanceof BlockBreakEvent) {
            return ((BlockBreakEvent)e).getPlayer();
        }
        if (e instanceof PlayerEvent) {
            return ((PlayerEvent)e).getPlayer();
        }
        if (e instanceof EntityEvent) {
            return (Player)((EntityEvent)e).getEntity();
        }
        if (e instanceof EnchantItemEvent) {
            return ((EnchantItemEvent)e).getEnchanter();
        }
        return null;
    }

    private static boolean pass(Player p, SlimefunItem talisman) {
        for (PotionEffect effect : ((Talisman)talisman).getEffects()) {
            if (effect == null || !p.hasPotionEffect(effect.getType())) continue;
            return false;
        }
        return true;
    }
}

