/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.ancient_altar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import me.mrCookieSlime.Slimefun.ancient_altar.AncientAltarListener;
import me.mrCookieSlime.Slimefun.utils.Utilities;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class RitualAnimation
implements Runnable {
    private List<Block> altars;
    private Block altar;
    private Location l;
    private ItemStack output;
    private List<Block> pedestals;
    private List<ItemStack> items;
    private List<Location> particles;
    private Map<Item, Location> itemLock = new HashMap<Item, Location>();
    private boolean running;
    private int stage;
    private Utilities utilities = SlimefunStartup.instance.getUtilities();

    public RitualAnimation(List<Block> altars, Block altar, Location drop, ItemStack output, List<Block> pedestals, List<ItemStack> items) {
        this.l = drop;
        this.altar = altar;
        this.altars = altars;
        this.output = output;
        this.pedestals = pedestals;
        this.items = items;
        this.particles = new ArrayList<Location>();
        this.running = true;
        this.stage = 0;
        for (Block pedestal : this.pedestals) {
            Item item = AncientAltarListener.findItem(pedestal);
            this.itemLock.put(item, item.getLocation().clone());
        }
    }

    @Override
    public void run() {
        this.idle();
        if (!this.checkLockedItems()) {
            this.abort();
            return;
        }
        if (this.stage == 36) {
            this.finish();
            return;
        }
        if (this.stage > 0 && this.stage % 4 == 0) {
            this.checkPedestal(this.pedestals.get(this.stage / 4 - 1));
        }
        ++this.stage;
        SlimefunStartup.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, (Runnable)this, 8L);
    }

    private boolean checkLockedItems() {
        for (Map.Entry<Item, Location> entry : this.itemLock.entrySet()) {
            if (!(entry.getKey().getLocation().distance(entry.getValue()) > 0.3)) continue;
            return false;
        }
        return true;
    }

    private void idle() {
        try {
            this.l.getWorld().spawnParticle(Particle.SPELL_WITCH, this.l, 16, (double)1.2f, 0.0, (double)1.2f);
            this.l.getWorld().spawnParticle(Particle.FIREWORKS_SPARK, this.l, 8, (double)0.2f, 0.0, (double)0.2f);
            for (Location l2 : this.particles) {
                this.l.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, l2, 16, (double)0.3f, (double)0.2f, (double)0.3f);
                this.l.getWorld().spawnParticle(Particle.CRIT_MAGIC, l2, 8, (double)0.3f, (double)0.2f, (double)0.3f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkPedestal(Block pedestal) {
        Item item = AncientAltarListener.findItem(pedestal);
        if (item == null || this.itemLock.remove(item) == null) {
            this.abort();
        } else {
            this.particles.add(pedestal.getLocation().add(0.5, 1.5, 0.5));
            this.items.add(AncientAltarListener.fixItemStack(item.getItemStack(), item.getCustomName()));
            pedestal.getWorld().playSound(pedestal.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 5.0f, 2.0f);
            try {
                this.l.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, pedestal.getLocation().add(0.5, 1.5, 0.5), 16, (double)0.3f, (double)0.2f, (double)0.3f);
                this.l.getWorld().spawnParticle(Particle.CRIT_MAGIC, pedestal.getLocation().add(0.5, 1.5, 0.5), 8, (double)0.3f, (double)0.2f, (double)0.3f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.itemLock.remove(item);
            item.remove();
            pedestal.removeMetadata("item_placed", (Plugin)SlimefunStartup.instance);
        }
    }

    private void abort() {
        this.running = false;
        this.pedestals.forEach(b -> this.utilities.altarinuse.remove(b.getLocation()));
        this.utilities.altarinuse.remove(this.altar.getLocation());
        this.l.getWorld().playSound(this.l, Sound.ENTITY_ZOMBIE_ATTACK_IRON_DOOR, 5.0f, 1.0f);
        this.itemLock.clear();
        this.altars.remove(this.altar);
    }

    private void finish() {
        if (this.running) {
            this.l.getWorld().playSound(this.l, Sound.ENTITY_ZOMBIE_VILLAGER_CURE, 1.0f, 1.0f);
            this.l.getWorld().playEffect(this.l, Effect.STEP_SOUND, (Object)Material.EMERALD_BLOCK);
            this.l.getWorld().dropItemNaturally(this.l.add(0.0, 1.0, 0.0), this.output);
            this.pedestals.forEach(b -> this.utilities.altarinuse.remove(b.getLocation()));
            this.utilities.altarinuse.remove(this.altar.getLocation());
            this.altars.remove(this.altar);
        } else {
            this.l.getWorld().playSound(this.l, Sound.ENTITY_ZOMBIE_BREAK_WOODEN_DOOR, 1.0f, 1.0f);
        }
    }
}

