/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines;

import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunBlockHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.UnregisterReason;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.holograms.InfusedHopperHologram;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class InfusedHopper
extends SlimefunItem {
    public InfusedHopper(Category category, ItemStack item, String id, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, id, recipeType, recipe);
        SlimefunItem.registerBlockHandler(this.getID(), new SlimefunBlockHandler(){

            @Override
            public void onPlace(Player p, Block b, SlimefunItem item) {
                InfusedHopperHologram.getArmorStand(b, true);
            }

            @Override
            public boolean onBreak(Player p, Block b, SlimefunItem item, UnregisterReason reason) {
                InfusedHopperHologram.remove(b);
                return true;
            }
        });
    }

    @Override
    public void register(boolean slimefun) {
        this.addItemHandler(new BlockTicker(){

            @Override
            public void uniqueTick() {
            }

            @Override
            public void tick(Block b, SlimefunItem item, Config data) {
                if (b.getType() != Material.HOPPER) {
                    BlockStorage.clearBlockInfo(b);
                    return;
                }
                ArmorStand hologram = InfusedHopperHologram.getArmorStand(b, true);
                boolean sound = false;
                for (Entity n : hologram.getNearbyEntities(3.5, 3.5, 3.5)) {
                    if (!(n instanceof Item) || n.hasMetadata("no_pickup") || !(n.getLocation().distance(hologram.getLocation()) > 0.4)) continue;
                    n.setVelocity(new Vector(0.0, 0.1, 0.0));
                    n.teleport((Entity)hologram);
                    sound = true;
                }
                if (sound) {
                    b.getWorld().playSound(b.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 5.0f, 2.0f);
                }
            }

            @Override
            public boolean isSynchronized() {
                return true;
            }
        });
        super.register(slimefun);
    }
}

