/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.listeners;

import java.util.ArrayList;
import java.util.Iterator;
import me.mrCookieSlime.CSCoreLibPlugin.general.Block.BlockAdjacents;
import me.mrCookieSlime.Slimefun.Events.MultiBlockInteractEvent;
import me.mrCookieSlime.Slimefun.Objects.MultiBlock;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler;
import me.mrCookieSlime.Slimefun.Objects.handlers.MultiBlockInteractionHandler;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BlockListener
implements Listener {
    public BlockListener(SlimefunStartup plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onBlockFall(EntityChangeBlockEvent event) {
        if (event.getEntity() instanceof FallingBlock && BlockStorage.hasBlockInfo(event.getBlock())) {
            event.setCancelled(true);
            FallingBlock fb = (FallingBlock)event.getEntity();
            if (fb.getDropItem()) {
                fb.getWorld().dropItemNaturally(fb.getLocation(), new ItemStack(fb.getBlockData().getMaterial(), 1));
            }
        }
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent e) {
        for (Block b : e.getBlocks()) {
            if (BlockStorage.hasBlockInfo(b)) {
                e.setCancelled(true);
                return;
            }
            if (b.getRelative(e.getDirection()).getType() != Material.AIR || !BlockStorage.hasBlockInfo(b.getRelative(e.getDirection()))) continue;
            e.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent e) {
        if (e.isSticky()) {
            for (Block b : e.getBlocks()) {
                if (BlockStorage.hasBlockInfo(b)) {
                    e.setCancelled(true);
                    return;
                }
                if (b.getRelative(e.getDirection()).getType() != Material.AIR || !BlockStorage.hasBlockInfo(b.getRelative(e.getDirection()))) continue;
                e.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent e) {
        if (e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            if (e.getHand() != EquipmentSlot.HAND) {
                return;
            }
            Player p = e.getPlayer();
            Block b = e.getClickedBlock();
            ArrayList<MultiBlock> multiblocks = new ArrayList<MultiBlock>();
            for (MultiBlock mb : MultiBlock.list()) {
                if (mb.getTriggerBlock() != b.getType()) continue;
                Material[] blocks = mb.getBuild();
                if (mb.getTriggerBlock() == blocks[1]) {
                    if (!BlockAdjacents.hasMaterialOnSide((Block)b, (Material)blocks[0]) || !BlockAdjacents.hasMaterialOnSide((Block)b, (Material)blocks[2]) || !BlockAdjacents.isMaterial((Block)b.getRelative(BlockFace.DOWN), (Material)blocks[4]) || !BlockAdjacents.hasMaterialOnSide((Block)b.getRelative(BlockFace.DOWN), (Material)blocks[3]) || !BlockAdjacents.hasMaterialOnSide((Block)b.getRelative(BlockFace.DOWN), (Material)blocks[5]) || !BlockAdjacents.isMaterial((Block)b.getRelative(BlockFace.DOWN).getRelative(BlockFace.DOWN), (Material)blocks[7]) || !BlockAdjacents.hasMaterialOnSide((Block)b.getRelative(BlockFace.DOWN).getRelative(BlockFace.DOWN), (Material)blocks[6]) || !BlockAdjacents.hasMaterialOnSide((Block)b.getRelative(BlockFace.DOWN).getRelative(BlockFace.DOWN), (Material)blocks[8]) || blocks[0] != null && blocks[0] == blocks[2] && !BlockAdjacents.hasMaterialOnBothSides((Block)b.getRelative(0, 0, 0), (Material)blocks[0]) || blocks[3] != null && blocks[3] == blocks[5] && !BlockAdjacents.hasMaterialOnBothSides((Block)b.getRelative(0, -1, 0), (Material)blocks[5]) || blocks[6] != null && blocks[6] == blocks[8] && !BlockAdjacents.hasMaterialOnBothSides((Block)b.getRelative(0, -2, 0), (Material)blocks[8])) continue;
                    multiblocks.add(mb);
                    continue;
                }
                if (mb.getTriggerBlock() == blocks[4]) {
                    if (!BlockAdjacents.hasMaterialOnSide((Block)b, (Material)blocks[3]) || !BlockAdjacents.hasMaterialOnSide((Block)b, (Material)blocks[5]) || !BlockAdjacents.isMaterial((Block)b.getRelative(BlockFace.DOWN), (Material)blocks[7]) || !BlockAdjacents.hasMaterialOnSide((Block)b.getRelative(BlockFace.DOWN), (Material)blocks[6]) || !BlockAdjacents.hasMaterialOnSide((Block)b.getRelative(BlockFace.DOWN), (Material)blocks[8]) || !BlockAdjacents.isMaterial((Block)b.getRelative(BlockFace.UP), (Material)blocks[1]) || !BlockAdjacents.hasMaterialOnSide((Block)b.getRelative(BlockFace.UP), (Material)blocks[0]) || !BlockAdjacents.hasMaterialOnSide((Block)b.getRelative(BlockFace.UP), (Material)blocks[2]) || blocks[0] != null && blocks[0] == blocks[2] && !BlockAdjacents.hasMaterialOnBothSides((Block)b.getRelative(0, 1, 0), (Material)blocks[0]) || blocks[3] != null && blocks[3] == blocks[5] && !BlockAdjacents.hasMaterialOnBothSides((Block)b.getRelative(0, 0, 0), (Material)blocks[5]) || blocks[6] != null && blocks[6] == blocks[8] && !BlockAdjacents.hasMaterialOnBothSides((Block)b.getRelative(0, -1, 0), (Material)blocks[8])) continue;
                    multiblocks.add(mb);
                    continue;
                }
                if (mb.getTriggerBlock() != blocks[7] || !BlockAdjacents.hasMaterialOnSide((Block)b, (Material)blocks[6]) || !BlockAdjacents.hasMaterialOnSide((Block)b, (Material)blocks[8]) || !BlockAdjacents.isMaterial((Block)b.getRelative(BlockFace.UP).getRelative(BlockFace.UP), (Material)blocks[1]) || !BlockAdjacents.hasMaterialOnSide((Block)b.getRelative(BlockFace.UP).getRelative(BlockFace.UP), (Material)blocks[0]) || !BlockAdjacents.hasMaterialOnSide((Block)b.getRelative(BlockFace.UP).getRelative(BlockFace.UP), (Material)blocks[2]) || !BlockAdjacents.isMaterial((Block)b.getRelative(BlockFace.UP), (Material)blocks[4]) || !BlockAdjacents.hasMaterialOnSide((Block)b.getRelative(BlockFace.UP), (Material)blocks[3]) || !BlockAdjacents.hasMaterialOnSide((Block)b.getRelative(BlockFace.UP), (Material)blocks[5]) || blocks[0] != null && blocks[0] == blocks[2] && !BlockAdjacents.hasMaterialOnBothSides((Block)b.getRelative(0, 2, 0), (Material)blocks[0]) || blocks[3] != null && blocks[3] == blocks[5] && !BlockAdjacents.hasMaterialOnBothSides((Block)b.getRelative(0, 1, 0), (Material)blocks[5]) || blocks[6] != null && blocks[6] == blocks[8] && !BlockAdjacents.hasMaterialOnBothSides((Block)b.getRelative(0, 0, 0), (Material)blocks[8])) continue;
                multiblocks.add(mb);
            }
            if (!multiblocks.isEmpty()) {
                ItemHandler handler;
                e.setCancelled(true);
                Iterator<Object> iterator = SlimefunItem.getHandlers("MultiBlockInteractionHandler").iterator();
                while (iterator.hasNext() && !((MultiBlockInteractionHandler)(handler = (ItemHandler)iterator.next())).onInteract(p, (MultiBlock)multiblocks.get(multiblocks.size() - 1), b)) {
                }
                MultiBlockInteractEvent event = new MultiBlockInteractEvent(p, (MultiBlock)multiblocks.get(multiblocks.size() - 1), b);
                Bukkit.getPluginManager().callEvent((Event)event);
            }
        }
    }
}

