/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.listeners;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import me.mrCookieSlime.EmeraldEnchants.EmeraldEnchants;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SoulboundItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.Talisman;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.Soul;
import me.mrCookieSlime.Slimefun.utils.Utilities;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class DamageListener
implements Listener {
    private SimpleDateFormat format = new SimpleDateFormat("(MMM d, yyyy @ hh:mm)");
    private Utilities utilities;

    public DamageListener(SlimefunStartup plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.utilities = plugin.getUtilities();
    }

    @EventHandler
    public void onDamage(EntityDeathEvent e) {
        Player p;
        if (e.getEntity() instanceof Player) {
            p = (Player)e.getEntity();
            if (p.getInventory().containsAtLeast(SlimefunItems.GPS_EMERGENCY_TRANSMITTER, 1)) {
                Slimefun.getGPSNetwork().addWaypoint(p, "&4Deathpoint &7" + this.format.format(new Date()), p.getLocation().getBlock().getLocation());
            }
            Iterator drops = e.getDrops().iterator();
            while (drops.hasNext()) {
                ItemStack item = (ItemStack)drops.next();
                if (item == null) continue;
                if (SlimefunManager.isItemSimiliar(item, SlimefunItems.BOUND_BACKPACK, false)) {
                    Soul.storeItem(e.getEntity().getUniqueId(), item);
                    drops.remove();
                    continue;
                }
                if (SlimefunItem.getByItem(this.removeEnchantments(item)) == null || !(SlimefunItem.getByItem(this.removeEnchantments(item)) instanceof SoulboundItem)) continue;
                Soul.storeItem(e.getEntity().getUniqueId(), item);
                drops.remove();
            }
        }
        if (e.getEntity().getKiller() instanceof Player) {
            p = e.getEntity().getKiller();
            ItemStack item = p.getInventory().getItemInMainHand();
            if (SlimefunManager.drops.containsKey(e.getEntity().getType())) {
                for (ItemStack drop : SlimefunManager.drops.get(e.getEntity().getType())) {
                    if (!Slimefun.hasUnlocked(p, item, true)) continue;
                    e.getDrops().add(drop);
                }
            }
            if (item != null && Slimefun.hasUnlocked(p, item, true) && SlimefunManager.isItemSimiliar(item, SlimefunItem.getItem("SWORD_OF_BEHEADING"), true)) {
                if (e.getEntity() instanceof Zombie) {
                    if (SlimefunStartup.chance(100, (Integer)Slimefun.getItemValue("SWORD_OF_BEHEADING", "chance.ZOMBIE"))) {
                        e.getDrops().add(new ItemStack(Material.ZOMBIE_HEAD));
                    }
                } else if (e.getEntity() instanceof WitherSkeleton) {
                    if (SlimefunStartup.chance(100, (Integer)Slimefun.getItemValue("SWORD_OF_BEHEADING", "chance.WITHER_SKELETON"))) {
                        e.getDrops().add(new ItemStack(Material.WITHER_SKELETON_SKULL));
                    }
                } else if (e.getEntity() instanceof Skeleton) {
                    if (SlimefunStartup.chance(100, (Integer)Slimefun.getItemValue("SWORD_OF_BEHEADING", "chance.SKELETON"))) {
                        e.getDrops().add(new ItemStack(Material.SKELETON_SKULL));
                    }
                } else if (e.getEntity() instanceof Creeper) {
                    if (SlimefunStartup.chance(100, (Integer)Slimefun.getItemValue("SWORD_OF_BEHEADING", "chance.CREEPER"))) {
                        e.getDrops().add(new ItemStack(Material.CREEPER_HEAD));
                    }
                } else if (e.getEntity() instanceof Player && SlimefunStartup.chance(100, (Integer)Slimefun.getItemValue("SWORD_OF_BEHEADING", "chance.PLAYER"))) {
                    ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
                    ItemMeta meta = skull.getItemMeta();
                    ((SkullMeta)meta).setOwningPlayer((OfflinePlayer)((Player)e.getEntity()));
                    skull.setItemMeta(meta);
                    e.getDrops().add(skull);
                }
            }
            if (!e.getEntity().getCanPickupItems() && Talisman.checkFor((Event)e, SlimefunItem.getByID("HUNTER_TALISMAN")) && !(e.getEntity() instanceof Player)) {
                ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
                for (ItemStack drop : e.getDrops()) {
                    newDrops.add(drop);
                }
                for (ItemStack drop : newDrops) {
                    e.getDrops().add(drop);
                }
                if (e.getEntity() instanceof ChestedHorse) {
                    for (ItemStack invItem : ((ChestedHorse)e.getEntity()).getInventory().getStorageContents()) {
                        e.getDrops().remove(invItem);
                    }
                    e.getDrops().remove(new ItemStack(Material.CHEST));
                }
            }
        }
    }

    @EventHandler
    public void onArrowHit(EntityDamageEvent e) {
        if (e.getEntity() instanceof Player && e.getCause() == EntityDamageEvent.DamageCause.FALL && this.utilities.damage.contains(e.getEntity().getUniqueId())) {
            e.setCancelled(true);
            this.utilities.damage.remove(e.getEntity().getUniqueId());
        }
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent e) {
        Soul.retrieveItems(e.getPlayer());
    }

    private ItemStack removeEnchantments(ItemStack itemStack) {
        ItemStack strippedItem = itemStack.clone();
        for (Enchantment enchantment : itemStack.getEnchantments().keySet()) {
            strippedItem.removeEnchantment(enchantment);
        }
        if (Slimefun.isEmeraldEnchantsInstalled()) {
            for (Enchantment enchantment : EmeraldEnchants.getInstance().getRegistry().getEnchantments(itemStack)) {
                EmeraldEnchants.getInstance().getRegistry().applyEnchantment(strippedItem, enchantment.getEnchantment(), 0);
            }
        }
        return strippedItem;
    }
}

