/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.listeners;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Variable;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.CSCoreLibPlugin.general.Player.PlayerInventory;
import me.mrCookieSlime.CSCoreLibPlugin.general.String.StringUtils;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Setup.Messages;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import me.mrCookieSlime.Slimefun.Utilities;
import me.mrCookieSlime.Slimefun.ancient_altar.Pedestals;
import me.mrCookieSlime.Slimefun.ancient_altar.RitualAnimation;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class AncientAltarListener
implements Listener {
    private Utilities utilities;
    private List<Block> altars = new ArrayList<Block>();
    private Set<UUID> removed_items = new HashSet<UUID>();

    public AncientAltarListener(SlimefunStartup plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.utilities = plugin.getUtilities();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onInteract(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block b = e.getClickedBlock();
        SlimefunItem item = BlockStorage.check(b);
        if (item != null) {
            if (item.getID().equals("ANCIENT_PEDESTAL")) {
                if (this.utilities.altarinuse.contains(b.getLocation())) {
                    e.setCancelled(true);
                    return;
                }
                e.setCancelled(true);
                Item stack = AncientAltarListener.findItem(b);
                if (stack == null) {
                    if (e.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)Material.AIR)) {
                        return;
                    }
                    if (b.getRelative(0, 1, 0).getType() != Material.AIR) {
                        Messages.local.sendTranslation((CommandSender)e.getPlayer(), "machines.ANCIENT_PEDESTAL.obstructed", true, new Variable[0]);
                        return;
                    }
                    this.insertItem(e.getPlayer(), b);
                } else if (!this.removed_items.contains(stack.getUniqueId())) {
                    UUID uuid = stack.getUniqueId();
                    this.removed_items.add(uuid);
                    SlimefunStartup.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, () -> this.removed_items.remove(uuid), 30L);
                    stack.remove();
                    e.getPlayer().getInventory().addItem(new ItemStack[]{AncientAltarListener.fixItemStack(stack.getItemStack(), stack.getCustomName())});
                    e.getPlayer().playSound(b.getLocation(), Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
                    PlayerInventory.update((Player)e.getPlayer());
                }
            } else if (item.getID().equals("ANCIENT_ALTAR")) {
                if (this.utilities.altarinuse.contains(b.getLocation())) {
                    e.setCancelled(true);
                    return;
                }
                this.utilities.altarinuse.add(b.getLocation());
                e.setCancelled(true);
                CustomItem catalyst = new CustomItem(e.getPlayer().getInventory().getItemInMainHand(), 1);
                List<Block> pedestals = Pedestals.getPedestals(b);
                if (!this.altars.contains(e.getClickedBlock())) {
                    this.altars.add(e.getClickedBlock());
                    if (pedestals.size() == 8) {
                        pedestals.forEach(pblock -> this.utilities.altarinuse.add(pblock.getLocation()));
                        if (catalyst != null && !catalyst.getType().equals((Object)Material.AIR)) {
                            ArrayList<ItemStack> input = new ArrayList<ItemStack>();
                            for (Block pedestal : pedestals) {
                                Item stack = AncientAltarListener.findItem(pedestal);
                                if (stack == null) continue;
                                input.add(AncientAltarListener.fixItemStack(stack.getItemStack(), stack.getCustomName()));
                            }
                            ItemStack result = Pedestals.getRecipeOutput((ItemStack)catalyst, input);
                            if (result != null) {
                                ArrayList<ItemStack> consumed = new ArrayList<ItemStack>();
                                consumed.add((ItemStack)catalyst);
                                PlayerInventory.consumeItemInHand((Player)e.getPlayer());
                                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, (Runnable)new RitualAnimation(this.altars, b, b.getLocation().add(0.5, 1.3, 0.5), result, pedestals, consumed), 10L);
                            } else {
                                this.altars.remove(e.getClickedBlock());
                                Messages.local.sendTranslation((CommandSender)e.getPlayer(), "machines.ANCIENT_ALTAR.unknown-recipe", true, new Variable[0]);
                                pedestals.forEach(pblock -> this.utilities.altarinuse.remove(pblock.getLocation()));
                                this.utilities.altarinuse.remove(b.getLocation());
                            }
                        } else {
                            this.altars.remove(e.getClickedBlock());
                            Messages.local.sendTranslation((CommandSender)e.getPlayer(), "machines.ANCIENT_ALTAR.unknown-catalyst", true, new Variable[0]);
                            pedestals.forEach(pblock -> this.utilities.altarinuse.remove(pblock.getLocation()));
                            this.utilities.altarinuse.remove(b.getLocation());
                        }
                    } else {
                        this.altars.remove(e.getClickedBlock());
                        Messages.local.sendTranslation((CommandSender)e.getPlayer(), "machines.ANCIENT_ALTAR.not-enough-pedestals", true, new Variable[]{new Variable("%pedestals%", String.valueOf(pedestals.size()))});
                        this.utilities.altarinuse.remove(b.getLocation());
                    }
                }
            }
        }
    }

    public static ItemStack fixItemStack(ItemStack itemStack, String customName) {
        ItemStack stack = itemStack.clone();
        if (customName.equals(StringUtils.formatItemName((ItemStack)new ItemStack(itemStack.getType()), (boolean)false))) {
            ItemMeta im = stack.getItemMeta();
            im.setDisplayName(null);
            stack.setItemMeta(im);
        } else {
            ItemMeta im = stack.getItemMeta();
            if (!customName.startsWith(String.valueOf('\u00a7'))) {
                customName = ChatColor.RESET + customName;
            }
            im.setDisplayName(customName);
            stack.setItemMeta(im);
        }
        return stack;
    }

    public static Item findItem(Block b) {
        for (Entity n : b.getChunk().getEntities()) {
            if (!(n instanceof Item) || !(b.getLocation().add(0.5, 1.2, 0.5).distanceSquared(n.getLocation()) < 0.5) || n.getCustomName() == null) continue;
            return (Item)n;
        }
        return null;
    }

    private void insertItem(Player p, Block b) {
        ItemStack stack = p.getInventory().getItemInMainHand();
        if (stack != null) {
            PlayerInventory.consumeItemInHand((Player)p);
            String nametag = StringUtils.formatItemName((ItemStack)stack, (boolean)false);
            Item entity = b.getWorld().dropItem(b.getLocation().add(0.5, 1.2, 0.5), (ItemStack)new CustomItem((ItemStack)new CustomItem(stack, 1), "&5&dALTAR &3Probe - &e" + System.nanoTime()));
            entity.setVelocity(new Vector(0.0, 0.1, 0.0));
            entity.setMetadata("no_pickup", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunStartup.instance, (Object)"altar_item"));
            entity.setCustomNameVisible(true);
            entity.setCustomName(nametag);
            p.playSound(b.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.3f, 0.3f);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent e) {
        Block b = e.getBlockPlaced().getRelative(0, -1, 0);
        SlimefunItem item = BlockStorage.check(b);
        if (item == null) {
            return;
        }
        if (item.getID().equalsIgnoreCase("ANCIENT_PEDESTAL")) {
            Messages.local.sendTranslation((CommandSender)e.getPlayer(), "messages.cannot-place", true, new Variable[0]);
            e.setCancelled(true);
        }
    }
}

