/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines;

import java.util.ArrayList;
import java.util.Random;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.InvUtils;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineHelper;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines.OreWasher;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class ElectricDustWasher
extends AContainer {
    public static boolean legacy_dust_washer = false;

    public ElectricDustWasher(Category category, ItemStack item, String name, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, name, recipeType, recipe);
    }

    @Override
    public String getInventoryTitle() {
        return "&bElectric Dust Washer";
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.GOLDEN_SHOVEL);
    }

    @Override
    public void registerDefaultRecipes() {
    }

    @Override
    public abstract int getSpeed();

    @Override
    protected void tick(Block b) {
        block13: {
            block11: {
                block12: {
                    if (!this.isProcessing(b)) break block11;
                    int timeleft = (Integer)progress.get(b);
                    if (timeleft <= 0 || this.getSpeed() >= 10) break block12;
                    ItemStack item = this.getProgressBar().clone();
                    ItemMeta im = item.getItemMeta();
                    ((Damageable)im).setDamage((int)MachineHelper.getDurability(item, timeleft, ((MachineRecipe)processing.get(b)).getTicks()));
                    im.setDisplayName(" ");
                    ArrayList<String> lore = new ArrayList<String>();
                    lore.add(MachineHelper.getProgress(timeleft, ((MachineRecipe)processing.get(b)).getTicks()));
                    lore.add("");
                    lore.add(MachineHelper.getTimeLeft(timeleft / 2));
                    im.setLore(lore);
                    item.setItemMeta(im);
                    BlockStorage.getInventory(b).replaceExistingItem(22, item);
                    if (ChargableBlock.isChargable(b)) {
                        if (ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
                            return;
                        }
                        ChargableBlock.addCharge(b, -this.getEnergyConsumption());
                        progress.put(b, timeleft - 1);
                    } else {
                        progress.put(b, timeleft - 1);
                    }
                    break block13;
                }
                if (!ChargableBlock.isChargable(b)) break block13;
                if (ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
                    return;
                }
                ChargableBlock.addCharge(b, -this.getEnergyConsumption());
                BlockStorage.getInventory(b).replaceExistingItem(22, (ItemStack)new CustomItem(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " "));
                this.pushItems(b, ((MachineRecipe)processing.get(b)).getOutput());
                progress.remove(b);
                processing.remove(b);
                break block13;
            }
            for (int slot : this.getInputSlots()) {
                if (SlimefunManager.isItemSimiliar(BlockStorage.getInventory(b).getItemInSlot(slot), SlimefunItems.SIFTED_ORE, true)) {
                    if (!legacy_dust_washer) {
                        boolean empty_slot = false;
                        for (int output_slot : this.getOutputSlots()) {
                            if (BlockStorage.getInventory(b).getItemInSlot(output_slot) != null) continue;
                            empty_slot = true;
                            break;
                        }
                        if (!empty_slot) {
                            return;
                        }
                    }
                    ItemStack adding = OreWasher.items[new Random().nextInt(OreWasher.items.length)];
                    MachineRecipe r = new MachineRecipe(4 / this.getSpeed(), new ItemStack[0], new ItemStack[]{adding});
                    if (legacy_dust_washer && !this.fits(b, r.getOutput())) {
                        return;
                    }
                    BlockStorage.getInventory(b).replaceExistingItem(slot, InvUtils.decreaseItem((ItemStack)BlockStorage.getInventory(b).getItemInSlot(slot), (int)1));
                    processing.put(b, r);
                    progress.put(b, r.getTicks());
                    break;
                }
                if (!SlimefunManager.isItemSimiliar(BlockStorage.getInventory(b).getItemInSlot(slot), SlimefunItems.PULVERIZED_ORE, true)) continue;
                MachineRecipe r = new MachineRecipe(4 / this.getSpeed(), new ItemStack[0], new ItemStack[]{SlimefunItems.PURE_ORE_CLUSTER});
                if (!this.fits(b, r.getOutput())) {
                    return;
                }
                BlockStorage.getInventory(b).replaceExistingItem(slot, InvUtils.decreaseItem((ItemStack)BlockStorage.getInventory(b).getItemInSlot(slot), (int)1));
                processing.put(b, r);
                progress.put(b, r.getTicks());
                break;
            }
        }
    }

    @Override
    public String getMachineIdentifier() {
        return "ELECTRIC_DUST_WASHER";
    }
}

