/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.Talisman;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class TalismanListener
implements Listener {
    private final int[] armorSlots = new int[]{39, 38, 37, 36};

    public TalismanListener(SlimefunStartup plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDamageGet(EntityDamageEvent e) {
        if (!e.isCancelled()) {
            if (e instanceof EntityDamageByEntityEvent && ((EntityDamageByEntityEvent)e).getDamager() instanceof Player && SlimefunStartup.chance(100, 45) && SlimefunManager.isItemSimiliar(((Player)((EntityDamageByEntityEvent)e).getDamager()).getInventory().getItemInMainHand(), SlimefunItem.getItem("BLADE_OF_VAMPIRES"), true)) {
                ((Player)((EntityDamageByEntityEvent)e).getDamager()).playSound(((EntityDamageByEntityEvent)e).getDamager().getLocation(), Sound.ENTITY_ARROW_HIT_PLAYER, 0.7f, 0.7f);
                ((Player)((EntityDamageByEntityEvent)e).getDamager()).addPotionEffect(new PotionEffect(PotionEffectType.HEAL, 1, 1));
            }
            if (e.getEntity() instanceof Player && !e.isCancelled()) {
                if (e.getCause() == EntityDamageEvent.DamageCause.LAVA) {
                    Talisman.checkFor((Event)e, SlimefunItem.getByID("LAVA_TALISMAN"));
                }
                if (e.getCause() == EntityDamageEvent.DamageCause.DROWNING) {
                    Talisman.checkFor((Event)e, SlimefunItem.getByID("WATER_TALISMAN"));
                }
                if (e.getCause() == EntityDamageEvent.DamageCause.FALL) {
                    Talisman.checkFor((Event)e, SlimefunItem.getByID("ANGEL_TALISMAN"));
                }
                if (e.getCause() == EntityDamageEvent.DamageCause.FIRE) {
                    Talisman.checkFor((Event)e, SlimefunItem.getByID("FIRE_TALISMAN"));
                }
                if (e.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
                    Talisman.checkFor((Event)e, SlimefunItem.getByID("WARRIOR_TALISMAN"));
                }
                if (e.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
                    Talisman.checkFor((Event)e, SlimefunItem.getByID("KNIGHT_TALISMAN"));
                }
                if (e.getCause() == EntityDamageEvent.DamageCause.PROJECTILE && Talisman.checkFor((Event)e, SlimefunItem.getByID("WHIRLWIND_TALISMAN")) && ((EntityDamageByEntityEvent)e).getDamager() instanceof Projectile) {
                    Vector direction = ((Player)e.getEntity()).getEyeLocation().getDirection().multiply(2.0);
                    Projectile projectile = (Projectile)e.getEntity().getWorld().spawnEntity(((LivingEntity)e.getEntity()).getEyeLocation().add(direction.getX(), direction.getY(), direction.getZ()), ((EntityDamageByEntityEvent)e).getDamager().getType());
                    projectile.setVelocity(direction);
                    ((EntityDamageByEntityEvent)e).getDamager().remove();
                }
            }
        }
    }

    @EventHandler
    public void onItemBreak(PlayerItemBreakEvent e) {
        if (Talisman.checkFor((Event)e, SlimefunItem.getByID("ANVIL_TALISMAN"))) {
            ItemStack item;
            ItemMeta meta;
            PlayerInventory inv = e.getPlayer().getInventory();
            int slot = inv.getHeldItemSlot();
            if (!inv.getItem(inv.getHeldItemSlot()).equals((Object)e.getBrokenItem())) {
                for (int s : this.armorSlots) {
                    if (!inv.getItem(s).equals((Object)e.getBrokenItem())) continue;
                    slot = s;
                    break;
                }
            }
            if ((meta = (item = e.getBrokenItem().clone()).getItemMeta()) instanceof Damageable) {
                ((Damageable)meta).setDamage(0);
            }
            item.setItemMeta(meta);
            int itemSlot = slot;
            SlimefunStartup.instance.getServer().getScheduler().runTaskLater((Plugin)SlimefunStartup.instance, () -> inv.setItem(itemSlot, item), 1L);
        }
    }

    @EventHandler
    public void onSprint(PlayerToggleSprintEvent e) {
        if (e.isSprinting()) {
            Talisman.checkFor((Event)e, SlimefunItem.getByID("TRAVELLER_TALISMAN"));
        }
    }

    @EventHandler
    public void onEnchant(EnchantItemEvent e) {
        Collection<Object> enchantments;
        if (Talisman.checkFor((Event)e, SlimefunItem.getByID("MAGICIAN_TALISMAN"))) {
            enchantments = new ArrayList();
            for (Enchantment en : Enchantment.values()) {
                for (int i = 1; i <= en.getMaxLevel(); ++i) {
                    if (!((Boolean)Slimefun.getItemValue("MAGICIAN_TALISMAN", "allow-enchantments." + en.getKey().getKey() + ".level." + i)).booleanValue() || !en.canEnchantItem(e.getItem())) continue;
                    enchantments.add(en.getKey().getKey() + "-" + i);
                }
            }
            String enchant = (String)enchantments.get(SlimefunStartup.randomize(enchantments.size()));
            e.getEnchantsToAdd().put(Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchant.split("-")[0])), Integer.parseInt(enchant.split("-")[1]));
        }
        if (!e.getEnchantsToAdd().containsKey(Enchantment.SILK_TOUCH) && Enchantment.LOOT_BONUS_BLOCKS.canEnchantItem(e.getItem()) && Talisman.checkFor((Event)e, SlimefunItem.getByID("WIZARD_TALISMAN"))) {
            if (e.getEnchantsToAdd().containsKey(Enchantment.LOOT_BONUS_BLOCKS)) {
                e.getEnchantsToAdd().remove(Enchantment.LOOT_BONUS_BLOCKS);
            }
            enchantments = e.getEnchantsToAdd().keySet();
            for (Enchantment enchantment : enchantments) {
                if (!SlimefunStartup.chance(100, 40)) continue;
                e.getEnchantsToAdd().put(enchantment, SlimefunStartup.randomize(3) + 1);
            }
            e.getItem().addUnsafeEnchantment(Enchantment.LOOT_BONUS_BLOCKS, SlimefunStartup.randomize(3) + 3);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        List<CustomItem> drops = new ArrayList();
        ItemStack item = e.getPlayer().getInventory().getItemInMainHand();
        int fortune = 1;
        if (item != null) {
            if (item.getEnchantments().containsKey(Enchantment.LOOT_BONUS_BLOCKS) && !item.getEnchantments().containsKey(Enchantment.SILK_TOUCH)) {
                fortune = SlimefunStartup.randomize(item.getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS) + 2) - 1;
                if (fortune <= 0) {
                    fortune = 1;
                }
                fortune = (e.getBlock().getType() == Material.LAPIS_ORE ? 4 + SlimefunStartup.randomize(5) : 1) * (fortune + 1);
            }
            if (!item.getEnchantments().containsKey(Enchantment.SILK_TOUCH) && e.getBlock().getType().toString().endsWith("_ORE") && Talisman.checkFor((Event)e, SlimefunItem.getByID("MINER_TALISMAN"))) {
                if (drops.isEmpty()) {
                    drops = (List)e.getBlock().getDrops();
                }
                for (ItemStack drop : new ArrayList(drops)) {
                    if (drop.getType().isBlock()) continue;
                    drops.add(new CustomItem(drop, fortune * 2));
                }
            }
        }
    }
}

