/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.listeners;

import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.handlers.BowShootHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.handlers.ItemHandler;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import me.mrCookieSlime.Slimefun.Utilities;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class BowListener
implements Listener {
    private Utilities utilities;

    public BowListener(SlimefunStartup plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.utilities = plugin.getUtilities();
    }

    @EventHandler
    public void onBowUse(EntityShootBowEvent e) {
        if (!(e.getEntity() instanceof Player) || !(e.getProjectile() instanceof Arrow)) {
            return;
        }
        if (SlimefunItem.getByItem(e.getBow()) != null) {
            this.utilities.arrows.put(e.getProjectile().getUniqueId(), e.getBow());
        }
    }

    @EventHandler
    public void onArrowHit(ProjectileHitEvent e) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, () -> {
            if (!e.getEntity().isValid()) {
                return;
            }
            if (this.utilities.arrows.containsKey(e.getEntity().getUniqueId())) {
                this.utilities.arrows.remove(e.getEntity().getUniqueId());
            }
            if (e.getEntity() instanceof Arrow) {
                this.handleGrapplingHook((Arrow)e.getEntity());
            }
        }, 4L);
    }

    private void handleGrapplingHook(Arrow arrow) {
        if (arrow != null && arrow.getShooter() instanceof Player && this.utilities.jumpState.containsKey(((Player)arrow.getShooter()).getUniqueId())) {
            Player p = (Player)arrow.getShooter();
            if (p.getGameMode() != GameMode.CREATIVE && this.utilities.jumpState.get(p.getUniqueId()).booleanValue()) {
                arrow.getWorld().dropItem(arrow.getLocation(), SlimefunItem.getItem("GRAPPLING_HOOK"));
            }
            if (p.getLocation().distance(arrow.getLocation()) < 3.0) {
                if (arrow.getLocation().getY() > p.getLocation().getY()) {
                    p.setVelocity(new Vector(0.0, 0.25, 0.0));
                } else {
                    p.setVelocity(arrow.getLocation().toVector().subtract(p.getLocation().toVector()));
                }
                for (Entity n : this.utilities.remove.get(p.getUniqueId())) {
                    n.remove();
                }
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, () -> {
                    this.utilities.jumpState.remove(p.getUniqueId());
                    this.utilities.remove.remove(p.getUniqueId());
                }, 20L);
            } else {
                double d;
                Location l = p.getLocation();
                l.setY(l.getY() + 0.5);
                p.teleport(l);
                double g = -0.08;
                double t = d = arrow.getLocation().distance(l);
                double v_x = (1.0 + 0.08000000000000002 * t) * (arrow.getLocation().getX() - l.getX()) / t;
                double v_y = (1.0 + 0.04 * t) * (arrow.getLocation().getY() - l.getY()) / t - 0.5 * g * t;
                double v_z = (1.0 + 0.08000000000000002 * t) * (arrow.getLocation().getZ() - l.getZ()) / t;
                Vector v = p.getVelocity();
                v.setX(v_x);
                v.setY(v_y);
                v.setZ(v_z);
                p.setVelocity(v);
                for (Entity n : this.utilities.remove.get(p.getUniqueId())) {
                    n.remove();
                }
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, () -> {
                    this.utilities.jumpState.remove(p.getUniqueId());
                    this.utilities.remove.remove(p.getUniqueId());
                }, 20L);
            }
        }
    }

    @EventHandler
    public void onArrowSuccessfulHit(EntityDamageByEntityEvent e) {
        if (e.getDamager() instanceof Arrow) {
            if (this.utilities.arrows.containsKey(e.getDamager().getUniqueId()) && e.getEntity() instanceof LivingEntity) {
                for (ItemHandler handler : SlimefunItem.getHandlers("BowShootHandler")) {
                    if (((BowShootHandler)handler).onHit(e, (LivingEntity)e.getEntity())) break;
                }
                this.utilities.arrows.remove(e.getDamager().getUniqueId());
            }
            this.handleGrapplingHook((Arrow)e.getDamager());
        }
    }
}

