/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.inventory;

import java.io.File;
import java.util.ArrayList;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.inventory.ItemManipulationEvent;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BlockMenu
extends DirtyChestMenu {
    private BlockMenuPreset preset;
    private Location l;
    private ItemManipulationEvent event;

    private static String serializeLocation(Location l) {
        return l.getWorld().getName() + ";" + l.getBlockX() + ";" + l.getBlockY() + ";" + l.getBlockZ();
    }

    public BlockMenu(BlockMenuPreset preset, Location l) {
        super(preset.getTitle());
        this.preset = preset;
        this.l = l;
        this.changes = 1;
        preset.clone(this);
        this.getContents();
    }

    public BlockMenu(BlockMenuPreset preset, Location l, Config cfg) {
        super(preset.getTitle());
        this.preset = preset;
        this.l = l;
        for (int i = 0; i < 54; ++i) {
            if (!cfg.contains(String.valueOf(i))) continue;
            this.addItem(i, cfg.getItem(String.valueOf(i)));
        }
        preset.clone(this);
        if (preset.getSize() > -1 && !preset.getPresetSlots().contains(preset.getSize() - 1) && cfg.contains(String.valueOf(preset.getSize() - 1))) {
            this.addItem(preset.getSize() - 1, cfg.getItem(String.valueOf(preset.getSize() - 1)));
        }
        this.getContents();
    }

    public void registerEvent(ItemManipulationEvent event) {
        this.event = event;
    }

    public void save(Location l) {
        if (!this.isDirty()) {
            return;
        }
        this.getContents();
        File file = new File("data-storage/Slimefun/stored-inventories/" + BlockMenu.serializeLocation(l) + ".sfi");
        Config cfg = new Config(file);
        cfg.setValue("preset", (Object)this.preset.getID());
        for (int slot : this.preset.getInventorySlots()) {
            cfg.setValue(String.valueOf(slot), (Object)this.getItemInSlot(slot));
        }
        cfg.save();
        this.changes = 0;
    }

    @Deprecated
    public void move(Block b) {
        this.move(b.getLocation());
    }

    public void move(Location l) {
        this.delete(this.l);
        this.l = l;
        this.preset.newInstance(this, l);
        this.save(l);
    }

    public Block getBlock() {
        return this.l.getBlock();
    }

    public Location getLocation() {
        return this.l;
    }

    public void delete(Location l) {
        new File("data-storage/Slimefun/stored-inventories/" + BlockMenu.serializeLocation(l) + ".sfi").delete();
    }

    public BlockMenuPreset getPreset() {
        return this.preset;
    }

    public boolean canOpen(Block b, Player p) {
        return this.preset.canOpen(b, p);
    }

    public void replaceExistingItem(int slot, ItemStack item) {
        this.replaceExistingItem(slot, item, true);
    }

    public void replaceExistingItem(int slot, ItemStack item, boolean event) {
        ItemStack previous = this.getItemInSlot(slot);
        if (event && this.event != null) {
            item = this.event.onEvent(slot, previous, item);
        }
        super.replaceExistingItem(slot, item);
        this.markDirty();
    }

    public void close() {
        for (HumanEntity human : new ArrayList(this.toInventory().getViewers())) {
            human.closeInventory();
        }
    }
}

