/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import me.mrCookieSlime.CSCoreLibPlugin.CSCoreLib;
import me.mrCookieSlime.CSCoreLibPlugin.general.Clock;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.TickerTask;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class ErrorReport {
    private File file;

    public ErrorReport(TickerTask task, Location l, SlimefunItem item, Exception x) {
        int try_count = 1;
        this.file = new File("plugins/Slimefun/error-reports/" + Clock.getFormattedTime() + ".err");
        while (this.file.exists()) {
            this.file = new File("plugins/Slimefun/error-reports/" + Clock.getFormattedTime() + "(" + ++try_count + ").err");
        }
        try {
            PrintStream stream = new PrintStream(this.file);
            stream.println();
            stream.println("Java Environment:");
            stream.println("  Operating System: " + System.getProperty("os.name"));
            stream.println("  Java Version: " + System.getProperty("java.version"));
            stream.println();
            stream.println("Server Software: " + Bukkit.getName());
            stream.println("  Build: " + Bukkit.getVersion());
            stream.println("  Minecraft: " + Bukkit.getBukkitVersion());
            stream.println();
            stream.println("Slimefun Environment:");
            stream.println("  CS-CoreLib v" + CSCoreLib.getLib().getDescription().getVersion());
            stream.println("  Slimefun v" + SlimefunStartup.instance.getDescription().getVersion());
            stream.println();
            ArrayList<String> plugins = new ArrayList<String>();
            ArrayList<String> addons = new ArrayList<String>();
            for (Plugin p : Bukkit.getPluginManager().getPlugins()) {
                if (Bukkit.getPluginManager().isPluginEnabled(p)) {
                    plugins.add("  + " + p.getName() + " " + p.getDescription().getVersion());
                    if (!p.getDescription().getDepend().contains("Slimefun") && !p.getDescription().getSoftDepend().contains("Slimefun")) continue;
                    addons.add("  + " + p.getName() + " " + p.getDescription().getVersion());
                    continue;
                }
                plugins.add("  - " + p.getName() + " " + p.getDescription().getVersion());
                if (!p.getDescription().getDepend().contains("Slimefun") && !p.getDescription().getSoftDepend().contains("Slimefun")) continue;
                addons.add("  - " + p.getName() + " " + p.getDescription().getVersion());
            }
            stream.println("Installed Addons (" + addons.size() + ")");
            addons.forEach(stream::println);
            stream.println();
            stream.println("Installed Plugins (" + plugins.size() + "):");
            plugins.forEach(stream::println);
            stream.println();
            stream.println("Block Info:");
            stream.println("  World: " + l.getWorld().getName());
            stream.println("  X: " + l.getBlockX());
            stream.println("  Y: " + l.getBlockY());
            stream.println("  Z: " + l.getBlockZ());
            stream.println("  Material: " + l.getBlock().getType());
            stream.println("  State: " + l.getBlock().getState().getClass().getName());
            stream.println();
            stream.println("Ticker-Info:");
            stream.println("  Type: " + (item.getBlockTicker().isSynchronized() ? "Synchronized" : "Asynchronous"));
            stream.println("  Object Dump: " + task.toString());
            stream.println();
            stream.println("Slimefun Data:");
            stream.println("  ID: " + item.getID());
            stream.println("  Inventory: " + BlockStorage.getStorage(l.getWorld()).hasInventory(l));
            stream.println("  Data: " + BlockStorage.getBlockInfoAsJson(l));
            stream.println();
            stream.println("Stacktrace:");
            stream.println();
            x.printStackTrace(stream);
            stream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public File getFile() {
        return this.file;
    }
}

