/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.Research;

public class PlayerProfile {
    public static Map<UUID, PlayerProfile> profiles = new HashMap<UUID, PlayerProfile>();
    private UUID uuid;
    private Config cfg;
    private boolean dirty = false;
    private boolean markedForDeletion = false;
    private Set<Research> researches = new HashSet<Research>();

    private PlayerProfile(UUID uuid) {
        this.uuid = uuid;
        this.cfg = new Config(new File("data-storage/Slimefun/Players/" + uuid.toString() + ".yml"));
        for (Research research : Research.list()) {
            if (!this.cfg.contains("researches." + research.getID())) continue;
            this.researches.add(research);
        }
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void save() {
        this.cfg.save();
        this.dirty = false;
    }

    public void setResearched(Research research, boolean unlock) {
        this.dirty = true;
        if (unlock) {
            this.cfg.setValue("researches." + research.getID(), (Object)true);
            this.researches.add(research);
        } else {
            this.cfg.setValue("researches." + research.getID(), null);
            this.researches.remove(research);
        }
    }

    public boolean hasUnlocked(Research research) {
        return !research.isEnabled() || this.researches.contains(research);
    }

    public Set<Research> getResearches() {
        return this.researches;
    }

    public void markForDeletion() {
        this.markedForDeletion = true;
    }

    public static PlayerProfile fromUUID(UUID uuid) {
        PlayerProfile profile = profiles.get(uuid);
        if (profile == null) {
            profile = new PlayerProfile(uuid);
            profiles.put(uuid, profile);
        } else {
            profile.markedForDeletion = false;
        }
        return profile;
    }

    public static boolean isLoaded(UUID uuid) {
        return profiles.containsKey(uuid);
    }

    public static Iterator<PlayerProfile> iterator() {
        return profiles.values().iterator();
    }
}

