/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines;

import java.util.HashMap;
import java.util.Map;
import me.mrCookieSlime.CSCoreLibPlugin.CSCoreLib;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunBlockHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.UnregisterReason;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AReactor;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ReactorAccessPort
extends SlimefunItem {
    private static final int[] border = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 12, 13, 14, 21, 23};
    private static final int[] border_1 = new int[]{9, 10, 11, 18, 20, 27, 29, 36, 38, 45, 46, 47};
    private static final int[] border_2 = new int[]{15, 16, 17, 24, 26, 33, 35, 42, 44, 51, 52, 53};
    private static final int[] border_3 = new int[]{30, 31, 32, 39, 41, 48, 49, 50};

    public ReactorAccessPort(Category category, ItemStack item, String name, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, name, recipeType, recipe);
        new BlockMenuPreset(name, this.getInventoryTitle()){

            @Override
            public void init() {
                ReactorAccessPort.this.constructMenu(this);
            }

            @Override
            public void newInstance(BlockMenu menu, Block b) {
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                AReactor reactor;
                if ((p.hasPermission("slimefun.inventory.bypass") || CSCoreLib.getLib().getProtectionManager().canAccessChest(p.getUniqueId(), b, true)) && (reactor = ReactorAccessPort.this.getReactor(b.getLocation())) != null) {
                    boolean empty = true;
                    BlockMenu bm = ReactorAccessPort.this.getReactorMenu(b.getLocation());
                    if (bm != null) {
                        for (int slot : reactor.getCoolantSlots()) {
                            if (bm.getItemInSlot(slot) == null) continue;
                            empty = false;
                        }
                        for (int slot : reactor.getFuelSlots()) {
                            if (bm.getItemInSlot(slot) == null) continue;
                            empty = false;
                        }
                        if (!empty || !p.isSneaking()) {
                            bm.open(new Player[]{p});
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow.equals((Object)ItemTransportFlow.INSERT)) {
                    return ReactorAccessPort.this.getInputSlots();
                }
                return ReactorAccessPort.getOutputSlots();
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(BlockMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow.equals((Object)ItemTransportFlow.INSERT)) {
                    if (SlimefunManager.isItemSimiliar(item, SlimefunItems.REACTOR_COOLANT_CELL, true)) {
                        return ReactorAccessPort.this.getCoolantSlots();
                    }
                    if (SlimefunManager.isItemSimiliar(item, SlimefunItems.NETHER_ICE_COOLANT_CELL, true)) {
                        return ReactorAccessPort.this.getCoolantSlots();
                    }
                    return ReactorAccessPort.this.getFuelSlots();
                }
                return ReactorAccessPort.getOutputSlots();
            }
        };
        ReactorAccessPort.registerBlockHandler(name, new SlimefunBlockHandler(){

            @Override
            public void onPlace(Player p, Block b, SlimefunItem item) {
            }

            @Override
            public boolean onBreak(Player p, Block b, SlimefunItem item, UnregisterReason reason) {
                BlockMenu inv = BlockStorage.getInventory(b);
                if (inv != null) {
                    for (int slot : ReactorAccessPort.this.getFuelSlots()) {
                        if (inv.getItemInSlot(slot) == null) continue;
                        b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                        inv.replaceExistingItem(slot, null);
                    }
                    for (int slot : ReactorAccessPort.this.getCoolantSlots()) {
                        if (inv.getItemInSlot(slot) == null) continue;
                        b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                        inv.replaceExistingItem(slot, null);
                    }
                    for (int slot : ReactorAccessPort.getOutputSlots()) {
                        if (inv.getItemInSlot(slot) == null) continue;
                        b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                        inv.replaceExistingItem(slot, null);
                    }
                }
                return true;
            }
        });
    }

    private void constructMenu(BlockMenuPreset preset) {
        for (int i : border) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " "), (p, slot, item, action) -> false);
        }
        for (int i : border_1) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.LIME_STAINED_GLASS_PANE), " "), (p, slot, item, action) -> false);
        }
        for (int i : border_2) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.CYAN_STAINED_GLASS_PANE), " "), (p, slot, item, action) -> false);
        }
        for (int i : border_3) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.GREEN_STAINED_GLASS_PANE), " "), (p, slot, item, action) -> false);
        }
        preset.addItem(1, (ItemStack)new CustomItem(SlimefunItems.URANIUM, "&7Fuel Slot", new String[]{"", "&rThis Slot accepts radioactive Fuel such as:", "&2Uranium &ror &aNeptunium"}), (p, slot, item, action) -> false);
        preset.addItem(22, (ItemStack)new CustomItem(SlimefunItems.PLUTONIUM, "&7Byproduct Slot", new String[]{"", "&rThis Slot contains the Reactor's Byproduct", "&rsuch as &aNeptunium &ror &7Plutonium"}), (p, slot, item, action) -> false);
        preset.addItem(7, (ItemStack)new CustomItem(SlimefunItems.REACTOR_COOLANT_CELL, "&bCoolant Slot", new String[]{"", "&rThis Slot accepts Coolant Cells", "&4Without any Coolant Cells, your Reactor", "&4will explode"}), (p, slot, item, action) -> false);
        preset.addItem(7, (ItemStack)new CustomItem(SlimefunItems.REACTOR_COOLANT_CELL, "&bCoolant Slot", new String[]{"", "&rThis Slot accepts Coolant Cells", "&4Without any Coolant Cells, your Reactor", "&4will explode"}), (p, slot, item, action) -> false);
    }

    public String getInventoryTitle() {
        return "&2Reactor Access Port";
    }

    public int[] getInputSlots() {
        return new int[]{19, 28, 37, 25, 34, 43};
    }

    public int[] getFuelSlots() {
        return new int[]{19, 28, 37};
    }

    public int[] getCoolantSlots() {
        return new int[]{25, 34, 43};
    }

    public static int[] getOutputSlots() {
        return new int[]{40};
    }

    public AReactor getReactor(Location l) {
        Location reactorL = new Location(l.getWorld(), l.getX(), l.getY() - 3.0, l.getZ());
        SlimefunItem item = BlockStorage.check(reactorL.getBlock());
        if (item instanceof AReactor) {
            return (AReactor)item;
        }
        return null;
    }

    public BlockMenu getReactorMenu(Location l) {
        Location reactorL = new Location(l.getWorld(), l.getX(), l.getY() - 3.0, l.getZ());
        String id = BlockStorage.checkID(reactorL);
        if (id.equals("NUCLEAR_REACTOR") || id.equals("NETHERSTAR_REACTOR")) {
            return BlockStorage.getInventory(reactorL);
        }
        return null;
    }

    private static Inventory inject(Location l) {
        int size = BlockStorage.getInventory(l).toInventory().getSize();
        Inventory inv = Bukkit.createInventory(null, (int)size);
        for (int i = 0; i < size; ++i) {
            inv.setItem(i, (ItemStack)new CustomItem(Material.COMMAND_BLOCK, " &4ALL YOUR PLACEHOLDERS ARE BELONG TO US", new String[0]));
        }
        for (int slot : ReactorAccessPort.getOutputSlots()) {
            inv.setItem(slot, BlockStorage.getInventory(l).getItemInSlot(slot));
        }
        return inv;
    }

    public static ItemStack pushItems(Location l, ItemStack item) {
        Inventory inv = ReactorAccessPort.inject(l);
        HashMap map = inv.addItem(new ItemStack[]{item});
        for (int slot : ReactorAccessPort.getOutputSlots()) {
            BlockStorage.getInventory(l).replaceExistingItem(slot, inv.getItem(slot));
        }
        Object object = map.entrySet().iterator();
        if (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            return (ItemStack)entry.getValue();
        }
        return null;
    }
}

