/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.mrCookieSlime.CSCoreLibPlugin.CSCoreLib;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.InvUtils;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineHelper;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.api.item_transport.RecipeSorter;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;

public abstract class HeatedPressureChamber
extends AContainer {
    public HeatedPressureChamber(Category category, ItemStack item, String name, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, name, recipeType, recipe);
        new BlockMenuPreset(name, this.getInventoryTitle()){

            @Override
            public void init() {
                HeatedPressureChamber.this.constructMenu(this);
            }

            @Override
            public void newInstance(BlockMenu menu, Block b) {
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || CSCoreLib.getLib().getProtectionManager().canAccessChest(p.getUniqueId(), b, true);
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(BlockMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow.equals((Object)ItemTransportFlow.WITHDRAW)) {
                    return HeatedPressureChamber.this.getOutputSlots();
                }
                ArrayList<Integer> slots = new ArrayList<Integer>();
                for (int slot : HeatedPressureChamber.this.getInputSlots()) {
                    if (!SlimefunManager.isItemSimiliar(menu.getItemInSlot(slot), item, true)) continue;
                    slots.add(slot);
                }
                if (slots.isEmpty()) {
                    return HeatedPressureChamber.this.getInputSlots();
                }
                Collections.sort(slots, new RecipeSorter(menu));
                return ArrayUtils.toPrimitive((Integer[])slots.toArray(new Integer[slots.size()]));
            }
        };
        this.registerDefaultRecipes();
    }

    @Override
    public void registerDefaultRecipes() {
        this.registerRecipe(45, new ItemStack[]{SlimefunItems.BUCKET_OF_OIL}, new ItemStack[]{new CustomItem(SlimefunItems.PLASTIC_SHEET, 8)});
        this.registerRecipe(30, new ItemStack[]{SlimefunItems.GOLD_24K, SlimefunItems.URANIUM}, new ItemStack[]{SlimefunItems.BLISTERING_INGOT});
        this.registerRecipe(30, new ItemStack[]{SlimefunItems.BLISTERING_INGOT, SlimefunItems.CARBONADO}, new ItemStack[]{SlimefunItems.BLISTERING_INGOT_2});
        this.registerRecipe(60, new ItemStack[]{SlimefunItems.BLISTERING_INGOT_2, new ItemStack(Material.NETHER_STAR)}, new ItemStack[]{SlimefunItems.BLISTERING_INGOT_3});
        this.registerRecipe(90, new ItemStack[]{SlimefunItems.PLUTONIUM, SlimefunItems.URANIUM}, new ItemStack[]{SlimefunItems.BOOSTED_URANIUM});
        this.registerRecipe(60, new ItemStack[]{SlimefunItems.NETHER_ICE, SlimefunItems.PLUTONIUM}, new ItemStack[]{new CustomItem(SlimefunItems.ENRICHED_NETHER_ICE, 4)});
        this.registerRecipe(45, new ItemStack[]{SlimefunItems.ENRICHED_NETHER_ICE}, new ItemStack[]{new CustomItem(SlimefunItems.NETHER_ICE_COOLANT_CELL, 8)});
    }

    @Override
    public String getInventoryTitle() {
        return "&cHeated Pressure Chamber";
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.FLINT_AND_STEEL);
    }

    @Override
    public int[] getInputSlots() {
        return new int[]{19, 20};
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{24, 25};
    }

    @Override
    public void register(boolean slimefun) {
        this.addItemHandler(new BlockTicker(){

            @Override
            public void tick(Block b, SlimefunItem sf, Config data) {
                HeatedPressureChamber.this.tick(b);
            }

            @Override
            public void uniqueTick() {
            }

            @Override
            public boolean isSynchronized() {
                return false;
            }
        });
        super.register(slimefun);
    }

    @Override
    protected void tick(Block b) {
        if (this.isProcessing(b)) {
            int timeleft = (Integer)progress.get(b);
            if (timeleft > 0) {
                ItemStack item = this.getProgressBar().clone();
                item.setDurability(MachineHelper.getDurability(item, timeleft, ((MachineRecipe)processing.get(b)).getTicks()));
                ItemMeta im = item.getItemMeta();
                im.setDisplayName(" ");
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(MachineHelper.getProgress(timeleft, ((MachineRecipe)processing.get(b)).getTicks()));
                arrayList.add("");
                arrayList.add(MachineHelper.getTimeLeft(timeleft / 2));
                im.setLore(arrayList);
                item.setItemMeta(im);
                BlockStorage.getInventory(b).replaceExistingItem(22, item);
                if (ChargableBlock.isChargable(b)) {
                    if (ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
                        return;
                    }
                    ChargableBlock.addCharge(b, -this.getEnergyConsumption());
                    progress.put(b, timeleft - 1);
                } else {
                    progress.put(b, timeleft - 1);
                }
            } else {
                BlockStorage.getInventory(b).replaceExistingItem(22, (ItemStack)new CustomItem(new MaterialData(Material.STAINED_GLASS_PANE, 15), " ", new String[0]));
                this.pushItems(b, ((MachineRecipe)processing.get(b)).getOutput());
                progress.remove(b);
                processing.remove(b);
            }
        } else {
            MachineRecipe r = null;
            HashMap<Integer, Integer> found = new HashMap<Integer, Integer>();
            for (MachineRecipe machineRecipe : this.recipes) {
                block1: for (ItemStack input : machineRecipe.getInput()) {
                    for (int slot : this.getInputSlots()) {
                        if (!SlimefunManager.isItemSimiliar(BlockStorage.getInventory(b).getItemInSlot(slot), input, true)) continue;
                        found.put(slot, input.getAmount());
                        continue block1;
                    }
                }
                if (found.size() == machineRecipe.getInput().length) {
                    r = machineRecipe;
                    break;
                }
                found.clear();
            }
            if (r != null) {
                if (!this.fits(b, r.getOutput())) {
                    return;
                }
                for (Map.Entry entry : found.entrySet()) {
                    BlockStorage.getInventory(b).replaceExistingItem((Integer)entry.getKey(), InvUtils.decreaseItem((ItemStack)BlockStorage.getInventory(b).getItemInSlot((Integer)entry.getKey()), (int)((Integer)entry.getValue())));
                }
                processing.put(b, r);
                progress.put(b, r.getTicks());
            }
        }
    }

    @Override
    public String getMachineIdentifier() {
        return "HEATED_PRESSURE_CHAMBER";
    }
}

