/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.dough.protection.modules;

import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.ProtectionModule;
import javax.annotation.Nonnull;
import net.william278.huskclaims.api.BukkitHuskClaimsAPI;
import net.william278.huskclaims.libraries.cloplib.operation.Operation;
import net.william278.huskclaims.libraries.cloplib.operation.OperationPosition;
import net.william278.huskclaims.libraries.cloplib.operation.OperationType;
import net.william278.huskclaims.libraries.cloplib.operation.OperationUser;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class HuskClaimsProtectionModule
implements ProtectionModule {
    private BukkitHuskClaimsAPI huskClaimsAPI;
    private final Plugin plugin;

    public HuskClaimsProtectionModule(@Nonnull Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void load() {
        this.huskClaimsAPI = BukkitHuskClaimsAPI.getInstance();
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public boolean hasPermission(OfflinePlayer p, Location l, Interaction action) {
        if (!p.isOnline()) {
            return false;
        }
        return this.huskClaimsAPI.isOperationAllowed(Operation.of((OperationUser)this.huskClaimsAPI.getOnlineUser(p.getPlayer()), (OperationType)this.getHuskClaimsAction(action), (OperationPosition)this.huskClaimsAPI.getPosition(l)));
    }

    @Nonnull
    public OperationType getHuskClaimsAction(@Nonnull Interaction doughAction) {
        switch (doughAction) {
            case BREAK_BLOCK: {
                return OperationType.BLOCK_BREAK;
            }
            case PLACE_BLOCK: {
                return OperationType.BLOCK_PLACE;
            }
            case ATTACK_ENTITY: {
                return OperationType.PLAYER_DAMAGE_ENTITY;
            }
            case ATTACK_PLAYER: {
                return OperationType.PLAYER_DAMAGE_PLAYER;
            }
            case INTERACT_BLOCK: {
                return OperationType.BLOCK_INTERACT;
            }
        }
        return OperationType.ENTITY_INTERACT;
    }
}

