/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.localization;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.SlimefunBranch;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.services.localization.Language;
import io.github.thebusybiscuit.slimefun4.core.services.localization.LanguageFile;
import io.github.thebusybiscuit.slimefun4.core.services.localization.LanguagePreset;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class SlimefunLocalization
implements Keyed {
    private final Config defaultConfig;

    protected SlimefunLocalization(@Nonnull Slimefun plugin) {
        this.defaultConfig = new Config((Plugin)plugin, "messages.yml");
    }

    @Nonnull
    protected Config getConfig() {
        return this.defaultConfig;
    }

    protected void save() {
        this.defaultConfig.save();
    }

    @Nonnull
    public String getChatPrefix() {
        return this.getMessage("prefix");
    }

    @Nullable
    public abstract Language getLanguage(@Nonnull String var1);

    @Nullable
    public abstract Language getLanguage(@Nonnull Player var1);

    @Nullable
    public abstract Language getDefaultLanguage();

    protected abstract boolean hasLanguage(@Nonnull String var1);

    @Nonnull
    public abstract Collection<Language> getLanguages();

    protected abstract void addLanguage(@Nonnull String var1, @Nonnull String var2);

    protected void loadEmbeddedLanguages() {
        for (LanguagePreset lang : LanguagePreset.values()) {
            if (!lang.isReadyForRelease() && Slimefun.getUpdater().getBranch() == SlimefunBranch.STABLE) continue;
            this.addLanguage(lang.getLanguageCode(), lang.getTexture());
        }
    }

    @Nonnull
    private FileConfiguration getDefaultFile(@Nonnull LanguageFile file) {
        Language language = this.getLanguage(LanguagePreset.ENGLISH.getLanguageCode());
        if (language == null) {
            throw new IllegalStateException("Fallback language \"en\" is missing!");
        }
        FileConfiguration fallback = language.getFile(file);
        if (fallback != null) {
            return fallback;
        }
        throw new IllegalStateException("Fallback file: \"" + file.getFilePath("en") + "\" is missing!");
    }

    @ParametersAreNonnullByDefault
    @Nullable
    private String getStringOrNull(@Nullable Language language, LanguageFile file, String path) {
        String value;
        Validate.notNull((Object)file, "You need to provide a LanguageFile!");
        Validate.notNull(path, "The path cannot be null!");
        if (language == null) {
            return "Error: No language present";
        }
        FileConfiguration config = language.getFile(file);
        if (config != null && (value = config.getString(path)) != null) {
            return value;
        }
        FileConfiguration defaults = this.getDefaultFile(file);
        String defaultValue = defaults.getString(path);
        return defaultValue != null ? defaultValue : null;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    private String getString(@Nullable Language language, LanguageFile file, String path) {
        String string = this.getStringOrNull(language, file, path);
        return string != null ? string : "! Missing string \"" + path + "\"";
    }

    @ParametersAreNonnullByDefault
    @Nullable
    private List<String> getStringListOrNull(@Nullable Language language, LanguageFile file, String path) {
        List value;
        Validate.notNull((Object)file, "You need to provide a LanguageFile!");
        Validate.notNull(path, "The path cannot be null!");
        if (language == null) {
            return Arrays.asList("Error: No language present");
        }
        FileConfiguration config = language.getFile(file);
        if (config != null && !(value = config.getStringList(path)).isEmpty()) {
            return value;
        }
        FileConfiguration defaults = this.getDefaultFile(file);
        List defaultValue = defaults.getStringList(path);
        return !defaultValue.isEmpty() ? defaultValue : null;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    private List<String> getStringList(@Nullable Language language, LanguageFile file, String path) {
        List<String> list = this.getStringListOrNull(language, file, path);
        return list != null ? list : Arrays.asList("! Missing string \"" + path + "\"");
    }

    @Nonnull
    public String getMessage(@Nonnull String key) {
        String message;
        Validate.notNull(key, "Message key must not be null!");
        Language language = this.getDefaultLanguage();
        String string = message = language == null ? null : language.getFile(LanguageFile.MESSAGES).getString(key);
        if (message == null) {
            return this.getDefaultFile(LanguageFile.MESSAGES).getString(key);
        }
        return message;
    }

    @Nonnull
    public String getMessage(@Nonnull Player p, @Nonnull String key) {
        Validate.notNull(p, "Player must not be null!");
        Validate.notNull(key, "Message key must not be null!");
        return this.getString(this.getLanguage(p), LanguageFile.MESSAGES, key);
    }

    @Nonnull
    public List<String> getDefaultMessages(@Nonnull String key) {
        return this.defaultConfig.getStringList(key);
    }

    @Nonnull
    public List<String> getMessages(@Nonnull Player p, @Nonnull String key) {
        Validate.notNull(p, "Player should not be null.");
        Validate.notNull(key, "Message key cannot be null.");
        return this.getStringList(this.getLanguage(p), LanguageFile.MESSAGES, key);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public List<String> getMessages(Player p, String key, UnaryOperator<String> function) {
        Validate.notNull(p, "Player cannot be null.");
        Validate.notNull(key, "Message key cannot be null.");
        Validate.notNull(function, "Function cannot be null.");
        List<String> messages = this.getMessages(p, key);
        messages.replaceAll(function);
        return messages;
    }

    @Nullable
    public String getResearchName(@Nonnull Player p, @Nonnull NamespacedKey key) {
        Validate.notNull(p, "Player must not be null.");
        Validate.notNull(key, "NamespacedKey cannot be null.");
        return this.getStringOrNull(this.getLanguage(p), LanguageFile.RESEARCHES, key.getNamespace() + "." + key.getKey());
    }

    @Nullable
    public String getItemGroupName(@Nonnull Player p, @Nonnull NamespacedKey key) {
        Validate.notNull(p, "Player must not be null.");
        Validate.notNull(key, "NamespacedKey cannot be null!");
        return this.getStringOrNull(this.getLanguage(p), LanguageFile.CATEGORIES, key.getNamespace() + "." + key.getKey());
    }

    @Nullable
    public String getResourceString(@Nonnull Player p, @Nonnull String key) {
        Validate.notNull(p, "Player should not be null!");
        Validate.notNull(key, "Message key should not be null!");
        return this.getStringOrNull(this.getLanguage(p), LanguageFile.RESOURCES, key);
    }

    @Nonnull
    public ItemStack getRecipeTypeItem(@Nonnull Player p, @Nonnull RecipeType recipeType) {
        Validate.notNull(p, "Player cannot be null!");
        Validate.notNull(recipeType, "Recipe type cannot be null!");
        ItemStack item = recipeType.toItem();
        if (item == null) {
            return new ItemStack(Material.AIR);
        }
        Language language = this.getLanguage(p);
        NamespacedKey key = recipeType.getKey();
        return new CustomItemStack(item, meta -> {
            List<String> lore;
            String displayName = this.getStringOrNull(language, LanguageFile.RECIPES, key.getNamespace() + "." + key.getKey() + ".name");
            if (displayName != null) {
                meta.setDisplayName(String.valueOf(ChatColor.AQUA) + displayName);
            }
            if ((lore = this.getStringListOrNull(language, LanguageFile.RECIPES, key.getNamespace() + "." + key.getKey() + ".lore")) != null) {
                lore.replaceAll(line -> String.valueOf(ChatColor.GRAY) + line);
                meta.setLore(lore);
            }
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        });
    }

    public void sendMessage(@Nonnull CommandSender recipient, @Nonnull String key, boolean addPrefix) {
        String prefix;
        Validate.notNull(recipient, "Recipient cannot be null!");
        Validate.notNull(key, "Message key cannot be null!");
        String string = prefix = addPrefix ? this.getChatPrefix() : "";
        if (recipient instanceof Player) {
            Player player = (Player)recipient;
            recipient.sendMessage(ChatColors.color(prefix + this.getMessage(player, key)));
        } else {
            recipient.sendMessage(ChatColor.stripColor((String)ChatColors.color(prefix + this.getMessage(key))));
        }
    }

    public void sendActionbarMessage(@Nonnull Player player, @Nonnull String key, boolean addPrefix) {
        Validate.notNull(player, "Player cannot be null!");
        Validate.notNull(key, "Message key cannot be null!");
        String prefix = addPrefix ? this.getChatPrefix() : "";
        String message = ChatColors.color(prefix + this.getMessage(player, key));
        BaseComponent[] components = TextComponent.fromLegacyText((String)message);
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, components);
    }

    public void sendMessage(@Nonnull CommandSender recipient, @Nonnull String key) {
        this.sendMessage(recipient, key, true);
    }

    @ParametersAreNonnullByDefault
    public void sendMessage(CommandSender recipient, String key, UnaryOperator<String> function) {
        this.sendMessage(recipient, key, true, function);
    }

    @ParametersAreNonnullByDefault
    public void sendMessage(CommandSender recipient, String key, boolean addPrefix, UnaryOperator<String> function) {
        String prefix;
        if (Slimefun.getMinecraftVersion() == MinecraftVersion.UNIT_TEST) {
            return;
        }
        String string = prefix = addPrefix ? this.getChatPrefix() : "";
        if (recipient instanceof Player) {
            Player player = (Player)recipient;
            recipient.sendMessage(ChatColors.color(prefix + (String)function.apply(this.getMessage(player, key))));
        } else {
            recipient.sendMessage(ChatColor.stripColor((String)ChatColors.color(prefix + (String)function.apply(this.getMessage(key)))));
        }
    }

    public void sendMessages(@Nonnull CommandSender recipient, @Nonnull String key) {
        String prefix = this.getChatPrefix();
        if (recipient instanceof Player) {
            Player player = (Player)recipient;
            for (String translation : this.getMessages(player, key)) {
                String message = ChatColors.color(prefix + translation);
                recipient.sendMessage(message);
            }
        } else {
            for (String translation : this.getDefaultMessages(key)) {
                String message = ChatColors.color(prefix + translation);
                recipient.sendMessage(ChatColor.stripColor((String)message));
            }
        }
    }

    @ParametersAreNonnullByDefault
    public void sendMessages(CommandSender recipient, String key, boolean addPrefix, UnaryOperator<String> function) {
        String prefix;
        String string = prefix = addPrefix ? this.getChatPrefix() : "";
        if (recipient instanceof Player) {
            Player player = (Player)recipient;
            for (String translation : this.getMessages(player, key)) {
                String message = ChatColors.color(prefix + (String)function.apply(translation));
                recipient.sendMessage(message);
            }
        } else {
            for (String translation : this.getDefaultMessages(key)) {
                String message = ChatColors.color(prefix + (String)function.apply(translation));
                recipient.sendMessage(ChatColor.stripColor((String)message));
            }
        }
    }

    @ParametersAreNonnullByDefault
    public void sendMessages(CommandSender recipient, String key, UnaryOperator<String> function) {
        this.sendMessages(recipient, key, true, function);
    }

    @Nonnull
    protected Set<String> getTotalKeys(@Nonnull Language lang) {
        return this.getKeys(lang.getFiles());
    }

    @Nonnull
    protected Set<String> getKeys(FileConfiguration ... files) {
        HashSet<String> keys = new HashSet<String>();
        for (FileConfiguration cfg : files) {
            keys.addAll(cfg.getKeys(true));
        }
        return keys;
    }
}

