/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.player.StatusEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import javax.annotation.Nonnull;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class RadiationUtils {
    private static final StatusEffect RADIATION_EFFECT = new StatusEffect(new NamespacedKey((Plugin)Slimefun.instance(), "radiation"));
    private static final int MAX_EXPOSURE_LEVEL = 100;

    public static void clearExposure(@Nonnull Player p) {
        Preconditions.checkNotNull((Object)p, (Object)"The player cannot be null");
        RADIATION_EFFECT.clear(p);
    }

    public static int getExposure(@Nonnull Player p) {
        Preconditions.checkNotNull((Object)p, (Object)"The player must not be null");
        return RADIATION_EFFECT.getLevel(p).orElse(0);
    }

    public static void addExposure(@Nonnull Player p, int exposure) {
        Preconditions.checkNotNull((Object)p, (Object)"The player cannot be null");
        int level = Math.min(RADIATION_EFFECT.getLevel(p).orElse(0) + exposure, 100);
        RADIATION_EFFECT.addPermanent(p, level);
    }

    public static void removeExposure(@Nonnull Player p, int exposure) {
        Preconditions.checkNotNull((Object)p, (Object)"The player should not be null");
        int level = Math.max(RADIATION_EFFECT.getLevel(p).orElse(0) - exposure, 0);
        RADIATION_EFFECT.addPermanent(p, level);
    }
}

