/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.resources;

import com.google.gson.JsonElement;
import io.github.thebusybiscuit.slimefun4.api.exceptions.BiomeMapException;
import io.github.thebusybiscuit.slimefun4.api.geo.GEOResource;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.utils.biomes.BiomeMap;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

abstract class AbstractResource
implements GEOResource {
    private final NamespacedKey key;
    private final String defaultName;
    private final ItemStack item;
    private final int maxDeviation;
    private final boolean geoMiner;

    @ParametersAreNonnullByDefault
    AbstractResource(String key, String defaultName, ItemStack item, int maxDeviation, boolean geoMiner) {
        Validate.notNull(key, "NamespacedKey cannot be null!");
        Validate.notNull(defaultName, "The default name cannot be null!");
        Validate.notNull(item, "item cannot be null!");
        this.key = new NamespacedKey((Plugin)Slimefun.instance(), key);
        this.defaultName = defaultName;
        this.item = item;
        this.maxDeviation = maxDeviation;
        this.geoMiner = geoMiner;
    }

    @Nonnull
    public NamespacedKey getKey() {
        return this.key;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.defaultName;
    }

    @Override
    @Nonnull
    public ItemStack getItem() {
        return this.item.clone();
    }

    @Override
    public int getMaxDeviation() {
        return this.maxDeviation;
    }

    @Override
    public boolean isObtainableFromGEOMiner() {
        return this.geoMiner;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    static final BiomeMap<Integer> getBiomeMap(AbstractResource resource, String path) {
        Validate.notNull(resource, "Resource cannot be null.");
        Validate.notNull(path, "Path cannot be null.");
        try {
            return BiomeMap.fromResource(resource.getKey(), Slimefun.instance(), path, JsonElement::getAsInt);
        }
        catch (BiomeMapException x) {
            if (Slimefun.instance().isUnitTest()) {
                throw new IllegalStateException(x);
            }
            Slimefun.logger().log(Level.WARNING, x, () -> "Failed to load BiomeMap for GEO-resource: " + String.valueOf(resource.getKey()));
            return new BiomeMap<Integer>(resource.getKey());
        }
    }
}

