/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotHopperable;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.inventory.InvUtils;
import io.github.thebusybiscuit.slimefun4.utils.compatibility.VersionedPotionType;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public class AutoBrewer
extends AContainer
implements NotHopperable {
    private static final Map<Material, PotionType> potionRecipes = new EnumMap<Material, PotionType>(Material.class);
    private static final Map<PotionType, PotionType> fermentations = new EnumMap<PotionType, PotionType>(PotionType.class);

    @ParametersAreNonnullByDefault
    public AutoBrewer(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Override
    @Nullable
    protected MachineRecipe findNextRecipe(BlockMenu menu) {
        ItemStack input1 = menu.getItemInSlot(this.getInputSlots()[0]);
        ItemStack input2 = menu.getItemInSlot(this.getInputSlots()[1]);
        if (input1 == null || input2 == null) {
            return null;
        }
        if (this.isPotion(input1.getType()) || this.isPotion(input2.getType())) {
            ItemStack ingredient;
            boolean isPotionInFirstSlot = this.isPotion(input1.getType());
            ItemStack itemStack = ingredient = isPotionInFirstSlot ? input2 : input1;
            if (ingredient.hasItemMeta()) {
                return null;
            }
            ItemStack potionItem = isPotionInFirstSlot ? input1 : input2;
            PotionMeta potion = (PotionMeta)potionItem.getItemMeta();
            ItemStack output = this.brew(ingredient.getType(), potionItem.getType(), potion);
            if (output == null) {
                return null;
            }
            output.setItemMeta((ItemMeta)potion);
            if (!InvUtils.fits(menu.toInventory(), output, this.getOutputSlots())) {
                return null;
            }
            for (int slot : this.getInputSlots()) {
                menu.consumeItem(slot);
            }
            return new MachineRecipe(30, new ItemStack[]{input1, input2}, new ItemStack[]{output});
        }
        return null;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    private ItemStack brew(Material input, Material potionType, PotionMeta potion) {
        if (Slimefun.getMinecraftVersion().isBefore(20, 2)) {
            return this.brewPreBasePotionType(input, potionType, potion);
        }
        PotionType type = potion.getBasePotionType();
        if (type == PotionType.WATER) {
            if (input == Material.FERMENTED_SPIDER_EYE) {
                potion.setBasePotionType(PotionType.WEAKNESS);
                return new ItemStack(potionType);
            }
            if (input == Material.NETHER_WART) {
                potion.setBasePotionType(PotionType.AWKWARD);
                return new ItemStack(potionType);
            }
            if (potionType == Material.POTION && input == Material.GUNPOWDER) {
                return new ItemStack(Material.SPLASH_POTION);
            }
            if (potionType == Material.SPLASH_POTION && input == Material.DRAGON_BREATH) {
                return new ItemStack(Material.LINGERING_POTION);
            }
        } else if (input == Material.FERMENTED_SPIDER_EYE) {
            PotionType fermented = fermentations.get(type);
            if (fermented != null) {
                potion.setBasePotionType(fermented);
                return new ItemStack(potionType);
            }
        } else {
            PotionType potionRecipe;
            if (input == Material.REDSTONE && type.isExtendable() && !type.isUpgradeable()) {
                potion.setBasePotionType(type);
                return new ItemStack(potionType);
            }
            if (input == Material.GLOWSTONE_DUST && type.isUpgradeable() && !type.isExtendable()) {
                potion.setBasePotionType(type);
                return new ItemStack(potionType);
            }
            if (type == PotionType.AWKWARD && (potionRecipe = potionRecipes.get(input)) != null) {
                potion.setBasePotionType(potionRecipe);
                return new ItemStack(potionType);
            }
        }
        return null;
    }

    @ParametersAreNonnullByDefault
    private ItemStack brewPreBasePotionType(Material input, Material potionType, PotionMeta potion) {
        PotionData data = potion.getBasePotionData();
        PotionType type = data.getType();
        if (type == PotionType.WATER) {
            if (input == Material.FERMENTED_SPIDER_EYE) {
                potion.setBasePotionData(new PotionData(PotionType.WEAKNESS, false, false));
                return new ItemStack(potionType);
            }
            if (input == Material.NETHER_WART) {
                potion.setBasePotionData(new PotionData(PotionType.AWKWARD, false, false));
                return new ItemStack(potionType);
            }
            if (potionType == Material.POTION && input == Material.GUNPOWDER) {
                return new ItemStack(Material.SPLASH_POTION);
            }
            if (potionType == Material.SPLASH_POTION && input == Material.DRAGON_BREATH) {
                return new ItemStack(Material.LINGERING_POTION);
            }
        } else if (input == Material.FERMENTED_SPIDER_EYE) {
            PotionType fermented = fermentations.get(type);
            if (fermented != null) {
                potion.setBasePotionData(new PotionData(fermented, data.isExtended(), data.isUpgraded()));
                return new ItemStack(potionType);
            }
        } else {
            PotionType potionRecipe;
            if (input == Material.REDSTONE && type.isExtendable() && !data.isUpgraded()) {
                potion.setBasePotionData(new PotionData(type, true, false));
                return new ItemStack(potionType);
            }
            if (input == Material.GLOWSTONE_DUST && type.isUpgradeable() && !data.isExtended()) {
                potion.setBasePotionData(new PotionData(type, false, true));
                return new ItemStack(potionType);
            }
            if (type == PotionType.AWKWARD && (potionRecipe = potionRecipes.get(input)) != null) {
                potion.setBasePotionData(new PotionData(potionRecipe, false, false));
                return new ItemStack(potionType);
            }
        }
        return null;
    }

    private boolean isPotion(@Nonnull Material mat) {
        return mat == Material.POTION || mat == Material.SPLASH_POTION || mat == Material.LINGERING_POTION;
    }

    @Override
    @Nonnull
    public ItemStack getProgressBar() {
        return new ItemStack(Material.FISHING_ROD);
    }

    @Override
    @Nonnull
    public String getMachineIdentifier() {
        return "AUTO_BREWER";
    }

    static {
        potionRecipes.put(Material.SUGAR, VersionedPotionType.SWIFTNESS);
        potionRecipes.put(Material.RABBIT_FOOT, VersionedPotionType.LEAPING);
        potionRecipes.put(Material.BLAZE_POWDER, PotionType.STRENGTH);
        potionRecipes.put(Material.GLISTERING_MELON_SLICE, VersionedPotionType.HEALING);
        potionRecipes.put(Material.SPIDER_EYE, PotionType.POISON);
        potionRecipes.put(Material.GHAST_TEAR, VersionedPotionType.REGENERATION);
        potionRecipes.put(Material.MAGMA_CREAM, PotionType.FIRE_RESISTANCE);
        potionRecipes.put(Material.PUFFERFISH, PotionType.WATER_BREATHING);
        potionRecipes.put(Material.GOLDEN_CARROT, PotionType.NIGHT_VISION);
        potionRecipes.put(Material.TURTLE_HELMET, PotionType.TURTLE_MASTER);
        potionRecipes.put(Material.PHANTOM_MEMBRANE, PotionType.SLOW_FALLING);
        fermentations.put(VersionedPotionType.SWIFTNESS, PotionType.SLOWNESS);
        fermentations.put(VersionedPotionType.LEAPING, PotionType.SLOWNESS);
        fermentations.put(VersionedPotionType.HEALING, VersionedPotionType.HARMING);
        fermentations.put(PotionType.POISON, VersionedPotionType.HARMING);
        fermentations.put(PotionType.NIGHT_VISION, PotionType.INVISIBILITY);
    }
}

