/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.items;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.groups.SeasonalItemGroup;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.compatibility.VersionedItemFlag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemGroup
implements Keyed {
    private SlimefunAddon addon;
    protected final List<SlimefunItem> items = new ArrayList<SlimefunItem>();
    protected final NamespacedKey key;
    protected final ItemStack item;
    protected int tier;
    protected boolean crossAddonItemGroup = false;

    @ParametersAreNonnullByDefault
    public ItemGroup(NamespacedKey key, ItemStack item) {
        this(key, item, 3);
    }

    @ParametersAreNonnullByDefault
    public ItemGroup(NamespacedKey key, ItemStack item, int tier) {
        Validate.notNull(key, "An item group's NamespacedKey must not be null!");
        Validate.notNull(item, "An item group's ItemStack must not be null!");
        this.item = item;
        this.key = key;
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        meta.addItemFlags(new ItemFlag[]{VersionedItemFlag.HIDE_ADDITIONAL_TOOLTIP});
        this.item.setItemMeta(meta);
        this.tier = tier;
    }

    @Nonnull
    public final NamespacedKey getKey() {
        return this.key;
    }

    public void register(@Nonnull SlimefunAddon addon) {
        Validate.notNull(addon, "The Addon cannot be null");
        if (this.isRegistered()) {
            throw new UnsupportedOperationException("This ItemGroup has already been registered!");
        }
        this.addon = addon;
        Slimefun.getRegistry().getAllItemGroups().add(this);
        this.sortCategoriesByTier();
    }

    public boolean isRegistered() {
        return this.addon != null && Slimefun.getRegistry().getAllItemGroups().contains(this);
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
        if (this.isRegistered()) {
            this.sortCategoriesByTier();
        }
    }

    private void sortCategoriesByTier() {
        List<ItemGroup> categories = Slimefun.getRegistry().getAllItemGroups();
        Collections.sort(categories, Comparator.comparingInt(ItemGroup::getTier));
    }

    @Nullable
    public final SlimefunAddon getAddon() {
        return this.addon;
    }

    public void add(@Nonnull SlimefunItem item) {
        Validate.notNull(item, "Cannot add null Items to an ItemGroup!");
        if (this.items.contains(item)) {
            return;
        }
        if (this.isRegistered() && !this.isCrossAddonItemGroup() && !item.getAddon().getName().equals(this.addon.getName())) {
            item.warn("This item does not belong into ItemGroup " + String.valueOf(this) + " as that group belongs to " + this.addon.getName());
        }
        this.items.add(item);
    }

    public void remove(@Nonnull SlimefunItem item) {
        Validate.notNull(item, "Cannot remove null from an ItemGroup!");
        this.items.remove(item);
    }

    @Nonnull
    public ItemStack getItem(@Nonnull Player p) {
        return new CustomItemStack(this.item, meta -> {
            String name = Slimefun.getLocalization().getItemGroupName(p, this.getKey());
            if (name == null) {
                name = this.item.getItemMeta().getDisplayName();
            }
            if (this instanceof SeasonalItemGroup) {
                meta.setDisplayName(String.valueOf(ChatColor.GOLD) + name);
            } else {
                meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + name);
            }
            meta.setLore(Arrays.asList("", String.valueOf(ChatColor.GRAY) + "\u21e8 " + String.valueOf(ChatColor.GREEN) + Slimefun.getLocalization().getMessage(p, "guide.tooltips.open-itemgroup")));
        });
    }

    @Nonnull
    public String getUnlocalizedName() {
        return ChatColor.stripColor((String)this.item.getItemMeta().getDisplayName());
    }

    @Nonnull
    public String getDisplayName(@Nonnull Player p) {
        String localized = Slimefun.getLocalization().getItemGroupName(p, this.getKey());
        if (localized != null) {
            return localized;
        }
        return this.getUnlocalizedName();
    }

    @Nonnull
    public List<SlimefunItem> getItems() {
        return this.items;
    }

    public boolean contains(@Nullable SlimefunItem item) {
        return item != null && this.items.contains(item);
    }

    public boolean isAccessible(@Nonnull Player p) {
        return true;
    }

    public boolean isVisible(@Nonnull Player p) {
        if (this.items.isEmpty() || !this.isAccessible(p)) {
            return false;
        }
        for (SlimefunItem slimefunItem : this.getItems()) {
            if (slimefunItem.isHidden() || slimefunItem.isDisabledIn(p.getWorld())) continue;
            return true;
        }
        return false;
    }

    public boolean isCrossAddonItemGroup() {
        return this.crossAddonItemGroup;
    }

    public void setCrossAddonItemGroup(boolean crossAddonItemGroup) {
        this.crossAddonItemGroup = crossAddonItemGroup;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof ItemGroup) {
            ItemGroup group = (ItemGroup)obj;
            return group.getKey().equals((Object)this.getKey());
        }
        return false;
    }

    public final int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {" + String.valueOf(this.key) + ",tier=" + this.tier + "}";
    }

    @Deprecated
    public boolean isHidden(@Nonnull Player p) {
        return !this.isVisible(p);
    }
}

