/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.autocrafters;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.services.MinecraftRecipeService;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.autocrafters.AbstractAutoCrafter;
import io.github.thebusybiscuit.slimefun4.implementation.items.autocrafters.AbstractRecipe;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.AsyncRecipeChoiceTask;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.CommonPatterns;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class VanillaAutoCrafter
extends AbstractAutoCrafter {
    @ParametersAreNonnullByDefault
    public VanillaAutoCrafter(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Override
    @Nullable
    public AbstractRecipe getSelectedRecipe(@Nonnull Block b) {
        Skull skull;
        PersistentDataContainer container;
        String value;
        BlockState state = PaperLib.getBlockState(b, false).getState();
        if (state instanceof Skull && (value = (String)(container = (skull = (Skull)state).getPersistentDataContainer()).get(this.recipeStorageKey, PersistentDataType.STRING)) != null) {
            String[] values = CommonPatterns.COLON.split(value);
            NamespacedKey key = new NamespacedKey(values[0], values[1]);
            Recipe keyedRecipe = Slimefun.getMinecraftRecipeService().getRecipe(key);
            if (keyedRecipe != null) {
                boolean enabled = !container.has(this.recipeEnabledKey, PersistentDataType.BYTE);
                AbstractRecipe recipe = AbstractRecipe.of(keyedRecipe);
                recipe.setEnabled(enabled);
                return recipe;
            }
        }
        return null;
    }

    @Override
    protected boolean matches(@Nonnull ItemStack item, @Nonnull Predicate<ItemStack> predicate) {
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        if (sfItem == null || sfItem.isUseableInWorkbench()) {
            return super.matches(item, predicate);
        }
        return false;
    }

    @Override
    protected void updateRecipe(@Nonnull Block b, @Nonnull Player p) {
        ItemStack item = p.getInventory().getItemInMainHand();
        List<Recipe> recipes = this.getRecipesFor(item);
        if (recipes.isEmpty()) {
            Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.auto-crafting.no-recipes");
        } else {
            ChestMenu menu = new ChestMenu(this.getItemName());
            menu.setPlayerInventoryClickable(false);
            menu.setEmptySlotsClickable(false);
            ChestMenuUtils.drawBackground(menu, this.background);
            ChestMenuUtils.drawBackground(menu, 45, 47, 48, 50, 51, 53);
            AsyncRecipeChoiceTask task = new AsyncRecipeChoiceTask();
            this.offerRecipe(p, b, recipes, 0, menu, task);
            menu.open(p);
            task.start(menu.toInventory());
            SoundEffect.VANILLA_AUTO_CRAFTER_UPDATE_RECIPE_SOUND.playAt(p.getLocation(), SoundCategory.PLAYERS);
        }
    }

    @ParametersAreNonnullByDefault
    private void offerRecipe(Player p, Block b, List<Recipe> recipes, int index, ChestMenu menu, AsyncRecipeChoiceTask task) {
        Validate.isTrue(index >= 0 && index < recipes.size(), "page must be between 0 and " + (recipes.size() - 1));
        menu.replaceExistingItem(46, ChestMenuUtils.getPreviousButton(p, index + 1, recipes.size()));
        menu.addMenuClickHandler(46, (pl, slot, item, action) -> {
            if (index > 0) {
                SoundEffect.AUTO_CRAFTER_GUI_CLICK_SOUND.playFor(pl);
                this.offerRecipe(p, b, recipes, index - 1, menu, task);
            }
            return false;
        });
        menu.replaceExistingItem(52, ChestMenuUtils.getNextButton(p, index + 1, recipes.size()));
        menu.addMenuClickHandler(52, (pl, slot, item, action) -> {
            if (index < recipes.size() - 1) {
                SoundEffect.AUTO_CRAFTER_GUI_CLICK_SOUND.playFor(pl);
                this.offerRecipe(p, b, recipes, index + 1, menu, task);
            }
            return false;
        });
        AbstractRecipe recipe = AbstractRecipe.of(recipes.get(index));
        menu.replaceExistingItem(49, new CustomItemStack(Material.CRAFTING_TABLE, String.valueOf(ChatColor.GREEN) + Slimefun.getLocalization().getMessage(p, "messages.auto-crafting.select"), new String[0]));
        menu.addMenuClickHandler(49, (pl, slot, item, action) -> {
            this.setSelectedRecipe(b, recipe);
            pl.closeInventory();
            SoundEffect.AUTO_CRAFTER_GUI_CLICK_SOUND.playFor(pl);
            Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.auto-crafting.recipe-set");
            this.showRecipe(p, b, recipe);
            return false;
        });
        task.clear();
        recipe.show(menu, task);
    }

    @Nonnull
    private List<Recipe> getRecipesFor(@Nonnull ItemStack item) {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        MinecraftRecipeService recipeService = Slimefun.getMinecraftRecipeService();
        for (Recipe recipe : recipeService.getRecipesFor(item)) {
            if (!(recipe instanceof ShapedRecipe) && !(recipe instanceof ShapelessRecipe)) continue;
            recipes.add(recipe);
        }
        return recipes;
    }
}

