/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.github;

import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubService;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.TriStateOptional;
import io.github.thebusybiscuit.slimefun4.utils.HeadTexture;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;

public class Contributor {
    private final String githubUsername;
    private final String minecraftUsername;
    private final String profileLink;
    private final ConcurrentMap<String, Integer> contributions = new ConcurrentHashMap<String, Integer>();
    private final TriStateOptional<String> headTexture = TriStateOptional.createNew();
    private Optional<UUID> uuid = Optional.empty();

    public Contributor(@Nonnull String minecraftName, @Nonnull String profile) {
        Validate.notNull(minecraftName, "Username must never be null!");
        Validate.notNull(profile, "The profile cannot be null!");
        this.githubUsername = profile.substring(profile.lastIndexOf(47) + 1);
        this.minecraftUsername = minecraftName;
        this.profileLink = profile;
    }

    public Contributor(@Nonnull String username) {
        Validate.notNull(username, "Username must never be null!");
        this.githubUsername = username;
        this.minecraftUsername = username;
        this.profileLink = null;
    }

    public void setContributions(@Nonnull String role, int commits) {
        Validate.notNull(role, "The role cannot be null!");
        Validate.isTrue(commits >= 0, "Contributions cannot be negative");
        this.contributions.put(role, commits);
    }

    @Nonnull
    public String getName() {
        return this.githubUsername;
    }

    @Nonnull
    public String getMinecraftName() {
        return this.minecraftUsername;
    }

    @Nullable
    public String getProfile() {
        return this.profileLink;
    }

    @Nonnull
    public List<Map.Entry<String, Integer>> getContributions() {
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(this.contributions.entrySet());
        list.sort(Comparator.comparingInt(entry -> -((Integer)entry.getValue()).intValue()));
        return list;
    }

    public int getContributions(@Nonnull String role) {
        Validate.notNull(role, "The role cannot be null!");
        return this.contributions.getOrDefault(role, 0);
    }

    public void setUniqueId(@Nullable UUID uuid) {
        this.uuid = uuid == null ? Optional.empty() : Optional.of(uuid);
    }

    @Nonnull
    public Optional<UUID> getUniqueId() {
        return this.uuid;
    }

    @Nonnull
    public String getTexture() {
        return this.getTexture(Slimefun.getGitHubService());
    }

    @Nonnull
    protected String getTexture(@Nonnull GitHubService github) {
        if (!this.headTexture.isComputed() || !this.headTexture.isPresent()) {
            String cached = github.getCachedTexture(this.githubUsername);
            if (cached != null) {
                return cached;
            }
            return HeadTexture.UNKNOWN.getTexture();
        }
        return this.headTexture.get();
    }

    public boolean hasTexture() {
        return this.headTexture.isComputed();
    }

    public void setTexture(@Nullable String skin) {
        this.headTexture.compute(skin);
    }

    public int getTotalContributions() {
        return this.contributions.values().stream().mapToInt(Integer::intValue).sum();
    }

    @Nonnull
    public String getDisplayName() {
        return String.valueOf(ChatColor.GRAY) + this.githubUsername + (String)(!this.githubUsername.equals(this.minecraftUsername) ? String.valueOf(ChatColor.DARK_GRAY) + " (MC: " + this.minecraftUsername + ")" : "");
    }

    public int getPosition() {
        return -this.getTotalContributions();
    }
}

