/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.function.Consumer;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public interface InventoryBlock {
    public int[] getInputSlots();

    public int[] getOutputSlots();

    default public void createPreset(SlimefunItem item, Consumer<BlockMenuPreset> setup) {
        this.createPreset(item, item.getItemName(), setup);
    }

    default public void createPreset(final SlimefunItem item, String title, final Consumer<BlockMenuPreset> setup) {
        new BlockMenuPreset(item.getId(), title){

            @Override
            public void init() {
                setup.accept(this);
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.INSERT) {
                    return InventoryBlock.this.getInputSlots();
                }
                return InventoryBlock.this.getOutputSlots();
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                if (p.hasPermission("slimefun.inventory.bypass")) {
                    return true;
                }
                return item.canUse(p, false) && (Slimefun.instance().isUnitTest() || Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.INTERACT_BLOCK));
            }
        };
    }
}

