/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils.compatibility;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.potion.PotionEffectType;

public class VersionedPotionEffectType {
    public static final PotionEffectType SLOWNESS;
    public static final PotionEffectType HASTE;
    public static final PotionEffectType MINING_FATIGUE;
    public static final PotionEffectType STRENGTH;
    public static final PotionEffectType INSTANT_HEALTH;
    public static final PotionEffectType INSTANT_DAMAGE;
    public static final PotionEffectType JUMP_BOOST;
    public static final PotionEffectType NAUSEA;
    public static final PotionEffectType RESISTANCE;

    @Nullable
    private static PotionEffectType getKey(@Nonnull String key) {
        try {
            Field field = PotionEffectType.class.getDeclaredField(key);
            return (PotionEffectType)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        MinecraftVersion version = Slimefun.getMinecraftVersion();
        SLOWNESS = version.isAtLeast(MinecraftVersion.MINECRAFT_1_20_5) ? PotionEffectType.SLOWNESS : VersionedPotionEffectType.getKey("SLOW");
        HASTE = version.isAtLeast(MinecraftVersion.MINECRAFT_1_20_5) ? PotionEffectType.HASTE : VersionedPotionEffectType.getKey("FAST_DIGGING");
        MINING_FATIGUE = version.isAtLeast(MinecraftVersion.MINECRAFT_1_20_5) ? PotionEffectType.MINING_FATIGUE : VersionedPotionEffectType.getKey("SLOW_DIGGING");
        STRENGTH = version.isAtLeast(MinecraftVersion.MINECRAFT_1_20_5) ? PotionEffectType.STRENGTH : VersionedPotionEffectType.getKey("INCREASE_DAMAGE");
        INSTANT_HEALTH = version.isAtLeast(MinecraftVersion.MINECRAFT_1_20_5) ? PotionEffectType.INSTANT_HEALTH : VersionedPotionEffectType.getKey("HEAL");
        INSTANT_DAMAGE = version.isAtLeast(MinecraftVersion.MINECRAFT_1_20_5) ? PotionEffectType.INSTANT_DAMAGE : VersionedPotionEffectType.getKey("HARM");
        JUMP_BOOST = version.isAtLeast(MinecraftVersion.MINECRAFT_1_20_5) ? PotionEffectType.JUMP_BOOST : VersionedPotionEffectType.getKey("JUMP");
        NAUSEA = version.isAtLeast(MinecraftVersion.MINECRAFT_1_20_5) ? PotionEffectType.NAUSEA : VersionedPotionEffectType.getKey("CONFUSION");
        RESISTANCE = version.isAtLeast(MinecraftVersion.MINECRAFT_1_20_5) ? PotionEffectType.RESISTANCE : VersionedPotionEffectType.getKey("DAMAGE_RESISTANCE");
    }
}

